;;
;; Draws a dragon fractal curve using turtle graphics.
;; load "turtle.lsp" first then try: (dragon-curve 12).
;;
(define (dragon sign level)
       (if (= 0 level) (turtle-forward 1)
	      (begin
	         (set 'level (- level 1))
		 (turtle-right (* 45 sign))
		 (dragon -1 level)
		 (turtle-left (* 90 sign))
		 (dragon 1 level)
		 (turtle-right (* 45 sign)))))

;;
;; (Note how '+' operator is passed as an argument)
;;
(define (dragon-curve n)
       (turtle-center)
       (dragon + n))

    

