;;
;; (lg x) ; decimal logarithm
;;
(define (lg x) (div (log x) (log 10)))


;;
;; (ld x) ; dualis logarithm
;;
(define (ld x) (div (log x) (log 2)))



;;
;; (power number exponent)
;;
(define (power number exponent)
  (exp (mul exponent (log number))))



;; various constants
;;
(set 'pi (mul (atan 1.0) 4))
(set 'e (exp 1))


;;
;; Calculate average of a list of numbers of mixed ints / floats
;;
(define (average listX)
	(div (apply add listX) (length listX)))
	

;;
;; Calculates sum of squares of mixed integers / floats
;
(define (sum-squares listX)
	(apply add (map (lambda (x) (mul x x)) listX)))


;;
;; Calculates sum of products of mixed integers / floats
;;
(define (sum-products listA listB)
	(apply add (map (lambda (x y) (mul x y)) listA listB)))
	
	
;;
;; variance standard deviation of mixed integers / floats
;;
(define (variance listX)
	(sub (div (sum-squares listX) (length listX)) 
		  (mul (average listX) (average listX))))

(define (standard-dev listX)
	(sqrt (variance listX)))



;; end of file 
