(define (down-handler )
  (scale 0 0)
  (rect 'init (mouse-x) (mouse-y))
  (mouse-move-event 'move-handler))

(define (up-handler )
  (mouse-move-event 'nil))

(define (move-handler )
  (rect 'stretch (mouse-x) (mouse-y)))

(define (rect procedure new-x new-y | x y wd ht)
  (case procedure 
   ('init 
    (rect-init)) 
   ('stretch 
    (rect-stretch))))

(define (rect-draw )
  (line x y (+ x wd) y (+ x wd) (+ y ht) x (+ y ht) x y))

(define (rect-init )
  (pen 0 0 0)
  (rasterop 6)
  (set 'x new-x)
  (set 'y new-y)
  (set 'wd 1)
  (set 'ht 1)
  (rect-draw))

(define (rect-stretch )
  (rect-draw)
  (set 'wd (if 
    (> (mouse-x) x) 
    (- (mouse-x) x) 
    (- x (mouse-x))))
  (set 'ht (if 
    (> (mouse-y) y) 
    (- (mouse-y) y) 
    (- y (mouse-y))))
  (rect-draw))

(mouse-down-event 'down-handler)
(mouse-up-event 'up-handler)

(clear-screen)

(print "Move the mouse while pressing a button\n")






