;;
;; Turtle Graphics Procedures
;;
;; Note that this is a object oriented aproach packaging data and and
;; function calls together into 'turtle'. Using:
;;
;;	 (set 'myTurtle turtle)
;; 
;; multiple turtles could be created.  These turtles would share the
;; different methods (forward, left, right, etc. ) but each have
;; their own internal state of position and direction.  Dynamic scoping
;; takes care,  that only the state variables of the "calling" turtle
;; are changed.
;;
;; See functions 'rose-A', 'rose-B' at the edn of this file, which
;; are using turtle graphics.  See also file "dragon.lsp".
;;
(define (turtle selector p1 p2 p3 | lastX lastY newX newY direction)
    (case selector
	('setup (turtle-setup))
	('center (turtle-center))
	('forward (turtle-forward))
	('left (turtle-left))
	('right (turtle-right))
	('go-to (turtle-go-to))))

(define (turtle-setup)
  (rasterop 0)
  (scale 200 -200)
  (origin 100 100)
  (turtle-center))

(define (turtle-center )
  (pen 0 0 0)
  (set 'lastX 0)
  (set 'lastY 0)
  (set 'newX 0)
  (set 'newY 0)
  (set 'direction 1.570796327))		; pi / 2

(define (turtle-forward)
  (set 'newX (add lastX 
    (mul (cos direction) p1)))
  (set 'newY (add lastY 
    (mul (sin direction) p1)))
  (line lastX lastY newX newY)
  (set 'lastX newX)
  (set 'lastY newY))

(define (turtle-go-to)
  (set 'lastX p1)
  (set 'lastY p2))

(define (turtle-left)
  (set 'direction (add direction 
    (mul p1 0.017453292))))		; pi / 180

(define (turtle-right)
  (set 'direction (sub direction 	; pi / 180
    (mul p1 0.017453292))))




;;;;;;;;;;;;;;;;;;;;;;;; turtle demo routines ;;;;;;;;;;;;;;;;;;;;;;;;


;;
;;	make a rectangle
;;
(define (draw-rect n)
  (turtle 'forward n)
  (turtle 'right 90)
  (turtle 'forward n)
  (turtle 'right 90)
  (turtle 'forward n)
  (turtle 'right 90)
  (turtle 'forward n))


;;
;; 	make a squirl
;;
(define (draw-squirl n)
  (dotimes(x (/ n 3))
    (turtle 'forward n) 
    (turtle 'right 90) 
    (set 'n (- n 2)))(turtle 'go-to 0 0))


;;
;;	make a rose out of rectangles
;;
(define (rose-A )
  (clear-screen)
  (text-font "Times New Roman" 24)
  (text 5 5 "Turtle Graphics" 1)
  (turtle 'setup)
  (pen 0 0 4)
  (dotimes (x 90)
    (draw-rect 70) 
    (turtle 'right 1)))


;;
;;	make a rose out of sqirls
;;
(define (rose-B )
  (clear-screen)
  (text-font "Times New Roman" 24)
  (text 5 5 "Turtle Graphics" 4)
  (turtle 'setup)
  (pen 0 0 1)
  (dotimes (x 45)
    (draw-squirl 70) 
    (turtle 'right 2)))

;;
;;	draw a fractal dragon curve
;;
(define (dragon-curve n)
	(clear-screen)
	(text-font "Times New Roman" 24)
	(text 5 5 "Dragon Curve" 0)
	(scale 120 -120)
	(origin 50 100)
	(turtle 'center)
	(pen 0 0 2)
	(dragon + n))


(define (dragon sign level)
       (if (= 0 level) (turtle 'forward 1)
	      (begin
	         (set 'level (- level 1))
		 (turtle 'right (sign 45))
		 (dragon - level)
		 (turtle 'left (sign 90))
		 (dragon + level)
		 (turtle 'right (sign 45)))))
		 

;; end of file ;;

