; Copyright 1994 Apteryx Lisp Ltd

; Use the mouse to move the cursor to the next line
; and press F4 to evaluate it. See the result in the
; LispOutput window

(+ 2 3)

; Congratulations, you've just executed your first lisp program !
; Can you see what it did ?        (Answer: 2 + 3 = 5)

; Here's another

(+ 2 (* 4 10))

; * means multiply

; (+ 2 3) is a list with 3 members - the symbol + and the numbers 2
; and 3.
; When you press F4 you evaluate the list. + is the name of a function
; and 2 and 3 are the arguments. + is applied to its arguments and
; returns a result, which for + is the sum of the arguments.

; Similiarly (* 4 10) when evaluated returns the result of multiplying
; 4 times 10. (To see this, select the expression using the mouse
; and then press F4.)

; In (+ 2 (* 4 10)) the second argument to the + is the list (* 4 10).
; This list argument is evaluated first, to give 40, and this result
; is then passed as the actual second argument to the function + which
; returns the result 42.

; Here's a program that counts the number of elements in a list -

(length '(a b c d e))

; length is a function which returns the number of elements in a list.
; The one and only argument to length is '(a b c d e). What the ' quote
; character means is don't try to evaluate this list (as was done with
; (* 4 10) in the example above), but pass it unchanged to the function.
; '(a b c d e) is an abbreviation for (quote (a b c d e)). 
; The members of (a b c d e) are a, b, c, d and e which are all symbols.
; ' is needed before list or symbol arguments that aren't meant to be
; evaluated - its optional but unnecessary before other types of argument
; For example - 

(+ '2 '3)

; or

(+ (quote 2) (quote 3))

; cons is a function that puts a new element onto the beginning of 
; a list.
; Evaluate the following - 

(cons 'a '(b c d e))

; And now make your own function - here's a function that multiplies
; a number by itself

(defun square (x) (* x x)) ; F4 to make the function

(square 5)   ; F4 here to try it out

; looking at (defun square (x) (* x x))

; defun is the special form (not a function as such because it doesn't
; evaluate its arguments)
; square is the name of the new function
; (x) is the argument list - the symbol x represents the one and only
; argument that the function is going to take
; (* x x) is the expression that is evaluated to give the final result
; In the expression (* x x) the x's are evaluated to the value of the
; argument x passed in when square is actually used
; i.e. in (square 5) the x's evaluate to 5, and (* 5 5) is evaluated
; to give the final result.

(mapcar #'square '(1 2 3 4 5))

; mapcar applies its first argument to each member of the list passed
; as second argument, and returns a list made from the results.
; ( #'square means the function referred to by the symbol square. )

