/* Prototypes for Sega and Powerglove (and timer) support */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

#include "standard.hpp"

/*
 sega_switcher is called just before the vertical retrace
 use NULL if no video synchronization desired

 glove_handler is called once or more per screen time
 use NULL if not required

 glove_tc is period in timer clocks (1.19 * microseconds) desired between
 glove_handler calls.  If sega_switcher is also used, this will be an
 integer number per screen time.  Use 6500 for best results, as this
 gives the least glitches (2xscreen for 72 Hz, 3xscreen for 60 Hz VGA cards
*/


#define G_NOKEY 0xFF
#define G_START 0x82
#define G_SEL   0x83
#define G_AKEY  0x0A
#define G_BKEY  0x0B
#define G_UP    0x0D
#define G_DOWN  0x0E
#define G_LEFT  0x0C
#define G_RIGHT 0x0F

#define G_RECENTER 0

									/*         2 if rxflags also valid */
#define DEGLITCH   1
#define NODEGLITCH 0

/* gesture recognition */

#define G_FLAT      0       	/* std. gesture classification */
#define G_THUMB_IN  1
#define G_INDEX_IN  2
#define G_MIDDLE_IN 3
#define G_RING_IN   4
#define G_PINCH     5
#define G_FIST      6
#define G_THUMB_OUT 7
#define G_POINT     8
#define G_BADFINGER 9
#define G_RING_OUT  10
#define G_UNKNOWN   11


/**************** SEGA SUPPORT ****************/

extern int left_page;     /* video page with current left image */
extern int right_page;    /* video page with current right image */
extern int has_switched;  /* = 3 once both switched in */

// Following modified by mark:
//  Returns zero instead of exit()ing in case of error.
extern Boolean init_switch_driver(char *sdname);

extern void switch_sega(int to_go);     /* video, glasses switcher: pass to SGinit */

extern void sega_off();        /* turn off glasses at exit (longer life) */

extern void select_sega_port(int port);

/************** SEGA/GLOVE PARAMETERS *************/

extern int sega_address;
extern int sega_port_image;
extern int sega_mask;

extern int sega_left;
extern int sega_right;
extern int sega_doff;

/* End of segasupp.h */
