/* Functions related to splits and areas */

/* Written by Bernie Roehl, June 1992 */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

/********** AAAAHHHHH!  Make it stop!
#ifndef SPLITDEF
#define SPLITDEF 1
typedef void SPLIT;
#endif

#ifndef AREADEF
#define AREADEF 1
typedef void AREA;
#endif
*********************/

#include "splitdef.h"

SPLIT *add_split(SPLIT **tree, long x, long y, long z,
			long nx, long ny, long nz, unsigned flags);
AREA *what_area(SPLIT *tree, long x, long y, long z);
void add_obj_to_area(AREA *a, OBJECT *obj);
void add_obj_to_split(SPLIT *tree, OBJECT *obj);

void split_move_handler(OBJECT *obj);
void initial_world_split(SPLIT **split_ptr);
void set_global_split_root(SPLIT **split_tree);
extern SPLIT **global_split_root;

OBJLIST *which_area_objlist(SPLIT *tree, long x, long y, long z);
OBJLIST *which_objlist(SPLIT *tree, long x, long y, long z);
void add_obj_to_split_area(SPLIT *tree, OBJECT *obj);
void add_obj_to_split_center(SPLIT *tree, OBJECT *obj);

void render_monitor_point(int x, int y);
OBJECT *render_check_monitor(int *poly, int *vert);
void render_objlist(OBJLIST *objlist);
void render_area(AREA *a);
void render_subtree(int type, SPLIT *ptr, VIEW *view);
void render_split(SPLIT *tree, VIEW *view);
void render_visareas(AREA *area);
void walk_area(AREA *a, void (*fn)());
void walk_split_tree(SPLIT *tree, void (*fn)(OBJECT *));
void set_area_function(AREA *a, void (*fn)());
void call_area_fn(AREA *a);
void add_floor(AREA *area, long a, long b, long c, long d);
void add_ceiling(AREA *area, long a, long b, long c, long d);
long floor_at(AREA *a, long x, long z);
long ceiling_at(AREA *a, long x, long z);
int add_visfrom(AREA *from, AREA *to);

/* End of splits.h */
