/* Functions related to the simple "multi-tasker" */

/* Written by Bernie Roehl, June 1992 */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

typedef struct _task TASK;

struct _task {
	void (*fn)(int cmd, void *msg, long now, long period);
	void *data;
	long period, lastran, wakeup;
	TASK *next;
};

TASK *get_current_task();
TASK *add_task(TASK **tasklist, void (*fn)(int, void *, long, long), long period, void *param);
void del_task(TASK **tasklist, TASK *tsk);
void run_tasks(TASK *tasklist);
void *find_task_data(TASK *task);

/* End of tasks.h */
