//
// GestSet.hpp:
//	Interface Definition of classes priorityMechanism, GestureSet,
//	RecognizableList, and AbsGestSet.  Part of Court Jesture library.
//
// Copyright 1993   Mark Thomas Pflaging
//
// Date:	   3/22/93 (Release 3.0)
//
#ifndef __GESTSET_HPP
#define __GESTSET_HPP

#include "gesture.hpp"

class priorityMechanism : Vector<long> {
	void fixLast();

public:
	priorityMechanism(size_t elements) : Vector<long>(elements) {}
	Vector<long> & operator+=(long & p);
	Vector<long> & operator-=(long & p);
	long findHighest();
};

typedef ListElement<Recognizable> GestHandle;

class RecognizableList : public LinkList<Recognizable> {
	static Comparator<Recognizable> finder;
	static Boolean greaterThan(Recognizable & arg1, Recognizable & arg2);
	static Boolean equalTo(Recognizable & arg1, Recognizable & arg2);
	void sortedInsert(GestHandle & gesture) {
		finder.setValue(&gesture);
		LinkList<Recognizable>::sortedInsert(finder);
	}
	void findAndRemove(GestHandle & gesture) {
		finder.setValue(&gesture);
		LinkList<Recognizable>::findAndRemove(finder);
	}
	int len;

protected:
	static Boolean dump(LinkList<Recognizable> &that, void * where);

public:
	RecognizableList() : LinkList<Recognizable>(), len(0) {}
	RecognizableList(RecognizableList & arg) { *this = arg; }
	RecognizableList & operator=(RecognizableList & arg) {
		len = arg.len;
		LinkList<Recognizable>::operator=(arg);
		return *this;
	}
	RecognizableList & operator+(GestHandle & gesture) {
		int templen = (gesture.getData()).getLength();
		if (templen > len) len = templen;
		sortedInsert(gesture);
		return *this;
	}
	RecognizableList & operator-(GestHandle & gesture) {
		// Should we change len if this was the longest gesture
		// in the list?  I don't think we need to bother,
		// since it's ok if the sample buffer is too long.
		findAndRemove(gesture);
		return *this;
	}
	virtual GestHandle & add(char * text) {
		Gesture & gest = *(new Gesture);
		gest.setFromText(text);
		GestHandle & retval = *(new ListElement<Recognizable>);
		 retval.setData(&gest);
		*this + retval;
		return retval;
	}
	ostream & dump(ostream & where) {
		doFunc(dump, &where);
		return where;
	}
	int getLen() { return len; }
};

class GestureSystem;

class AbsGestSet {
public:
	virtual void Setup() = 0;
	virtual void Register(Gesture & found, Boolean offOrOn) = 0;
};

class GestureSet : public RecognizableList, private priorityMechanism, public StringName,
    public Activator, public AbsGestSet {
	Boolean CheckPriority(Recognizable & popped, Boolean onOrOff);
	friend class GestureSystem;
	long active_priority;
	static Boolean killGest(LinkList<Recognizable> & here, void * dumb) {
		Recognizable & what = here.currentData();
		delete &(what.getData());
		return True;
	}

public:
	// You might need the priorityMechanism to be a little
	// longer than the QueueVector, but I seriously doubt it.
	GestureSet(char * name = NULL) :
		priorityMechanism(15), active_priority(0), StringName(name) {}
	GestureSet(GestureSet & arg) : priorityMechanism(15) { *this = arg; }
	GestureSet & operator =(GestureSet & arg) {
		if (!arg.isOn()) {
			active_priority = 0;
			RecognizableList::operator=(arg);
			StringName::operator=(arg);
		}
		return *this;
	}
	virtual ~GestureSet() {}
	virtual void killAssociatedGestures() {
		doFunc(killGest, NULL);
		clearList();
        }
	virtual void Register(Gesture & found, Boolean offOrOn) {
		found.Register(offOrOn);
	}
	void setName(char *arg) { StringName::setName(arg); }
	void Setup() {}
	GestureSet & operator+(Gesture * arg) {
                if (!isOn()) {
			ListElement<Recognizable> & added = *(new ListElement<Recognizable>);
			added.setData(arg);
			RecognizableList::operator+(added);
                }
		return *this;
	}
	GestureSet & operator-(Gesture * arg) {
		if (!isOn()) {
			// Two Recognizables are equal when they point to the
			// same Gesture.  Need to make a fake recognizable
			// for the purposes of 'equalTo()'.
			ListElement<Recognizable> temp;
			temp.setData(arg);
			RecognizableList::operator-(temp);
		}
		return *this;
	}
};

#endif
