/* Very simple, non-preemptive, multitasking system
   with round-robin scheduling */

/* Written by Bernie Roehl, June 1992 */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

#include <stdio.h>
#include <alloc.h>  /* malloc() */
#include "rend386.hpp"  /* for current_time() */
#include "tasks.hpp"

#include "isr.hpp"

static TASK *current_task = NULL;

TASK *get_current_task()
{
	return current_task;
}

TASK *add_task(TASK **tasklist, void (*fn)(int, void *, long, long), long period, void *param)
{
	TASK *t;
	if ((t = (TASK *)malloc(sizeof(TASK))) == NULL) return NULL;
	t->fn = fn; 
	t->data = NULL; 
	t->period = period;
	t->lastran = 0L; 
	t->wakeup = segaISR::currentTime();
	t->next = *tasklist;
	current_task = *tasklist = t;
	if (fn) (*fn)(0, param, segaISR::currentTime(), period); /* initialize */
	return t;
}

void del_task(TASK **tasklist, TASK *tsk)
{
	TASK *t;
	if (tsk == NULL) return;
	if (tsk == *tasklist)
		*tasklist = tsk->next;
	else
		for (t = *tasklist; t; t = t->next)
		if (t->next == tsk) {
			t->next = tsk->next;
			break;
		}
	free(tsk);
}

void *find_task_data(TASK *task)
{
	return &task->data;
}

void run_tasks(TASK *tasklist)
{
	long now;
	now = segaISR::currentTime();
	for (current_task = tasklist; current_task; current_task = current_task->next) {
		if (current_task->fn && (now >= current_task->wakeup)) {
			current_task->wakeup = now + current_task->period;
			current_task->fn(1, NULL, now, current_task->period);
			current_task->lastran = now;
		}
	}
}

