// Set the machine timings in glove.ini.
// Copyright 1993 Mark Pflaging
#include "ini.hpp"
#include "hardware.hpp"

machineTimer * D2BYTES, * D2BITS, * D2SLOW;

char * title = "Timings";

void calibrate(InitFile & ini)
{
	D2BITS = new machineTimer(
		ini.find(title, "D2BITS", 15), NULL
		);
	D2BYTES = new machineTimer(
		ini.find(title, "D2BYTES", 70), NULL
		);
	D2SLOW = new machineTimer(
		ini.find(title, "D2SLOW", 1000), NULL
		);
}

#include <stdio.h>

void doForce(machineTimer & arg, char * variable, InitFile & ini)
{
	cout << "N/D=" << int(arg.getNum()) << "/" << int(arg.getDen()) << " for ";
	cout << (arg.getVal()) << "usec delay.";
	cout << " (100 sample avg. = " << abs(arg.getTestValue()) << " usec)";
	cout << endl;
	char temp[80];
	strcpy(temp, variable);
	strcat(temp, ".N");
	char temp2[80];
	sprintf(temp2, "%d", int(arg.getNum()));
	ini.forceIn(title, temp, temp2);
	strcpy(temp, variable);
	strcat(temp, ".D");
	sprintf(temp2, "%d", int(arg.getDen()));
	ini.forceIn(title, temp, temp2);
}

main()
{
	InitFile gloveIni("glove.ini");
	if (gloveIni.getStatus() == Key::FileDidNotExist) {
		 cout << "Cannot open \"glove.ini\".  Exiting." << endl;
		 exit(-1);
	}
	if (gloveIni.getStatus() == Key::ErrorReadingFile) {
		 cout << "Error in \"glove.ini\".  Exiting." << endl;
		 exit(-1);
	}
	calibrate(gloveIni);
	doForce(*D2BITS, "D2BITS", gloveIni);
	doForce(*D2BYTES, "D2BYTES", gloveIni);
	doForce(*D2SLOW, "D2SLOW", gloveIni);
	gloveIni.write();
	cout << endl << "These values have been written to \"GLOVE.INI\"." << endl;
	return 0;
}
