
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

unsigned char min;
unsigned char max;
unsigned char ca;
unsigned short ra;
unsigned long la;
FILE *fp;
char gstring[80];
unsigned long rID;
unsigned long rLen;
unsigned long wID;
unsigned long fID;
unsigned long fLen;
unsigned long fNext;
unsigned short wFormatTag;
unsigned short nChannels;
unsigned short nSamplesPerSec;
unsigned short nAvgBytesPerSec;
unsigned long dID;
unsigned long dLen;

void main ( int argc, char *argv[] )
{
    if(argc==1)
    {
        printf(".WAV file not specified\n");
        exit(1);
    }
    strcpy(gstring,argv[1]);
    strcat(gstring,".WAV");
    if((fp=fopen(gstring,"rb"))==0)
    {
        strcpy(gstring,argv[1]);
        if((fp=fopen(gstring,"rb"))==0)
        {
            printf("Error opening .WAV file [%s]\n",argv[1]);
            exit(1);
        }
    }
    printf("FILE:  [%s]\n",gstring);
    fread(&rID,1,4,fp);
    if(rID!=0x46464952)
    {
        printf("Not a RIFF format file\n");
        exit(1);
    }
    fread(&rLen,1,4,fp);
    printf("rLen = %lu\n",rLen);
    fread(&wID,1,4,fp);
    if(wID!=0x45564157)
    {
        printf("Not a WAVE format chunk\n");
        exit(1);
    }
    fread(&fID,1,4,fp);
    if(fID!=0x20746D66)
    {
        printf("Not a fmt WAVE Format Chunk\n");
        exit(1);
    }
    fread(&fLen,1,4,fp);
    fNext=fLen+ftell(fp);
    printf("fLen %lu\n",fLen);
    printf("fNext %lu\n",fNext);
    fread(&wFormatTag,1,2,fp);
    if(wFormatTag!=1)
    {
        printf("Data is not PCM\n");
    }
    fread(&nChannels,1,2,fp);
    printf("nChannels %u\n",nChannels);
    fread(&nSamplesPerSec,1,2,fp);
    printf("nSamplesPerSec %u\n",nSamplesPerSec);
    fread(&nAvgBytesPerSec,1,2,fp);
    printf("nAvgBytesPerSec %u\n",nAvgBytesPerSec);


//*/fread(&ra,1,2,fp); printf("%04x %u\n",ra,ra);
//*/fread(&ra,1,2,fp); printf("%04x %u\n",ra,ra);
//*/fread(&ra,1,2,fp); printf("%04x %u\n",ra,ra);
//*/fread(&ra,1,2,fp); printf("%04x %u\n",ra,ra);

    fseek(fp,fNext,0);
    fread(&dID,1,4,fp);
    if(dID!=0x61746164)
    {
        printf("Not a DATA chunk\n");
        exit(1);
    }
    fread(&dLen,1,4,fp);
    printf("dLen %lu\n",dLen);
    min=0xFF;
    max=0x00;
    for(la=0;la<dLen;la++)
    {
        fread(&ca,1,1,fp);
        if(ca>max) max=ca;
        if(ca<min) min=ca;
    }
    printf("max %u\n",(unsigned char)max);
    printf("min %u\n",(unsigned char)min);
}
//------------------------------------------------------------------------------
// Copyright (c) David Welch, 1993
//------------------------------------------------------------------------------


