;label   --   
;expects:    image (cermet or chromo) in a
;
#include timdefs.h
parms
  int windis
endparms
int aant
int opp
int num = 2
int maxn
int maxd
float perilen
float shape
int borderpix
int dr_old
int err

cls
dr_old = set 4 128		;drawing value
dest p
show p
copy a
*windispl i windis
bord 0
aant = label -128
*windispl h (windis+NO_DITHER+WINLUT4)
if aant < 5
  print "Wrong image loaded (must be CERMET or CHROMO)"
  stop
endif
mark 1 0          ;remove obj 1 and initialise mark pointer
dest q
era
;err = chk lut 2 4
/selut 4          ;select LUT 4
num = 2
curlock s q 1
curlock r q 1
curlock a q 1       ;non-display images have no default lock
err = chk curlock h q 1	;'h' is not always present

repeat        ;until
    dest q
    maxn = mark p num 248 /   ;0f8h
    if maxn < 20
      era qc
    else
      dest r
      and ac qc
      dest q
      borderpix = maxn - (lcon qc 8)
      bsw qc 8 2 
      bcop qc 2 3
;no non-square pixel correction, image was recorded using SqPix FrameGrabber
      perilen = fcont q 3 1   
      maxd = maxl 3 1 /     ;perform calculation in integer (/)
        ;for accurate measurement of shape we have to correct for 
        ;the effect that the object's border is in the middle of the contour:
        ;we have to substract half of the contour pixels from the area
      shape = (perilen**2)/(12.56637*(maxn-(borderpix/2)))
      dest s
      copy qc sc
      era qc
      print "Obj.",num, @12, "area:",maxn, @24 "perim:", perilen,@40,"diam:",maxd, @50 "shape:", shape
      text s 128 "%d", num
      text r 128 "%d", num
    endif
;    num += 1
     *windispl hc (windis+NO_DITHER)
until ++num > aant

dest s
*windispl h (windis+NO_DITHER)
dest r
*windispl i windis
set 4 dr_old
stop



