UNIT ICONMAN;


INTERFACE

USES DOS,Graph;

VAR
  FLoadResult   : INTEGER;
  ICreateResult : INTEGER;

PROCEDURE OpenIconSystem;
PROCEDURE CloseIconSystem;
PROCEDURE LoadIconFile(Filename : STRING);
PROCEDURE SaveIconFile(Filename : STRING);
PROCEDURE DisplayIcon(Ino : INTEGER; Ix,Iy : INTEGER);
PROCEDURE GetNumberOfIcons(VAR NoIco : INTEGER);
PROCEDURE CreateIcon(Ino : INTEGER; Ix,Iy : INTEGER);
PROCEDURE ReplaceIcon(Ino : INTEGER; Ix,Iy : INTEGER);
PROCEDURE SetIconCount(MaxIco : INTEGER);


IMPLEMENTATION

CONST
  Icon_Size : WORD    = 518;  { Number of bytes per 32x32 bit icon. }
  Max_Icons : INTEGER = 32;   { Maximum number of icons per file.   }

TYPE
  Icon_Record = RECORD        { Makes up Icon_Stack array. }
  Icon_Pointer : POINTER;
  END;

VAR
  Loop         : INTEGER;
  Number_Icons : BYTE;        { Number of icons in current file. }
  F1           : FILE;
  Current_File : STRING;      { Name of current file. }
  result       : WORD;
  HeapTop      : ^WORD;       { Marks bottom of reserved }
                              { space for Icon_Stack.    }

  Icon_Stack   : ARRAY[1..32] OF Icon_Record; { Holds 32 icons }

PROCEDURE OpenIconSystem;
BEGIN
  FOR loop:=1 TO Max_Icons DO
    GetMem(Icon_Stack[Loop].Icon_Pointer, Icon_Size);  { Reserve memory for }
                                                       { all 32 icons       }
END;

PROCEDURE CloseIconSystem;
BEGIN
 FOR loop:=1 TO Max_Icons DO
  BEGIN
    FreeMem(Icon_Stack[Loop].Icon_Pointer,Icon_Size);  { Restore memory taken }
  END;                                                 { by all 32 icons      }
END;

PROCEDURE LoadIconFile(FileName : STRING);
BEGIN
  Assign(f1,FileName);
  FileMode:=0;
  {$I-}
  Reset(f1,1);                   { Reposition file pointer & record len = 1 }
  FloadResult:=IOResult;
  IF FLoadResult=0 THEN
  BEGIN
    Current_File:=FileName;
    BlockRead(f1,Number_Icons,1,result);     { Read number of icons in file }
    FOR Loop:=1 TO Max_Icons DO
    BEGIN
      BlockRead(f1,Icon_Stack[Loop].Icon_Pointer^,Icon_Size,result);    { Read Icon }
    END;
    Close(f1);
  END
  ELSE
    Number_Icons:=0;
END;

PROCEDURE SaveIconFile(FileName : STRING);
BEGIN
  Assign(f1,FileName);
  Rewrite(f1,1);                                  { Clear file & set record size to 1 }
  BlockWrite(f1,Number_Icons,1,result);           { Write Icon number }
  FOR loop:=1 TO Max_Icons Do
  BEGIN
    BlockWrite(f1,Icon_Stack[Loop].Icon_Pointer^,Icon_Size,result);  { Save Icon }
  END;
  Close(f1);
END;

PROCEDURE DisplayIcon(Ino : INTEGER; Ix,Iy : INTEGER);
BEGIN
  IF (Ino<=Number_Icons) AND (Ino>=1) THEN
  PutImage(Ix,Iy,Icon_Stack[Ino].Icon_Pointer^, CopyPut);
END;

PROCEDURE GetNumberOfIcons(VAR NoIco : INTEGER);
BEGIN
  NoIco:=Number_Icons;
END;

PROCEDURE CreateIcon(Ino : INTEGER; Ix,Iy : INTEGER);
BEGIN
  ICreateResult:=0; { Ok }
  IF (Ino<=(Number_Icons+1)) AND (Ino<=Max_Icons) AND (Ix+31<=639)
  AND (Iy+31<=479) THEN
  BEGIN
    Getimage(Ix,Iy,Ix+31,Iy+31,Icon_Stack[Ino].Icon_Pointer^);
    IF (Number_Icons<Max_Icons) THEN INC(Number_Icons);
  END
  ELSE
  BEGIN
    IF (Ino>=(Number_Icons+1)) OR (Ino>Max_Icons) THEN ICreateResult:=1;  { Invalid Icon }
    IF (Ix+31>639) OR (Iy+31>479) THEN ICreateResult:=2;     { Part of the icon would be }
  END;                                                       { grabbed from off screen   }
END;

PROCEDURE ReplaceIcon(Ino : INTEGER; Ix,Iy : INTEGER);
BEGIN
  IF (Ino<=(Number_Icons)) AND (Ix+31<=639)
  AND (Iy+31<=479) THEN
  BEGIN
    Getimage(Ix,Iy,Ix+31,Iy+31,Icon_Stack[Ino].Icon_Pointer^);
  END
END;

PROCEDURE SetIconCount(MaxIco : INTEGER);
BEGIN
   IF (MaxIco>=0) AND (MaxIco<=32) THEN
   BEGIN
     Number_Icons:=MaxIco;
   END;
END;


BEGIN
END.
