/*-------------------------------------------------------------------------*/
/*                    C&C Module Player Version 1.0                        */
/*                   Coded by Chio.T.I, Sep.17,1993                        */
/*-------------------------------------------------------------------------*/                                                                         
/*        {W: &C Module Ʀ쭵ֺta                             */
/*        @: ʭ^                                                     */
/*        : KQG~EQC                                     */
/*-------------------------------------------------------------------------*/     
/*        pGAModuleɩάO֦XDΫĳ, wPڳsC     */
/*        ڪUNIXbO: U2300356@SPARC20.NCU.EDU.TW                      */
/*        άOgH: OWٷs˿˪FjL53                         */
/*-------------------------------------------------------------------------*/

#include<dos.h>
#include<stdio.h>
#include<alloc.h>

#include"fileio.h"                              /* ڦۤvϥΪϺШ禡w  */
#include"sbdma.h"                               /* nQdXʨ禡w        */

#define  NearToFar( i )  MK_FP( FP_SEG( i ), FP_OFF( i ) )
#define  MaxBufferSize  13500
#define  FileOpenError     -1
#define  MemoryNotEnough   -2

/*       HUOModuleɤUӭĽsҥNNq:                         */ 

#define  PORTA_UP       1                       /* nWvW            */     
#define  PORTA_DOWN     2                       /* nWv            */
#define  PORTA_TO_NOTE  3                       /* nWvWλܫwWv*/
#define  VIBRATO        4                       /* Ÿ                    */
#define  VIBRATO_VOL    6                       /* ŸæPɧ@qWλ*/
#define  TREMOLO        7                       /* t@Ÿ              */
#define  VOLUME_SLIDE   10                      /* qWλ          */
#define  JUMP           11                      /* wq            */
#define  SET_VOLUME     12                      /* ]wq                */
#define  BREAK          13                      /* U@Ӭq            */
#define  SET_TEMPO      15                      /* ]wtt            */
									   
char MixBuffer[ 2 ][ MaxBufferSize ];           /* nXa          */
char ModTitle[ 20 ];                            /* ModuleɪqW      */

/*       HUO@n˥Ƶc:                                     */

typedef struct
{
	char Name[ 22 ];                        /* ˥W                */
	unsigned Length;                        /* ˥                */
	unsigned char FineTune;                 /* Wvվ              */
	unsigned char Volume;                   /* ˥̤jq          */
	unsigned StartLoop;                     /* Ʈɰ_Im          */
	unsigned LoopLength;                    /* Ʈɩһݭƪ    */

} MODSAMPLEDATA;                                        

MODSAMPLEDATA ModSampleData[ 31 ];

char TotalPattern;                              /* `Pattern             */
char TotalSequence;                             /* `q                  */
char Sequence[ 128 ];                           /* `Ǫ                  */
char far *ModBuffer;
char far *SampleAddress[ 31 ];

/*       HUOXnn:                                             */

typedef struct
{
	unsigned char Instrument;               /* n˥s          */
	unsigned int  Note;                     /* ; Ȭg        */
	unsigned char Effect;                   /* Ľs                */
	unsigned char EffectValue;              /* ĭ                  */
	char          Volume;                   /* q                    */
	char          VolSlide;                 /* qWλ          */
	char          Velocity;                 /* WvWλ          */
	char          LoopFlag;                 /* n˥O_w      */
	unsigned long SamplePointer;            /* ˥ƪ          */

} CURRENT;

CURRENT Current[ 4 ];

/*       ڦXnɩҥΪ:                                         */
typedef struct
{
	unsigned char Instrument;
	unsigned int  Note;

} REAL;

REAL Real[ 4 ];

/*       ǵ DMA ƮɩҥΪѼ:                                        */
typedef struct
{
	char Page;                              
	unsigned Offset;                        
	unsigned Count;                         /* Ǹƪ          */

} DMA_DATA;

DMA_DATA DMAdata[ 2 ];

char CurrentSequence;                           /* ثetq            */     
char CurrentRow;                                /* ثetC            */

/*       UزVtפUt@Cɶ:                                 */
long CountTable[ 8 ]= {                         
			 116640, 77760, 58320, 46656,          /* for mono */       
			 116640*2,77760*2, 58320*2, 46656*2  /* for stereo */
		      };

/*       UزVt; V֫hnVM, ]VCPUɶ:                */ 
unsigned SpeedTable[ 8 ]= {
			     8000, 12000, 16000, 20000,        /* for mono */
			     8000, 12000, 16000, 20000       /* for stereo */
			  };
char MixSpeed;
char *DMAbuffer = MixBuffer[ 0 ];
char *CurMixBuffer = MixBuffer[ 1 ];
unsigned DMAbufferSize[ 32 ];
unsigned CurBufferSize;
char Play_Status;
char More;

/*-------------------------------------------------------------------------*/      
/*         禡@: N@вʥN, öǦ^sСC              */
/*-------------------------------------------------------------------------*/
char far *farptr( char far *p, long l )
{
	unsigned seg, off;

	seg= FP_SEG( p );
	off= FP_OFF( p );
	seg+= ( off>>4 ) + (unsigned)( l>>4 );
	off= ( off&0x000f ) + (unsigned)( l&0x000f );

	return( MK_FP( seg, off ) );
}
/*-------------------------------------------------------------------------*/
/*         禡G: N@ModuleɸJOC                                */
/*-------------------------------------------------------------------------*/
int LoadModule( char *ModName )
{
	int handle, i;
	long PatternSize, SampleSize = 0;

	if( ( handle= openfile( ModName, ReadOnly ))!= FileError )
	{
	     readfile( handle, NearToFar( ModTitle ), 20 );
	     readfile( handle, NearToFar( ModSampleData ), 31*30 );

	     for( i= 0; i< 31; i++ )
	     {
		  _AX= ModSampleData[ i ].Length;
		  asm  xchg ah,al
		  ModSampleData[ i ].Length= _AX << 1;
		  SampleSize+= _AX;

		  _AX= ModSampleData[ i ].StartLoop;
		  asm  xchg ah,al
		  ModSampleData[ i ].StartLoop= _AX << 1;

		  _AX= ModSampleData[ i ].LoopLength;
		  asm  xchg ah,al
		  ModSampleData[ i ].LoopLength= _AX << 1;

		  if( ModSampleData[ i ].Length < ( ModSampleData[ i ].StartLoop
		      + ModSampleData[ i ].LoopLength ) ) 
		      ModSampleData[ i ].LoopLength = ModSampleData[ i ].Length -
		      ModSampleData[ i ].StartLoop;
		  if( ModSampleData[ i ].LoopLength < 10 )
		      ModSampleData[ i ].LoopLength = 0;

	     }

	     TotalSequence= getfileint( handle );

	     readfile( handle, NearToFar( Sequence ), 128 );

	     TotalPattern= 0;
	     for( i= 0; i< TotalSequence; i++ )
		if( TotalPattern< Sequence[ i ] ) TotalPattern= Sequence[ i ];

	     TotalPattern++;
	     PatternSize= (long)TotalPattern << 10;

	     if( ( ModBuffer= farmalloc( PatternSize+SampleSize ) )!= NULL )
	     {
		 seekfile( handle, 0x43c, 0 );
		 readfile( handle, ModBuffer, PatternSize+SampleSize );
		 closefile( handle );

		 SampleAddress[ 0 ]= farptr( ModBuffer, PatternSize );
		 for( i=1; i< 31; i++ ) SampleAddress[ i ]=
		    farptr( SampleAddress[ i-1 ], (long)ModSampleData[ i-1 ].Length );
	     }
	     else return( MemoryNotEnough );
	}
	else return( FileOpenError );

	return( 0 );
}

/*-------------------------------------------------------------------------*/
/*        禡T: Ū@CšBġBĭȤn˥s, ñN     */
/*                ABzC                                           */
/*-------------------------------------------------------------------------*/
void ReadRow( void )
{
	int i;
	unsigned char far *p;

	if( CurrentRow == 64 )
	{
		CurrentRow = 0;
		CurrentSequence++;
	}
	if( CurrentSequence >= TotalSequence ) CurrentSequence = 0;

	p = farptr( ModBuffer, ( (long)Sequence[ CurrentSequence ]<<10 )+( CurrentRow<<4 ));

	for( i= 0; i< 4; i++ )
	{
	    Current[ i ].Instrument = ( p[ 0 ]&0x10 )|( p[ 2 ]>>4 );
	    Current[ i ].Note= ( (unsigned)( p[ 0 ]&0x0f )<<8 ) | p[ 1 ];
	    Current[ i ].Effect= p[ 2 ] & 0x0f;
	    Current[ i ].EffectValue= p[ 3 ];

	    if( Current[ i ].Instrument )
	    {
		Real[ i ].Instrument= Current[ i ].Instrument-1;
		Current[ i ].Volume = ModSampleData[ Real[ i ].Instrument ].Volume;
		Current[ i ].LoopFlag = 0;
		Current[ i ].SamplePointer= 0;
	    }
	    if( Current[ i ].Note && Current[ i ].Note!= Real[ i ].Note )
		Real[ i ].Note= Current[ i ].Note;

	    Current[ i ].VolSlide= 0;
	    Current[ i ].Velocity= 0;
	    p+= 4;
	    switch( Current[ i ].Effect )
	    {
		 case 0: break;
		 case SET_TEMPO:
			 if( Current[ i ].EffectValue > 31 )
			     Current[ i ].EffectValue = 31;
			 CurBufferSize = DMAbufferSize[ Current[ i ].EffectValue ];
			 break;

		 case SET_VOLUME:

			 Current[ i ].Volume= Current[ i ].EffectValue;
			 if( Current[ i ].Volume > 63 ) Current[ i ].Volume= 63;
			 break;

		 case BREAK: CurrentRow = 63; break;
		 case JUMP:

			 CurrentSequence= Current[ i ].EffectValue-1;
			 CurrentRow= 63; break;

		 case VOLUME_SLIDE:
		 case VIBRATO_VOL:

			if( Current[ i ].EffectValue > 0x0f )
			Current[ i ].VolSlide=(char)(Current[ i ].EffectValue>>4)-16;
			else Current[ i ].VolSlide=Current[ i ].EffectValue;
			break;

		 case PORTA_UP:

			Current[ i ].Velocity= -(char)Current[ i ].EffectValue;
			break;

		 case PORTA_DOWN:

			Current[ i ].Velocity= Current[ i ].EffectValue<<1;
			break;

	    }
	}
	CurrentRow++;
}

/*-------------------------------------------------------------------------*/
/*        禡|: N[segment:offset]ഫ[page:offset]; ഫ᪺offset    */
/*                [Wƪ׭Yoͷ쪺, h|զ}ӪܡC   */
/*-------------------------------------------------------------------------*/
void AddressToPage( void )
{
	unsigned seg;

	seg= FP_SEG( MixBuffer );

	DMAdata[ 0 ].Page = seg >> 12;
	DMAdata[ 0 ].Offset = ( seg << 4 ) + (unsigned)DMAbuffer;
	if( (unsigned)DMAbuffer > DMAdata[ 0 ].Offset )
	    DMAdata[ 0 ].Page ++;

	DMAdata[ 1 ].Page = DMAdata[ 0 ].Page + 1;
       
	if( DMAdata[ 0 ].Offset > ( 65535-CurBufferSize ) )
	{
	     DMAdata[ 0 ].Count = 65535-DMAdata[ 0 ].Offset;
	     DMAdata[ 1 ].Count = CurBufferSize - DMAdata[ 0 ].Count;
	}
	else
	{
	     DMAdata[ 0 ].Count = CurBufferSize;
	     DMAdata[ 1 ].Count = 0;
	}

}

/*-------------------------------------------------------------------------*/
/*        禡: VX|yn; D{֤߳C             */
/*-------------------------------------------------------------------------*/
void MixSample( void )
{
	unsigned Byte, Track;
	char *Temp;

	char a;
	unsigned long b, c, d, e;

	    ReadRow();

	    for( Byte= 0; Byte< CurBufferSize; Byte++ ) CurMixBuffer[ Byte ]= 128;

	    for( Track= 0; Track< 4; Track++ )
	    {

		a = Real[ Track ].Instrument;
		b = (long)ModSampleData[ a ].Length<< 8;
		c = (long)ModSampleData[ a ].StartLoop<< 8;
		d = (long)ModSampleData[ a ].LoopLength<< 8;

		if( Real[ Track ].Note > 10 )
		    e = CountTable[ MixSpeed ]/Real[ Track ].Note;
		else e= 0;


		for( Byte= Stereo*( Track/2 ); Byte< CurBufferSize; Byte+= 1<<Stereo )
		{

		     if( Current[ Track ].LoopFlag )
		     {
			   if( Current[ Track ].SamplePointer >= ( c + d ) )
			       Current[ Track ].SamplePointer = c;

		     }
		     else
		     {
			  if( Current[ Track ].SamplePointer >=  b )
			  {
			      Current[ Track ].SamplePointer = c;
			      Current[ Track ].LoopFlag = 1;
			  }
		     }

		    CurMixBuffer[ Byte ] += (int) SampleAddress[ a ][ Current[Track].SamplePointer>>8 ]*( Current[ Track ].Volume )>>(8-Stereo);
		    Current[ Track ].SamplePointer += e ;

		}
		if( Current[ Track ].Volume> Current[ Track ].VolSlide )
		    Current[ Track ].Volume -= Current[ Track ].VolSlide;
		if( Current[ Track ].Volume > ModSampleData[ a ].Volume )
		    Current[ Track ].Volume = ModSampleData[ a ].Volume;
		Real[ Track ].Note += Current[ Track ].Velocity;

	    }

	   Temp = DMAbuffer;
	   DMAbuffer = CurMixBuffer;
	   CurMixBuffer = Temp;
	   AddressToPage();

}

void interrupt (*Old_ISR)( void );                      /* Ӫ_Vq  */
/*-------------------------------------------------------------------------*/
/*        禡: nQd_Aȱ`; 禡tdonu@C               */      
/*-------------------------------------------------------------------------*/
void interrupt SB_ISR( void )
{
	inportb( SBIOAddr + 0x0e );

	if( Play_Status )
	{
	     if( DMAdata[ 1 ].Count )
	     {
		if( More )
		{
		     TransferDMA( DMAdata[ 1 ].Page, DMAdata[ 1 ].Offset,
				  DMAdata[ 1 ].Count );
		     More = 0;
		}
		else More = 1;
	     }
	     else
	     TransferDMA( DMAdata[ 0 ].Page, DMAdata[ 0 ].Offset,DMAdata[ 0 ].Count );

	     MixSample();
	}

	 outportb( 0x20, 0x20 );
}

/*-------------------------------------------------------------------------*/
/*        禡C: N@ѼơBI/OΤ_]wn, Y}ltC                */
/*-------------------------------------------------------------------------*/
void PlayMod( void )
{
	unsigned i;

	Old_ISR= getvect( 0x08 + SBIRQ );
	setvect( 0x08 + SBIRQ, SB_ISR );
	outportb( 0x21, inportb( 0x21 )&~(char)( 1<< SBIRQ ) );

	for( i= 0; i< 32; i++ )
	     DMAbufferSize[ i ]= SpeedTable[ MixSpeed ]/ 51 *i ;

	SetSampleRate( SpeedTable[ MixSpeed ] );
	CurBufferSize = DMAbufferSize[ 6 ];
	TurnOnSpeaker();

	Play_Status = 1;
	MixSample();
	geninterrupt( 0x08 + SBIRQ );

}

/*-------------------------------------------------------------------------*/
/*        禡K: t, ë_줤_VqC                             */
/*-------------------------------------------------------------------------*/
void StopMod( void )
{
	TurnOffSpeaker();
	Play_Status = 0;

	setvect( 0x08 + SBIRQ, Old_ISR );
	outportb( 0x21, inportb( 0x21 )|(char)( 1<< SBIRQ ) );

}

/*-------------------------------------------------------------------------*/
/*        {}lC                                                       */
/*-------------------------------------------------------------------------*/
void main( void )
{
     char ModName[ 50 ];
     int  result;

     printf( "\nC&C Module Player Ver1.0 (c)1993-9-17 by Chio.T.I\n\n" );
     printf( "Select card: (1)SoundBlaster<MONO>   (2)SoundBlaster PRO<STEREO>  " );
     scanf( "%d",&Stereo );
     printf( "Select mixing speed: (1) 8 KHz (2) 12KHz (3) 16KHz (4) 20KHz  " );
     scanf( "%d",&MixSpeed );
     printf( "Module Name: " );
     scanf( "%s",ModName );

     Stereo = ( ( Stereo -1 ) ? 1 : 0 );
     MixSpeed += ( Stereo << 2 ) - 1;
     result = LoadModule( ModName );

     if( result == 0 )
     {
	  if( SB_Check() )
	  {
	       PlayMod();
	       printf( "\nDigital music is playing....\n" );
	       printf( "Press any key to exit...." );

	       _AX = 0;
	       geninterrupt( 0x16 );

	       StopMod();
	       printf( "\nOutput ended.\n" );
	  }
	  else printf( "SoundBlaster not found.\n" );

     }else if( result == MemoryNotEnough ) 
	   printf( "Memory not enough.\n" );
	   else printf( "Can't open %s.\n", ModName );

}












