;; ****************************************************************
;; *                                                              *
;; * SIN.ASM : Sin OBJ File for quick index lookup of trig fnctns *
;; *                   Copyright (C) 1992 by Primor               *
;; *                                                              *
;; ****************************************************************
.code
;;
;; PROCEDURE: ll_sin()
;; PURPOSE  : Allow for fast table indexing of SIN Values.
;; PASS     : Integer value between +/-360.
;; RETURNS  : (char)sin(degree angle)
;;
ll_sin  proc
        push    bp                      ; Save the BP Value
        mov     bp,sp                   ; Set up BP for argument passing
        push    ds                      ; Save the Data Segment

        mov     ax,@data                ; Set Data Segment to our Data
        mov     ds,ax                   ; :

        mov     bx,[bp+MM]              ; Get the SIN index
        and     bx,0000000111111111b    ; : and place it within (0 to 1023)
@@:     cmp     bx,360                  ; :
        jl      lls_1                   ; :
        sub     bx,360                  ; :
	jmp     @B                      ; :
lls_1:  xor     ah,ah                   ; Set the return value to the
        add     bx,offset SIN           ; : SIN value stored in our table
        mov     al,[bx]                 ; : for requested data.

        pop     ds                      ; Restore Data Segment
        pop     bp                      ; Restore Base Pointer
        ret                             ; Return to caller
ll_sin  endp

;;
;; PROCEDURE: ll_cos()
;; PURPOSE  : Allow for fast table indexing of COS Values.
;; PASS     : Integer value between +/-32767.
;; RETURNS  : (uchar)(cos((passed_integer*6.2831853)/1024)*0x7f)+128
;;
ll_cos  proc
        push    bp                      ; Save the BP Value
        mov     bp,sp                   ; Set up BP for argument passing
        push    ds                      ; Save the Data Segment

        mov     ax,@data                ; Set Data Segment to our Data
        mov     ds,ax                   ; :

        mov     bx,[bp+MM]              ; Get the COS index
        and     bx,0000000111111111b    ; : and place it within (0 to 360)
@@:     cmp     bx,360                  ; :
        jl      llc_1                   ; :
        sub     bx,360                  ; :
	jmp     @B                      ; :
llc_1:  xor     ah,ah                   ; Set the return value to the
        add     bx,offset COS           ; : COS value stored in our table
        mov     al,[bx]                 ; : for requested data.

        pop     ds                      ; Restore Data Segment
        pop     bp                      ; Restore Base Pointer
        ret                             ; Return to caller
ll_cos  endp

.data
;;
;; SIN Data : Values range from -128 to +127 360  intervals.
;;
       SIN     db    0,   2,   4,   6,   8,  11,  13,  17
               db   17,  19,  22,  24,  26,  28,  30,  35
               db   35,  37,  39,  41,  43,  45,  47,  51
               db   51,  53,  55,  57,  59,  61,  63,  67
               db   67,  69,  71,  72,  74,  76,  78,  81
               db   81,  83,  84,  86,  88,  89,  91,  94
               db   94,  95,  97,  98, 100, 101, 102, 105
               db  105, 106, 107, 108, 109, 111, 112, 114
               db  114, 115, 116, 116, 117, 118, 119, 120
               db  120, 121, 122, 122, 123, 123, 124, 125
               db  125, 125, 125, 126, 126, 126, 126, 126
               db  126, 126, 127, 126, 126, 126, 126, 126
               db  126, 126, 125, 125, 125, 124, 124, 123
               db  123, 122, 122, 121, 120, 120, 119, 117
               db  117, 116, 116, 115, 114, 113, 112, 109
               db  109, 108, 107, 106, 105, 104, 102, 100
               db  100,  98,  97,  95,  94,  92,  91,  88
               db   88,  86,  84,  83,  81,  79,  78,  74
               db   74,  72,  71,  69,  67,  65,  63,  59
               db   59,  57,  55,  53,  51,  49,  47,  43
               db   43,  41,  39,  37,  35,  32,  30,  26
               db   26,  24,  22,  19,  17,  15,  13,   8
               db    8,   6,   4,   2,   0,  -2,  -4,  -8
               db   -8, -11, -13, -15, -17, -19, -22, -26
               db  -26, -28, -30, -32, -35, -37, -39, -43
               db  -43, -45, -47, -49, -51, -53, -55, -59
               db  -59, -61, -63, -65, -67, -69, -71, -74
               db  -74, -76, -78, -79, -81, -83, -84, -88
               db  -88, -89, -91, -92, -94, -95, -97,-100
               db -100,-101,-102,-104,-105,-106,-107,-109
               db -109,-111,-112,-113,-114,-115,-116,-117
               db -117,-118,-119,-120,-120,-121,-122,-123
               db -123,-123,-124,-124,-125,-125,-125,-126
               db -126,-126,-126,-126,-126,-126,-127,-126
               db -126,-126,-126,-126,-126,-126,-125,-125
               db -125,-124,-124,-123,-123,-122,-122,-120
               db -120,-120,-119,-118,-117,-116,-116,-114
               db -114,-113,-112,-111,-109,-108,-107,-105
               db -105,-104,-102,-101,-100, -98, -97, -94
               db  -94, -92, -91, -89, -88, -86, -84, -81
               db  -81, -79, -78, -76, -74, -72, -71, -67
               db  -67, -65, -63, -61, -59, -57, -55, -51
               db  -51, -49, -47, -45, -43, -41, -39, -35
               db  -35, -32, -30, -28, -26, -24, -22, -17
               db  -17, -15, -13, -11,  -8,  -6,  -4,   0
               
;;
;; COS Data : Values range from -128 to +127 with 360 intervals.
;;
       COS     db  127, 126, 126, 126, 126, 126, 126, 125
               db  125, 125, 125, 124, 124, 123, 123, 122
               db  122, 121, 120, 120, 119, 118, 117, 116
               db  116, 115, 114, 113, 112, 111, 109, 107
               db  107, 106, 105, 104, 102, 101, 100,  97
               db   97,  95,  94,  92,  91,  89,  88,  84
               db   84,  83,  81,  79,  78,  76,  74,  71
               db   71,  69,  67,  65,  63,  61,  59,  55
               db   55,  53,  51,  49,  47,  45,  43,  39
               db   39,  37,  35,  32,  30,  28,  26,  22
               db   22,  19,  17,  15,  13,  11,   8,   4
               db    4,   2,   0,  -2,  -4,  -6,  -8, -13
               db  -13, -15, -17, -19, -22, -24, -26, -30
               db  -30, -32, -35, -37, -39, -41, -43, -47
               db  -47, -49, -51, -53, -55, -57, -59, -63
               db  -63, -65, -67, -69, -71, -72, -74, -78
               db  -78, -79, -81, -83, -84, -86, -88, -91
               db  -91, -92, -94, -95, -97, -98,-100,-102
               db -102,-104,-105,-106,-107,-108,-109,-112
               db -112,-113,-114,-115,-116,-116,-117,-119
               db -119,-120,-120,-121,-122,-122,-123,-124
               db -124,-124,-125,-125,-125,-126,-126,-126
               db -126,-126,-126,-126,-127,-126,-126,-126
               db -126,-126,-126,-126,-125,-125,-125,-124
               db -124,-123,-123,-122,-122,-121,-120,-119
               db -119,-118,-117,-116,-116,-115,-114,-112
               db -112,-111,-109,-108,-107,-106,-105,-102
               db -102,-101,-100, -98, -97, -95, -94, -91
               db  -91, -89, -88, -86, -84, -83, -81, -78
               db  -78, -76, -74, -72, -71, -69, -67, -63
               db  -63, -61, -59, -57, -55, -53, -51, -47
               db  -47, -45, -43, -41, -39, -37, -35, -30
               db  -30, -28, -26, -24, -22, -19, -17, -13
               db  -13, -11,  -8,  -6,  -4,  -2,   0,   4
               db    4,   6,   8,  11,  13,  15,  17,  22
               db   22,  24,  26,  28,  30,  32,  35,  39
               db   39,  41,  43,  45,  47,  49,  51,  55
               db   55,  57,  59,  61,  63,  65,  67,  71
               db   71,  72,  74,  76,  78,  79,  81,  84
               db   84,  86,  88,  89,  91,  92,  94,  97
               db   97,  98, 100, 101, 102, 104, 105, 107
               db  107, 108, 109, 111, 112, 113, 114, 116
               db  116, 116, 117, 118, 119, 120, 120, 122
               db  122, 122, 123, 123, 124, 124, 125, 125
               db  125, 126, 126, 126, 126, 126, 126, 127
