  The program started out on a SOL 8080 which had a 16 line by 64 character
display. This may have influenced my style of programming (indentation and
line-breaks) which is different from many programmers. While I find the
style naturally structured and compact, such preferences are personal, and
important enough to one's state of mind that it might be worth making a file
filter to 'beautify' the code according to other aesthetics.
  Structure declarations and global variables are to be found in the header
file GOH.C, while GO.C contains the function main() and a null definition
of EXTCDECL. The other C source files define EXTCDECL to be 'extern' before
GOH.C is included so that variables are not redeclared when these files are
compiled.
  Except for the header file, where I tried to indicate the purpose of each
variable, there are few comments in the source code. One reason is that I
tend to make mistakes in syntax caused by comments cluttering the code.
Also, comments which get neglected can become irrelevant and misleading.
Eventually, I adopted the attitude of the poker player to such matters.
Just as poker players acknowledge that 'the cards speak for themselves',
it is the code which defines the program, and not the comments. Of course,
programming is not poker, so I will attempt to lay my cards on the table by
explaining basic structures and functions in some detail so that the 'truth'
of the code can be understood.
  In programming, progress procedes best in a perfect, bug-free environment.
This notion of perfection is present in every line of every program to some
extent since the syntax of the language must be obeyed, but it is the
programmer who must ensure that the program is functioning entirely as
expected by tracking down and correcting serious program faults.
  To search for possible moves it is necessary not only to make moves, but to
be able to take them back in order to try others. The 64 kilobyte memory of
the SOL may have been responsible for the decision to limit the number of
moves which can be taken back using the '-' key, reclaiming memory used by
older structures as the game progresses. My original motivation for writing
the program came after playing against a machine which lost in a ladder, and
then realizing that it might not be difficult to predict such outcomes. These
sequences of atari and escape often take dozens of moves to resolve, but can
be approached in a manner which has few branches. The algorithm I eventually
came up with to handle ladders (described in the chapter on capture) is based
on minimizing liberties using the alpha-beta minimax approach. The algorithm
is specialized for capture, but it should be adaptable to other cases.
  Stones on the board exist in one of three states: live, dead, or seki. This
assessment is based on spatial relationships between liberties and stones for
the current board situation. I see the application of the alpha-beta minimax 
algorithm to the problem of maintaining two eyes as the next major step
in the program's progress. At this point in the program's development,
tactics for cutting and connecting are only partially implemented. For now,
the program cuts and connects whenever the opponent could prevent these
operations.
  Every move has shell-like levels of perception concerning death, life, and
territory. The common central level, the envelope, is somewhat more than what
is necessary to carry out a capture, extending to the eight points immediately
surrounding each stone. The second level extends farther, dealing with matters
of life and death in terms of eyes. A third level of perception is provided
by arrays which determine possession of territory in terms of spheres of
influence, and these perceptions form the basis for calculating the score.
A system for storing connections between stones forms another perception.
The perceptual mechanism used for evaluating a board position is essentially
complete, so the next problems considered will concern looking ahead to
attain a living shape.
