#include <dos.h>
#include <conio.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <time.h>
#include <stdio.h>
#include <alloc.h>
#include <graphics.h>
#define EXTCDECL extern
#include "goh.c"

/* screen and keyboard functions */
/* most operating system calls are in ibm.c */

unsigned solkey()   /* return zero if no key waiting */
{
 unsigned key, shift, test;
 key = bioskey(1);
 if (key) key = bioskey(0);
 if (key == 0x0e08) key &= 0xff00; /* separate Backspace and Ctrl-H */
 if (key == 0x0f09) key &= 0xff00; /* separate Tab and Ctrl-I */
 if (key == 0x1c0d) key &= 0xff00; /* separate CR and Ctrl-M */
 test = key & 0xff;
 if (test) key = test;
 shift = bioskey(2);
 shift &= 3; /* either left or right shift */
 if (shift) {
  if (key == LEFT) key = SLEFT;
  if (key == RIGHT) key = SRIGHT;
  if (key == UP) key = SUP;
  if (key == DOWN) key = SDOWN;
 }
 return(key);
}

unsigned getkey()     /* wait for a key ... negative is IBM code */
{
 unsigned key;
 do {
  key = solkey();
 } while (!key);
 return(key);
}

void flushkey()
{
 unsigned key;
 do {
  key = solkey();
 } while (key);
}

int iscanf(int dflt)   /* scan keyboard for an integer (dflt if null) */
{
 int value;
 char buf[128];
 unsigned c;
 unsigned key;
 int i;
 i = 0;
 do {
  key = getkey();
  if (key == BACKSP) {  /* backspace detect */
   if (i) {
    putch(8);
    putch(' ');
    putch(8);
   }
   if (i > 0) --i;
   key = 0;
  }
  if (key == LEFT) {  /* back cursor */
   if (i) {
    putch(8);
    putch(' ');
    putch(8);
   }
   if (i > 0) --i;
   key = 0;
  }
  if (key) {
   c = key & 255;
   if (c) putch(c);
   buf[i] = c;
   ++i;
  }
 } while (key != CR);
 buf[i-1] = 0;
 if (i != 1) value = atoi(buf);
 else value = dflt;
 return(value);
}

int bscanf(char *buf, int max) /* scan keyboard for char string + CR */
{
 int value; /* return 0 if null line  bufsize otherwise */
 unsigned c;
 unsigned key;
 int i;
 value = 0;
 i = 0;
 do {
  key = getkey();
  c = key & 255;
  if (key == BACKSP) {  /* intercept backspace */
   if (i) {
    putch(8);
    putch(' ');
    putch(8);
   }
   if (i > 0) --i;
   key = 0;
  }
  if (key == LEFT) {  /* back cursor */
   if (i) {
    putch(8);
    putch(' ');
    putch(8);
   }
   if (i > 0) --i;
   key = 0;
  }
  if (key) {
   buf[i] = c;
   if (i < max) {
    if (c) putch(c);
    ++i;
   }
  }
 } while (key != CR);
 buf[i-1] = 0;
 if (i == 1) value = 0;
 else value = i;
 return(value);
}

unsigned cput(flag)
unsigned flag;     /* 0 to reset ... 1 to return elapsed time */
{
 struct time now;
 unsigned hunds;
 long elapsed;
 hunds = 0;
 elapsed = 0;
 gettime(&now);
 if (!flag) {
  thour = now.ti_hour;
  tmin = now.ti_min;
  tsec = now.ti_sec;
  thund = now.ti_hund;
 }
 else {
  elapsed += now.ti_hour - thour;
  elapsed *= 60;
  elapsed += now.ti_min - tmin;
  elapsed *= 60;
  elapsed += now.ti_sec - tsec;
  elapsed *= 100;
  elapsed += now.ti_hund - thund;
 }
 if ((elapsed > 0) && (elapsed <= 30000)) hunds = elapsed;
 return(hunds);
}

void hundelay(hundsec)
unsigned hundsec;
{
 unsigned hunds;
 if (hundsec) {
  hunds = cput(0);
  do {
   hunds = cput(1);
  } while (hunds < hundsec);
 }
}

void locatec(index)
unsigned index;
{
 int inline, inchar;
 char nline, nchar;
 #if DDD
 unsigned z;
 z = ((index-1) / nsize) / nsize + 1;
 index -= (z-1) * nsize * nsize;
 #endif
 inline = (index - 1) / nsize;
 inchar = index - nsize * inline;
 #if DONUT
 inline += ydonut;
 inchar += xdonut;
 if (inline < 0) inline += nsize;
 if (inline >= nsize) inline -= nsize;
 if (inchar < 1) inchar += nsize;
 if (inchar > nsize) inchar -= nsize;
 #endif
 inline += ((19 - nsize) / 2);
 inchar += ((19 - nsize) / 2);
 inchar += inchar;
 nline = inline;
 nchar = inchar;
 scr_rowcol(nline, nchar);
}

void mocatec(index)
unsigned index;
{
 int inline, inchar;
 char nline, nchar;
 #if DDD
 unsigned z;
 z = ((index-1) / nsize) / nsize + 1;
 index -= (z-1) * nsize * nsize;
 #endif
 inline = (index - 1) / nsize;
 inchar = index - nsize * inline;
 #if DONUT
 inline += ydonut;
 inchar += xdonut;
 if (inline < 0) inline += nsize;
 if (inline >= nsize) inline -= nsize;
 if (inchar < 1) inchar += nsize;
 if (inchar > nsize) inchar -= nsize;
 #endif
 inline += ((19 - nsize) / 2);
 inchar += ((19 - nsize) / 2);
 inchar += inchar;
 nline = inline;
 nchar = inchar + 1;
 scr_rowcol(nline, nchar);
}

unsigned twist(unsigned index)
{
 unsigned newx, newy;
 unsigned x, y;
 #if DDD
 unsigned z;
 z = ((index-1) / nsize) / nsize + 1;
 index -= (z-1) * nsize * nsize;
 #endif
 xy(index, &x, &y);
 newx = x;
 newy = y;
 if (twister == 1) {
  newx = y;
  newy = nsize -x + 1;
 }
 else if (twister == 2) {
  newx = nsize - x + 1;
  newy = nsize - y + 1;
 }
 else if (twister == 3) {
  newx = nsize - y + 1;
  newy = x;
 }
 x = newx;
 y = newy;
 index = fxy(x, y);
 #if DDD
 index += (z-1) * nsize * nsize;
 #endif
 return(index);
}
 
unsigned xgboard(unsigned index)
{
 unsigned xc;
 int x, y, z;
 z = ((index-1) / nsize) / nsize + 1;
 index -= (z-1) * nsize * nsize;
 xy(index, &x, &y);
 #if DONUT
 x += ydonut;
 if (x < 1) x += nsize;
 if (x > nsize) x -= nsize;
 y += xdonut;
 if (y < 1) y += nsize;
 if (y > nsize) y -= nsize;
 #endif
 xc = 360;  /* Hercules center */
 xc += (xrad+xrad) * (y-(nsize+1)/2) + ((nsize+1)-x*2) * persp;
 return(xc);
}

unsigned ygboard(unsigned index)
{
 unsigned yc;
 int x, y, z;
 z = ((index-1) / nsize) / nsize + 1;
 index -= (z-1) * nsize * nsize;
 xy(index, &x, &y);
 #if DONUT
 x += ydonut;
 if (x < 1) x += nsize;
 if (x > nsize) x -= nsize;
 y += xdonut;
 if (y < 1) y += nsize;
 if (y > nsize) y -= nsize;
 #endif
 #if DDD
 yc = 125;
 yc += (z-1) * zinc;
 #else
 yc = 174; /* Hercules center */
 #endif
 yc += (yrad+yrad) * ((nsize+1)/2-x) + ((int)((nsize+1)-y*2)/2) * persp;
 return(yc);
}

unsigned handipt(unsigned index)
{
 unsigned handi;
 unsigned xhand, yhand;
 int x, y;
 xy(index, &x, &y);
 xhand = 0;
 if (x == 4) xhand = 1;
 if (x == 10) xhand = 1;
 if (x == 16) xhand = 1;
 yhand = 0;
 if (y == 4) yhand = 1;
 if (y == 10) yhand = 1;
 if (y == 16) yhand = 1;
 if (xhand && yhand) handi = 1;
 else handi = 0;
 return(handi);
}

void curof(index)
unsigned index;
{
 unsigned x, y, xc, yc, xhand, yhand;
 struct root *rootp;
 char c;
 if (index) {
  rootp = dir[index];
  invid[index] = 0;
  if (col80) {
   mocatec(index);
   scr_mark(' ', 7);
   locatec(index);
   c = scr_sinp();
   scr_mark(c, 7);
  }
  else {
   setcolor(BLACK);
   if (rootp) {
    if (rootp->clr == WHT) setcolor(WHITE);
   }
   index = twist(index);
   xy(index, &x, &y);
   xc = xgboard(index);
   yc = ygboard(index);
   if (north(index)) {
    zline(xc, yc, xc+persp/2, yc+yrad/2);
   }
   if (west(index)) {
    zline(xc, yc, xc-xrad/2, yc+persp/4);
   }
   if (east(index)) {
    zline(xc, yc, xc+xrad/2, yc-persp/4);
   }
   if (south(index)) {
    zline(xc, yc, xc-persp/2, yc-yrad/2);
   }
   if (1) {
    xhand = 0;
    if (x == 4) xhand = 1;
    if (x == 10) xhand = 1;
    if (x == 16) xhand = 1;
    yhand = 0;
    if (y == 4) yhand = 1;
    if (y == 10) yhand = 1;
    if (y == 16) yhand = 1;
    if (xhand && yhand && !dir[index]) {
     setcolor(WHITE);
     blackfill();
     zfillellipse(xc, yc, 2, 2);
    }
   }
  }
 }
}

void curon(index)
unsigned index;
{
 unsigned x, y, xc, yc;
 struct root *rootp;
 char c;
 if (index) {
  invid[index] = 1;
  if (col80) {
   mocatec(index);
   scr_mark(' ', 112);
   locatec(index);
   c = scr_sinp();
   scr_mark(c, 112);
  }
  else {
   setcolor(WHITE);
   rootp = dir[index];
   if (rootp) {
    if (rootp->clr == WHT) setcolor(BLACK);
   }
   index = twist(index);
   xc = xgboard(index);
   yc = ygboard(index);
   if (north(index)) {
    zline(xc, yc, xc+persp/2, yc+yrad/2);
   }
   if (west(index)) {
    zline(xc, yc, xc-xrad/2, yc+persp/4);
   }
   if (east(index)) {
    zline(xc, yc, xc+xrad/2, yc-persp/4);
   }
   if (south(index)) {
    zline(xc, yc, xc-persp/2, yc-yrad/2);
   }
  }
 }
}

unsigned strtscrl()
{
 unsigned line;
 line = 1;
 return (line);
}

unsigned stopscrl()
{
 unsigned line;
 line = 18;
 if (col80) line = 23;
 return (line);
}

unsigned xscrl()
{
 unsigned column;
 column = 23;
 if (col80) column = 43;
 return (column);
}

void typeset(i, j)
unsigned i, j;
{
 unsigned ichar;
 char ci, cj;
 ci = i;
 cj = j;
 scr_rowcol(ci, cj); /* set cursor to i,j */
}

void clearline()
{     
 if (col80) {
  printf("                                     ");
 }
}

void subline()
{
 unsigned nextline;
 if (linum < strtscrl()) linum = strtscrl();
 nextline = linum + 1;
 if (nextline > stopscrl()) nextline = strtscrl();
 typeset(nextline, xscrl());
 clearline();
 typeset(nextline, xscrl());
 printf("...");
 typeset(linum, xscrl());
 clearline();
 typeset(linum, xscrl());
 linum = nextline;
}

void newline()
{
 if (!col80) switchscreen();
 keybreak(0);
 subline();
}

void turnon(indexes)
struct link *indexes;
{
 struct link *linkp;
 unsigned jndex;
 linkp = indexes;
 if (linkp) {
  do {
   jndex = linkp->loc;
   if (jndex) {
    curon(jndex);
    /*
    newline();
    coords(jndex);
    */
   }
   linkp = linkp->nextl;
  } while (linkp);
 }
}

void xtturnon(indexes)
unsigned indexes;
{
 unsigned linkp;
 unsigned jndex;
 linkp = indexes;
 if (linkp) {
  do {
   jndex = peek(linkp, LOC);
   if (jndex) curon(jndex);
   linkp = peek(linkp, NEXTL);
  } while (linkp);
 }
}

void xtturnof(indexes)
unsigned indexes;
{
 unsigned linkp;
 unsigned jndex;
 linkp = indexes;
 if (linkp) {
  do {
   jndex = peek(linkp, LOC);
   if (jndex) curof(jndex);
   linkp = peek(linkp, NEXTL);
  } while (linkp);
 }
}

void xtboxes(indexes)
unsigned indexes;
{
 unsigned linkp;
 unsigned jndex;
 linkp = indexes;
 if (linkp) {
  do {
   jndex = peek(linkp, LOC);
   if (jndex) {
    locatec(jndex);
    scr_co(0xb0);
   }
   linkp = peek(linkp, NEXTL);
  } while (linkp);
 }
}

unsigned flip(bw)
unsigned bw;
{
 if (bw == BLK) bw = WHT;
 else bw = BLK;
 return(bw);
}

unsigned tranctl(key)
unsigned key;
{
 unsigned result;
 result = key;
 if (key) {
  if (key == 72) result = 30; /* cursor arrow keys */
  if (key == 80) result = 31;
  if (key == 75) result = 29;
  if (key == 77) result = 28;
  if (key == 71) result = 200;
  if (key == 79) result = 201;
  if (key == 73) result = 202;
  if (key == 81) result = 203;
  if (key == 0x77) result = 204;
  if (key == 0x75) result = 205;
 }
 return (result);
}

unsigned odd(number)
unsigned number;
{
 unsigned result;
 result = number & 1;
 return (result);
}

unsigned even(number)
unsigned number;
{
 unsigned result;
 result = !odd(number);
 return (result);
}

void agstone(index, x, y)
unsigned index;
unsigned x, y;
{
 int i;
 unsigned j[11] = {7,7,7,7,7,7,6,5,4,3,2};
 unsigned k[11] = {7,7,7,7,7,6,5,4,3,2,1};
 unsigned m[11] = {7,7,7,7,6,5,4,3,2,1,0};
 /*unsigned n[11] = {7,7,7,7,6,5,4,3,2,1,0};*/
 unsigned usej, usek, usem, iswhite, iseven;
 struct root *rootp;
 rootp = dir[index];
 iswhite = rootp->clr == WHT;
 setlinestyle(0,0,1);
 if (!iswhite) {
  for (i=0; i<=10; ++i) zline(x+i, y-j[i], x+i, y+k[i]);
  for (i=0; i<=10; ++i) zline(x-i-1, y-k[i], x-i-1, y+m[i]);
 }
 else {
  for (i=0; i<=10; ++i) zline(x+i, y-k[i]-1, x+i, y+j[i]);
  for (i=0; i<=10; ++i) zline(x-i-1, y-m[i]-1, x-i-1, y+k[i]);
 }
}
 

void showlink(jndex, kndex, bw)
unsigned jndex;
unsigned kndex;
unsigned bw;
{
 int i, j;
 unsigned x1, y1, x2, y2;
 x1 = xgboard(jndex);
 y1 = ygboard(jndex);
 x2 = xgboard(kndex);
 y2 = ygboard(kndex);
 if (bw == BLK) setcolor(BLACK);
 else setcolor(WHITE);
 for (i=-1; i<=1; ++i) {
  for (j=-1; j<=1; ++j) {
   zplt(x1+i, y1+j, 0);
   zplt(x2+i, y2+j, 1);
  }
 }
 setcolor(WHITE);
}
 

int yltf(x, y, xi, yi, xj, yj)
int x;
int y;
int xi;
int yi;
int xj;
int yj;
{
 int allow; /* return 1 if y < line(i,j) given x */
 int newy;
 allow = 0;
 if (xj != xi) {
  newy = yi + ((long) (x-xi) * (yj - yi)) / (xj - xi);
  if (y < newy) allow = 1;
 }
 return(allow);
}

int ygtf(x, y, xi, yi, xj, yj)
int x;
int y;
int xi;
int yi;
int xj;
int yj;
{
 int allow; /* return 1 if y < line(i,j) given x */
 int newy;
 allow = 0;
 if (xj != xi) {
  newy = yi + ((long) (x-xi) * (yj - yi)) / (xj - xi);
  if (y > newy) allow = 1;
 }
 return(allow);
}

void showarea(index, jndex, kndex, bw)
unsigned index;
unsigned jndex;
unsigned kndex;
unsigned bw;
{
 int x, y, allow, area;
 int xi, yi, xj, yj, xk, yk;
 int xmin, xmax, ymin, ymax;
 xi = xgboard(index);
 yi = ygboard(index);
 xj = xgboard(jndex);
 yj = ygboard(jndex);
 xk = xgboard(kndex);
 yk = ygboard(kndex);
 xmin = min(min(xi, xj), min(xj, xk));
 xmax = max(max(xi, xj), max(xj, xk));
 ymin = min(min(yi, yj), min(yj, yk));
 ymax = max(max(yi, yj), max(yj, yk));
 /*
 newline();
 printf(" showarea");
 coords(index);
 coords(jndex);
 coords(kndex);
 newline();
 printf("  xmn:%d xmx:%d ymn:%d ymx:%d", xmin, xmax, ymin, ymax);
 */
 if (bw == BLK) setcolor(BLACK);
 else setcolor(WHITE);
 for (y=ymin; y<=ymax; ++y) {
  for (x=xmin; x<=xmax; ++x) {
   allow = 1;
   if (xi == xj) {
    if (!yltf(x, y, xi, yi, xk, yk)) allow = 0;
    if (!ygtf(x, y, xj, yj, xk, yk)) allow = 0;
   }
   else if (xi == xk) {
    if (!yltf(x, y, xi, yi, xj, yj)) allow = 0;
    if (!ygtf(x, y, xj, yj, xk, yk)) allow = 0;
   }
   else if (xj == xk) {
    if (!yltf(x, y, xi, yi, xj, yj)) allow = 0;
    if (!ygtf(x, y, xi, yi, xk, yk)) allow = 0;
   }
   else {
    area = howbig(index, jndex, kndex);
    if (area > 0) {
     if (xj < xi) {
      if (!yltf(x, y, xi, yi, xj, yj)) allow = 0;
      if (xk > xj) {
       if (!ygtf(x, y, xj, yj, xk, yk)) allow = 0;
      }
      if (xk < xj) {
       if (!yltf(x, y, xj, yj, xk, yk)) allow = 0;
      }
      if (xi > xk) {
       if (!ygtf(x, y, xi, yi, xk, yk)) allow = 0;
      }
      if (xi < xk) {
       if (!yltf(x, y, xi, yi, xk, yk)) allow = 0;
      }
     }
     if (xj > xi) {
      if (!yltf(x, y, xi, yi, xk, yk)) allow = 0;
      if (!ygtf(x, y, xj, yj, xk, yk)) allow = 0;
      if (!ygtf(x, y, xi, yi, xj, yj)) allow = 0;
     }
    }
    if (area < 0) {
     if (xj > xi) {
      if (!yltf(x, y, xi, yi, xj, yj)) allow = 0;
      if (xj > xk) {
       if (!ygtf(x, y, xj, yj, xk, yk)) allow = 0;
      }
      if (xj < xk) {
       if (!yltf(x, y, xj, yj, xk, yk)) allow = 0;
      }
      if (xk > xi) {
       if (!ygtf(x, y, xi, yi, xk, yk)) allow = 0;
      }
      if (xk < xi) {
       if (!yltf(x, y, xi, yi, xk, yk)) allow = 0;
      }
     }
     if (xj < xi) {
      if (!yltf(x, y, xi, yi, xk, yk)) allow = 0;
      if (!ygtf(x, y, xj, yj, xk, yk)) allow = 0;
      if (!ygtf(x, y, xi, yi, xj, yj)) allow = 0;
     }
    }
   }
   if (allow) {
    if ((rand()&4) && (rand()&4)) {
     zplt(x, y, 0);
     zplt(x, y, 1);
    }
   }
  }
 } 
 setcolor(WHITE);
}
 
int isqrt(x2)
int x2;
{
 int x;
 int i;
 x = x2 / 2;
 for (i=1; i<=7; ++i) {
  if (x) x -= (x*x-x2) / (x+x);
 }
 return(x);
}
 


/*
void zfillgem(xc, yc, dx, dy)
int xc, yc, dx, dy;
{
 int x, y, i;
 int a2, b2, y2;
 int buffer[100], npoly;
 long test;
 a2 = dx * dx + dx;
 b2 = dy * dy;
 npoly = 0;
 for (i=0; i<=1; ++i) {
  x = dx;
  if (i == 1) x = 0;
  y = dy / 3;
  if (i == 1) y = dy;
  buffer[npoly+npoly] = xc + x;
  test = y * persp + persp;
  test /= yrad;
  /*printf("\natest %d: %d  %d %d        ", test, y, persp, yrad);*/
  buffer[npoly+npoly] += test;
  buffer[npoly+npoly+1] = yc + y;
  ++npoly;
 }
 for (i=1; i<=1; ++i) {
  x = -dx;
  y = dy / 3;
  buffer[npoly+npoly] = xc + x;
  test = y * persp + persp;
  test /= yrad;
  /*printf("\natest %d: %d  %d %d        ", test, y, persp, yrad);*/
  buffer[npoly+npoly] += test;
  buffer[npoly+npoly+1] = yc + y;
  ++npoly;
 }
 for (i=0; i<=1; ++i) {
  x = -dx;
  if (i == 1) x = 0;
  y = -dy/3;
  if (i == 1) y = -dy;
  buffer[npoly+npoly] = xc + x;
  test = y * persp + persp;
  test /= yrad;
  /*printf("\natest %d: %d  %d %d        ", test, y, persp, yrad);*/
  buffer[npoly+npoly] += test;
  buffer[npoly+npoly+1] = yc + y;
  ++npoly;
 }
 for (i=0; i<=1; ++i) {
  x = dx;
  y = -dy / 3;
  if (i == 1) x = dx;
  if (i == 1) y = dy / 2;
  buffer[npoly+npoly] = xc + x;
  test = y * persp + persp;
  test /= yrad;
  /*printf("\natest %d: %d  %d %d        ", test, y, persp, yrad);*/
  buffer[npoly+npoly] += test;
  buffer[npoly+npoly+1] = yc + y;
  ++npoly;
 }
 zfillpoly(npoly, buffer);
} 
*/

void zfillips(xc, yc, dx, dy)
int xc, yc, dx, dy;
{
 dx *= 30 + abs(persp);
 dx /= 30;
 dy *= 30 + abs(persp);
 dy /= 30;
 zfillellipse(xc, yc, dx, dy);
 /*
 int x, y;
 int a2, b2, y2;
 int buffer[100], npoly;
 long test;
 a2 = dx * dx + dx;
 b2 = dy * dy;
 npoly = 0;
 for (y=0; y<=dy; ++y) {
  y2 = y * y;
  x = isqrt(a2 - (a2 * y2) / b2);
  buffer[npoly+npoly] = xc + x;
  test = y * persp + persp;
  test /= yrad;
  /*printf("\natest %d: %d  %d %d        ", test, y, persp, yrad);*/
  buffer[npoly+npoly] += test;
  buffer[npoly+npoly+1] = yc + y;
  ++npoly;
 }
 for (y=dy-1; y>=0; --y) {
  y2 = y * y;
  x = isqrt(a2 - (a2 * y2) / b2);
  buffer[npoly+npoly] = xc - x;
  test = y * persp + persp;
  test /= yrad;
  buffer[npoly+npoly] += test;
  buffer[npoly+npoly+1] = yc + y;
  ++npoly;
 }
 for (y=1; y<=dy; ++y) {
  y2 = y * y;
  x = isqrt(a2 - (a2 * y2) / b2);
  buffer[npoly+npoly] = xc - x;
  test = y * persp + persp;
  test /= yrad;
  buffer[npoly+npoly] -= test;
  buffer[npoly+npoly+1] = yc - y;
  ++npoly;
 }
 for (y=dy-1; y>=0; --y) {
  y2 = y * y;
  x = isqrt(a2 - (a2 * y2) / b2);
  buffer[npoly+npoly] = xc + x;  
  test = y * persp + persp;
  test /= yrad;
  buffer[npoly+npoly] -= test;
  buffer[npoly+npoly+1] = yc - y;
  ++npoly;
 }
 zfillpoly(npoly, buffer);
 */
} 

void add(index)
unsigned index;
{
 unsigned x, y, xc, yc;
 struct root *rootp;
 if (!hide) {
  curof(scrindex);
  scrindex = index;
  curof(scrindex);
  if (!col80) {
   index = twist(index);
   xy(index, &x, &y);
   xc = xgboard(index);
   yc = ygboard(index);
   if (colour == WHT) {
    setcolor(BLACK);
    whitefill();
    zfillips(xc, yc, xrad-2, yrad-1);
   }
   else {
    #if DDD
    setcolor(WHITE);
    #else
    setcolor(BLACK);
    #endif
    blackfill();
    if ((xrad == 13) && (yrad == 9)) agstone(index, xc, yc);
    else zfillips(xc, yc, xrad-3, yrad-2);
   }
  }
  else {
   if (colour == WHT) scr_co(WCHAR);  /* white filled diamond */
   if (colour == BLK) scr_co(BCHAR);
  }
 }
}

void del(index)
unsigned index;
{
 unsigned x, y, xhand, yhand, z, jndex;
 unsigned xc, yc;
 if (!hide) {
  #if DDD
  if (col80)
  #endif
  curof(scrindex);
  scrindex = index;
  #if DDD
  if (col80)
  #endif
  curof(scrindex);
  index = twist(index);
  z = ((index-1) / nsize) / nsize + 1;
  jndex = index - (z-1) * nsize * nsize;
  xy(jndex, &x, &y);
  xhand = 0;
  if (x == 4) xhand = 1;
  if (x == 10) xhand = 1;
  if (x == 16) xhand = 1;
  yhand = 0;
  if (y == 4) yhand = 1;
  if (y == 10) yhand = 1;
  if (y == 16) yhand = 1;
  if (!col80) {
   setcolor(WHITE);
   xy(index, &x, &y);
   xc = xgboard(index);
   yc = ygboard(index);

   #if DDD
   #else
   gauzefill();
   zfillquad(xc-xrad-persp, yc-yrad,
             xc+xrad-persp, yc-yrad,
             xc+xrad+persp, yc+yrad, 
             xc-xrad+persp, yc+yrad); 
   #endif

   setcolor(BLACK);
   if (north(index)) {
    zline(xc, yc, xc+persp, yc+yrad);
   }
   if (west(index)) {
    zline(xc, yc, xc-xrad-1, yc+persp/2);
   }
   if (east(index)) {
    zline(xc, yc, xc+xrad, yc-persp/2);
   }
   if (south(index)) {
    zline(xc, yc, xc-persp, yc-yrad-1);
   }
  }
  else {
   if (xhand && yhand) scr_co(0xf9);
   else scr_co(0xfa);
  }
 }
}

void sayso(index)
unsigned index;
{
 if (sui && inform && col80) {
  newline();
  printf(" sui ");
  coords(index);
 }
 if (ko && inform && col80) {
  newline();
  printf(" ko ");
  coords(index);
 }
}

#if DDD
void intersect(unsigned index, unsigned j)
{
 unsigned xi, yi, xj, yj;
 unsigned z;
 unsigned xc, yc;
 xy(index, &xi, &yi);
 xy(j, &xj, &yj);
 index = twist(index);
 if (xi == xj) {
  xc = xgboard(index);
  yc = ygboard(index);
  setcolor(WHITE);
  if (up(index)) {
   zline(xc, yc, xc, yc+zinc);
  }
  if ((twister == 0) || (twister == 2)) {
   if (west(index)) {
    zline(xc, yc, xc-xrad-1, yc+persp/2);
   }
   if (east(index)) {
    zline(xc, yc, xc+xrad, yc-persp/2);
   }
  }
  else {
   if (north(index)) {
    zline(xc, yc, xc+persp, yc+yrad);
   }
   if (south(index)) {
    zline(xc, yc, xc-persp, yc-yrad-1);
   }
  }
  if (down(index)) {
   zline(xc, yc, xc, yc-zinc+1);
  }
 }
 if (yi == yj) {
  xc = xgboard(index);
  yc = ygboard(index);
  setcolor(WHITE);
  if (up(index)) {
   zline(xc, yc, xc, yc+zinc);
  }
  if ((twister == 0) || (twister == 2)) {
   if (north(index)) {
    zline(xc, yc, xc+persp, yc+yrad);
   }
   if (south(index)) {
    zline(xc, yc, xc-persp, yc-yrad-1);
   }
  }
  else {
   if (west(index)) {
    zline(xc, yc, xc-xrad-1, yc+persp/2);
   }
   if (east(index)) {
    zline(xc, yc, xc+xrad, yc-persp/2);
   }
  }
  if (down(index)) {
   zline(xc, yc, xc, yc-zinc+1);
  }
 }
}
#endif


void showdead()
{
 unsigned index;
 struct link *rootlp;
 struct root *rootp;
 struct link *stonep;
 int xc, yc;
 rootlp = rootlist->nextl;
 if (rootlp) {
  do {
   rootp = rootlp->loc;
   stonep = rootp->neighbs->nextl;
   do {
    index = stonep->loc;
    if (!rootp->reallive && !rootp->realdead) {
     if (col80) {
      locatec(index);
      if (rootp->clr == BLK) scr_co(BSEKI);
      if (rootp->clr == WHT) scr_co(WSEKI);
     }
     if (!col80) {
      xc = xgboard(index);
      yc = ygboard(index);
      if (rootp->clr == BLK) {
       setcolor(WHITE);
       setbkcolor(BLACK);
       blackfill();
       zfillellipse(xc, yc, xrad/3, yrad/3);
       setcolor(WHITE);
       setbkcolor(BLACK);
      }
      if (rootp->clr == WHT) {
       setcolor(BLACK);
       whitefill();
       zfillips(xc, yc, xrad/3, yrad/3);
       setcolor(WHITE);
      }
     }
    }
    if (rootp->realdead) {
     if (col80) {
      locatec(index);
      if (rootp->clr == BLK) scr_co(BDEAD);
      if (rootp->clr == WHT) scr_co(WDEAD);
     }
     if (!col80) {
      xc = xgboard(index);
      yc = ygboard(index);
      if (rootp->clr == BLK) {
       setcolor(WHITE);
       setbkcolor(BLACK);
       whitefill();
       zfillellipse(xc, yc, xrad/3, yrad/3);
       setcolor(WHITE);
       setbkcolor(BLACK);
      }
      if (rootp->clr == WHT) {
       setcolor(BLACK);
       blackfill();
       zfillips(xc, yc, xrad/3, yrad/3);
       setcolor(WHITE);
      }
     }
    }
    stonep = stonep->nextl;
   } while (stonep);
   rootlp = rootlp->nextl;
  } while (rootlp);
 }
}

void board()
{
 struct root *rootp, *ptr;
 struct link *linkp, *stonep;
 unsigned i, index, temp, where, iplane, holdc, ohide;
 ohide = hide;
 hide = 0;
 if (!scrindex) scrindex = 1;
 temp = scrindex;
 holdc = colour;
 if (!col80) {
   setactivepage(0);
   visipage = 0;
  /*
  if (visipage) {
   setactivepage(0);
   visipage = 0;
  }
  else {
   setactivepage(1);
   visipage = 1;
  }
  */
 }
 #if DDD
 if (!col80) {
  newgauze();
 }
 #endif
 for (i=1; i<=nsize2; ++i) {
  invid[i] = 0;
  #if DDD
  if (col80 && sameplane(i, temp)) del(i);
  if (!col80 && sameplane(i,1)) del (i);
  if (!col80) intersect(i, temp);
  #else
  del(i);
  #endif
  if (dir[i]) {
   colour = dir[i]->clr;
   #if DDD
   if (!col80 || sameplane(i, temp))
   #endif
   add(i);
  }
 }
 colour = holdc;
 if (col80) showdead();
 if (!col80) setvisualpage(visipage);
 scrindex = temp;
 hide = ohide;
}

/* dispate used life.c ratari .. no longer */
/*
void dispate()
{
 unsigned ratp;
 struct link *stonep;
 struct root *rootp;
 unsigned jndex;
 ratp = movep->ratari;
 ratp = peek(ratp, NEXTL);
 if (ratp) {
  do {
   rootp = peek(ratp, LOC);
   stonep = rootp->neighbs;
   stonep = stonep->nextl;
   do {
    jndex = stonep->loc;
    if (jndex) curon(jndex);
    stonep = stonep->nextl;
   } while (stonep);
   ratp = peek(ratp, NEXTL);
  } while (ratp);
 }
}
*/

void dispate()
{
 unsigned index, jndex, *point, i;
 struct root *rootp;
 index = movep->midx;
 if (index) {
  point = NEWS(index);
  for (i=0; i<NLIBS; ++i) {
   jndex = *point;
   if (jndex) {
    rootp = dir[jndex];
    if (rootp) {
     if (rootp->nlib == 1) {
      if (rootp->clr == colour) {
       turnon(rootp->neighbs);
      }
     }
    }
   }
  }
 }
}

void clrscrn()
{
 unsigned i;
 if (!col80) switchscreen();
 typeset(strtscrl(), xscrl());
 for (i = stopscrl();  i >= strtscrl();  --i) {
  typeset(i, xscrl());
  clearline();
 }
 linum = strtscrl();
}

void prompt()
{
 unsigned long p1, p2, p3;
 int bscore, wscore, value;
 if (col80) {
  typeset(20, 1);
  printf("Enter #%-3d ",kount);
  if (colour == BLK) {
   printf("black %c", BCHAR);
  }
  else {
   printf("white %c", WCHAR);
  }
  typeset(21, 1);
  if (!movep->midx && (kount > 1)) printf("move %-3u was pass", kount-1);
  else if (movep->nsuicap)         printf("move %-3u suicide ", kount-1);
  else {
   if (atari) printf("ATARI ");
   else if (condition == 2) printf("red ");
   else if (condition == 3) printf("red ");
   else if (condition == 4) printf("red ");
   else if (condition == 5) printf("yel ");
   else if (condition == 6) printf("yel ");
   else if (condition == 7) printf("yel ");
   else printf("grn ");
   if ((condition <= 99) && movep->midx) {
    printf("%2d ", condition);
    if (condition == 2) printf("contact   ");
    if (condition == 3) printf("diagonal  ");
    if (condition == 4) printf("ikken-tobe");
    if (condition == 5) printf("knight    ");
    if (condition == 6) printf("dbl-ikken ");
    if (condition == 7) printf("dbl-knight");
    if (condition >= 8) printf("clear     ");
   }
   else printf("                 ");
  }
  typeset(22, 1);
  coords(scrindex);
  if (fixhead) printf(" fixhead"); else printf("        ");
  typeset(20,21);
  printf("%-5u %-5u %-6u",nplg,npage,npxt);
  typeset(21,21);

  printf("%-5u %-5u %-6u",mxlg,maxpage,mxxt);
  typeset(22,21);
  printf("%-5u %-5u %-6u",almxlg,allomax,almxxt);

  typeset(23, 1);
  printf("Eyes: Area: Sphr: Test:");
  typeset(24, 1);
  bscore = eyescore[BLK];
  wscore = eyescore[WHT];
  value = bscore - wscore;
  if (value > 0) printf("B+%-3d ", value);
  else if (value < 0) printf("W+%-3d ", -value);
  else                printf("tied  ");
  bscore = triscore[BLK];
  wscore = triscore[WHT];
  value = bscore - wscore;
  if (!areaon) printf("OFF   ");
  else {
   if (value > 0) printf("B+%-3d ", value);
   else if (value < 0) printf("W+%-3d ", -value);
   else                printf("tied  ");
  }
  bscore = sphscore[BLK];
  wscore = sphscore[WHT];
  value = bscore - wscore;
  if (value > 0) printf("B+%-3d ", value);
  else if (value < 0) printf("W+%-3d ", -value);
  else                printf("tied  ");
  value = -(scoresek() - BIAS);
  if (colour == BLK) value = -value;
  if (value > 0) printf("B+%-3d ", value);
  else if (value < 0) printf("W+%-3d ", -value);
  else                printf("tied  ");
  typeset(24, 30);
  if (bauto || wauto) printf(" auto ");
  else printf("      ");
 }
 /*dispate();*/
}

void menu()
{
 clrscrn();
 #if DONUT
 newline();
 printf("Edgeless Go");
 newline();
 printf("Use . key to center cursor");
 #endif
 #if DDD == 3
 newline();
 printf("Solid Go - 3D Go board");
 newline();
 printf(" use PgUp PgDn for cursor");
 #endif
 newline();
 printf(" Use arrows");
 printf(" to move cursor.");
 newline();
 printf(" Press Enter to");
 printf(" make move.");
 newline();
 printf("%c automatic moves", 0x5E);
 newline();
 printf("m manual moves ");
 newline();
 printf("- take move back");
 newline();
 printf("0 to pass");
 newline();
 printf("= skip opponent", 0x5E);
 newline();
 printf(". clean board");
 newline();
 printf(": clean message screen");
 newline();
 /*
 printf(", note last");
 newline();
 */
 printf("p  pause");
 newline();
 printf("Tt delay on/off");
 /*
 newline();
 if (chinese) printf("r Chinese rules");
 else printf("r Japanese rules");
 */
 newline();
 printf("F1 text/graphics board");
 newline();
 printf("Alt flash cursor");
 #if DDD
 newline();
 printf("<> view point");
 #else
 newline();
 printf("F5 debug level");
 #endif
 newline();
 /*
 printf("[]{}<> view point");
 newline();
 */
 printf("? game info menu");
 newline();
 printf("! file/command menu");
 newline();
 printf("h this help menu");
 /*
 newline();
 printf("H hide lookahead moves");
 */
 newline();
 printf("Esc exit game");
}

int switchscreen()
{
 if (!col80) {
  restorecrtmode();
  scr_cursoff();
  clrscr();
  col80 = 1;
  hide = hidelook;
  board();
  prompt();
  /*dispate();*/
  clrscrn();
 }
 else if (col80) {
  clrscr();
  setgraphmode(graphmode);
  setvisualpage(0);
  setactivepage(1);
  zplt(360, 160, 0);
  iprintf("hi");
  setactivepage(0);
  visipage = 0;
  col80 = 0;
  #if DDD
  newplt();
  #endif
  board();
  hide = 1;
 }
 return(0);
}

void textscreen()
{
 if (!col80) switchscreen();
}

/*
unsigned curmove(number)
unsigned number;
{
 unsigned *point, testmove;
 #define NORTH 30
 #define WEST 29
 #define EAST 28
 #define SOUTH 31
 if (number == 202) {     /* north east */
  curmove(NORTH);
  curmove(EAST);
  return(number);
 }
 if (number == 200) {     /* north west */
  curmove(NORTH);
  curmove(WEST);
  return(number);
 }
 if (number == 201) {     /* south west */
  curmove(SOUTH);
  curmove(WEST);
  return(number);
 }
 if (number == 203) {     /* south east */
  curmove(SOUTH);
  curmove(EAST);
  return(number);
 }
 point = NEWS(scrindex);
 if (number == NORTH) {     /* north */
  testmove = *point;
  if (testmove) {
   scrindex = testmove;
  }
  return (number);
 }
 ++point;
 if (number == WEST) {     /* west */
  testmove = *point;
  if (testmove) {
   scrindex = testmove;
  }
  return (number);
 }
 ++point;
 if (number == EAST) {     /* east */
  testmove = *point;
  if (testmove) {
   scrindex = testmove;
  }
  return (number);
 }
 ++point;
 if (number == SOUTH) {     /* south */
  testmove = *point;
  if (testmove) {
   scrindex = testmove;
  }
  return (number);
 }
 return (0);
}
*/



unsigned curmove(number)
unsigned number;
{
 unsigned *point, testmove, hh;
/*
 #define NORTH 30
 #define WEST 29
 #define EAST 28
 #define SOUTH 31
 #define PGUP 202
 #define PGDN 203
 #define HOME 200
 #define ENDZ 201
*/
 /*
 if (number == PGUP) {     /* north east */
  curmove(NORTH);
  curmove(EAST);
  return(number);
 }
 if (number == HOME) {     /* north west */
  curmove(NORTH);
  curmove(WEST);
  return(number);
 }
 if (number == ENDZ) {     /* south west */
  curmove(SOUTH);
  curmove(WEST);
  return(number);
 }
 if (number == PGDN) {     /* south east */
  curmove(SOUTH);
  curmove(EAST);
  return(number);
 }
 */

 if (number == UP) {     /* north */
  testmove = north(scrindex);
  if (!col80) {
   if (twister == 1) testmove = west(scrindex);
   if (twister == 2) testmove = south(scrindex);
   if (twister == 3) testmove = east(scrindex);
  }
  if (testmove) {
   scrindex = testmove;
   #if DDD
   hh = hide;
   hide = 0;
   if (!col80) board();
   #endif
  }
  return (number);
 }
 if (number == LEFT) {     /* west */
  testmove = west(scrindex);
  if (!col80) {
   if (twister == 1) testmove = south(scrindex);
   if (twister == 2) testmove = east(scrindex);
   if (twister == 3) testmove = north(scrindex);
  }
  if (testmove) {
   scrindex = testmove;
   #if DDD
   hh = hide;
   hide = 0;
   if (!col80) board();
   #endif
  }
  return (number);
 }
 if (number == RIGHT) {     /* east */
  testmove = east(scrindex);
  if (!col80) {
   if (twister == 1) testmove = north(scrindex);
   if (twister == 2) testmove = west(scrindex);
   if (twister == 3) testmove = south(scrindex); 
  }
  if (testmove) {
   scrindex = testmove;
   #if DDD
   hh = hide;
   hide = 0;
   if (!col80) board();
   #endif
  }
  return(number);
 }
 if (number == DOWN) {     /* south */
  testmove = south(scrindex);
  if (!col80) {
   if (twister == 1) testmove = east(scrindex);
   if (twister == 2) testmove = north(scrindex);
   if (twister == 3) testmove = west(scrindex);
  }
  if (testmove) {
   scrindex = testmove;
   #if DDD
   hh = hide;
   hide = 0;
   if (!col80) board();
   #endif
  }
  return(number);
 }

 #if DDD
 hh = hide;
 hide = 0;
 if (number == PGUP) {     /* up */
  testmove = up(scrindex);
  if (testmove) {
   scrindex = testmove;
   board();
  }
  return(number);
 }
 if (number == PGDN) {     /* down */
  testmove = down(scrindex);
  if (testmove) {
   scrindex = testmove;
   board();
  }
  return (number);
 }
 hide = hh;
 #endif
 return (0);
}


/*
unsigned gkey()
{
 unsigned key;
 key = 0;
 key = bioskey(1);  /* status only */
 if (key) {
  if (key == 3) {
   fix();
   exit(0);
  }
  if (!mask && key) {
   key = solkey();
   return (key);
  }
 }
 return (0);
}
*/

int keybreak(c)
unsigned c;
{
 /* keybreak(0) to set attn if any key is pressed */
 /* keybreak('p') to pause (useful for debugging) */
 unsigned dummy, delay, oline, key;
 dummy = c;
 if (!dummy) {
  dummy = bioskey(1); /* key status */
  if (dummy) {
   dummy = solkey();  /* clear key status and get key */
   flushkey();
   if (1) {
    attn = dummy;
    if (attn == 'T') attn = 0; /* allow timer to change on the fly */
    if (attn == 't') attn = 0; /* allow timer to change on the fly */
    if (attn == 'p') attn = 0; /* allow pause to be transparent */
    if (attn == 'P') attn = 0; /* allow pause to be transparent */
    if (attn == '-') attn = 0; /* allow backing up to be transparent */
    if (attn == UP) attn = 0; /* allow cursor to be transparent */
    if (attn == LEFT) attn = 0; /* allow cursor to be transparent */
    if (attn == RIGHT) attn = 0; /* allow cursor to be transparent */
    if (attn == DOWN) attn = 0; /* allow cursor to be transparent */
    /*if (!bauto && !wauto) attn = 0;*/ /* jump the gun */
    if (attn) {
     if (col80) {
      subline();
      printf(" ATTN: auto off, timer reset.");
      typeset(24, 30);
      printf("-ATTN-");
     }
     bauto = 0;
     wauto = 0;
     timer = 0;
    }
   }
  }
 }
 if (dummy == 't') {
  attn = 0;
  timer = 0;
  newline();
  printf("keybreak:t reset");
 }
 else if (dummy == 'T') {
  attn = 0;
  timer += 10;
  if (timer > 100) timer = 100;
  newline();
  printf("kbrk: T %u0 ms", timer);
 }
 else if ((dummy == 'p') || (dummy == 'P')) {
  oline = linum;
  subline();
  printf(" PAUSE: (! to set ATTN)");
  scr_curson();
  do {
   key = solkey();
  } while (!key);
  scr_cursoff();
  if (key == '!') {
   attn = 1;
   bauto = 0;
   wauto = 0;
   timer = 0;
   newline();
   printf(" ATTN: ");
   hundelay(25);
  }
  else attn = 0;
  linum = oline;
  subline();
  linum = oline;
 }
 /*if (timer) hundelay(timer);*/
 if (attn) {
  flushkey();
  return(0);
 }
 return(dummy);
}

unsigned cursor(number)
unsigned number;
{
 unsigned result;
 result = curmove(number);
 return (result);
}

void beep(unsigned freq, unsigned hunds)
{
 sound(freq);
 hundelay(hunds);
 nosound();
}

int juggler()   /* !!int!! returns control as positive  board negated */
{
 int number;
 int fake;
 int toggle, counter;
 char zc[9][9];
 int i, j, dx, dy;
 unsigned invflag, oldex, ohide, temp;
 oldex = scrindex;
 ohide = hide;
 hide = hidelook;
 invflag = invid[scrindex];
 #if DDD
 if (col80) board();
 #endif
 curon(scrindex);
 toggle = 0;
 cput(0);
 beep(2000, 10);
 do {
  if (col80) {
   typeset(22, 1);
   coords(scrindex);
  }
  mask = 0;
  counter = cput(1);
  if (counter > 95) toggle = 1;
  if (toggle) {
   if (invflag) curof(scrindex);
   else curon(scrindex);
  }
  else {
   if (invflag) curon(scrindex);
   else curof(scrindex);
  }
  if (counter > 100) {
   cput(0);
   toggle = 0;
  }
  number = rand(); /* random numbers while waiting at keyboard */
  if (!col80) {
   /* flash cursor when Alt key depressed */
   for (i=0; i<=8; ++i) {
    dx = xgboard(scrindex) + i - 4;
    for (j=0; j<=8; ++j) {
     dy = ygboard(scrindex) + j - 4;
     zc[i][j] = zget(dx, dy);
    }
   }
   fake = 0;
   while (bioskey(2) & 0x08) {
    ++fake;
    for (i=0; i<=8; ++i) {
     dx = xgboard(scrindex) + i - 4;
     for (j=0; j<=8; ++j) {
      dy = ygboard(scrindex) + j - 4;
      zput(dx, dy, fake%2);
     }
    }
    hundelay(10);
   }
   for (i=0; i<=8; ++i) {
    dx = xgboard(scrindex) + i - 4;
    for (j=0; j<=8; ++j) {
     dy = ygboard(scrindex) + j - 4;
     zput(dx, dy, zc[i][j]);
    }
   }
  }
  if (col80) {
   i = 0;
   while (bioskey(2) & 0x08) {
    ++i;
    if (i == 1) curon(scrindex);
    else {
     curof(scrindex);
     i = 0;
    }
    hundelay(10);
   }
  }
  number = solkey();
  if (number) {
   fake = cursor(number);
   if (fake) {
    number = 0;
    if (scrindex != oldex) {
     toggle = 1; /* keep the cursor on while moving */
     cput(0);
     #if DDD
     if (!col80) oldex = scrindex;
     #endif
     if (invflag) curon(oldex);
     else curof(oldex);
     oldex = scrindex;
     invflag = invid[scrindex];
     curon(scrindex);
    }
   }
   if (number == CR) {
    if (invflag) curon(oldex);
    else curof(oldex);
    curof(scrindex);
    number = -scrindex;
   }
  }
 }
 while (!number);
 number = -number;
 if (number == 999) number = -'0'; /* detect allowed pass */
 if (invflag) curon(scrindex);
 else curof(scrindex);
 hide = ohide;
/* attn = 0;*/
 mask = 1;
 return (number);
}

void pause()
{
 keybreak('p');
 /*
 char c;
 newline();
 printf("pause");
 mask = 0;
 do {
  c = (char) solkey();
 } while(!c);
 attn = 0;
 if (c == 3) exit(0);
 newline();
 printf("proceed");
 */
}

unsigned yes()
{
 unsigned proceed;
 unsigned c;
 newline();
 printf("press y if ok");
 mask = 0;
 do {
  c = solkey();
 } while (!c);
 if ((c == 'y') || (c == 'Y')) proceed = 1;
 else proceed = 0;
 mask = 1;
 return(proceed);
}



int pputc(int byte)   /* put char to lpt1: */
{
 int busy, ack, port, written;
 port = 0;             /* lpt1: */
 written = 0;
 do {
  busy = !(biosprint(2, 0, port) & 0x80);
  ack =  biosprint(2, 0, port) & 0x40;
  if (!busy & !ack) {
   written = 1;
   biosprint(0, byte, port);
   /* wait for acknowledge to set */
   while (biosprint(2, 0, port) & 0x40);
  }
 } while (!written); 
 return(byte);
}

int pputs(char *string)   /* put string to lpt1: */
{
 int byte;
 int i;
 i = 0;
 do {
  byte = string[i];
  if (byte) pputc(byte);
  ++ i;
 } while (byte);
 return(1);
}

unsigned gfxgetpix(int x, int y)
{
 unsigned dot;
 unsigned char byte;
 unsigned char far *addr;
 unsigned bufno, offset;
 int bit;
 int ymod4, xmod8;
 register int ydiv4, xdiv8;
 dot = 0;
 ydiv4 = y;
 ydiv4 >>= 2;
 y -= ydiv4 << 2;
 xdiv8 = x;
 xdiv8 >>= 3;
 x -= xdiv8 << 3;
 offset = 0x2000 * y + 90 * ydiv4 + xdiv8;
 addr = MK_FP(0xb000, offset);
 dot = *addr & (1 << (7-x));
 /*
 if (dot) dot = 1;
 else dot = 0;
 */
 if (dot) dot = 0;
 else dot = 1;
 return(dot);
}

unsigned char gfxgetbyte(int x, int y); /* Hercules video byte */
unsigned char gfxgetbyte(int x, int y) /* Hercules video byte */
{
 unsigned char byte;
 unsigned char mask;
 unsigned char far *addr;
 unsigned bufno, offset;
 int bit;
 int ymod4, xmod8;
 register int ydiv4, xdiv8;
 byte = 0;
 ydiv4 = y;
 ydiv4 >>= 2;
 y -= ydiv4 << 2;
 xdiv8 = x;
 xdiv8 >>= 3;
 x -= xdiv8 << 3;
 offset = 0x2000 * y + 90 * ydiv4 + xdiv8;
 addr = MK_FP(0xb000, offset);
 byte = *addr;
 return(byte);
}

int makebyte(unsigned dot, unsigned *byte, unsigned *nbits);
int makebyte(unsigned dot, unsigned *byte, unsigned *nbits)
{
 int gottun;
 gottun = 0;
 if (!*nbits) *byte = 0;
 ++ *nbits;
 if (dot) *byte |= 1 << (8 - *nbits);
 if (*nbits == 8) {
  gottun = 1;
  *nbits = 0;
 }
 return(gottun);
}

 

void bgfxprn(); /* 3x4 pixels / dot (big dots) */
void bgfxprn() /* 3x4 pixels / dot (big dots) */
{
 unsigned x, y;
 unsigned byte, nbits, dot, i;
 unsigned xc, yc;
 unsigned xxc, yyc, xok, yok;
 xc = xgboard(1) - xrad;
 yc = ygboard(1) + yrad - 2;
 xxc = xgboard(nsize2) + xrad;
 yyc = ygboard(nsize2) - yrad - 2;
 if (1) {
  /* big P wastes 89% ink (Herc graphics screen to HP Deskjet+ printer) */
  pputs("\x1b*p125X"); /* move pen to left margin */
  pputs("\x1b*t300R"); /* keep resolution at 300 dpi */
  pputs("\x1b*r2160S"); /* set raster width */
  pputs("\x1b*b0M");   /* select full graphics mode */
  pputs("\x1b*r1A");   /* start raster graphics */
  for (y=0; y<=347; ++y) {
   if ((y >= 0)) {
    yok = (y <= yc) && (y > yyc);
    pputs("\x1b*b1W");
    pputc(0);
    pputs("\x1b*b1W");
    pputc(0);
    for (i=1; i<=2; ++i) {
     byte = 0;
     nbits = 0;
     pputs("\x1b*b270W"); /* transfer 270 bytes per line */
     for (x=0; x<=719; ++x) {
      xok = (x >= xc) && (x <= xxc);
      if (xok && yok) dot = gfxgetpix(x, y);
      else dot = 0;
      if (i > 2) dot = 0;
      if (makebyte(dot, &byte, &nbits)) {
       pputc(byte);
      }
      if (makebyte(0, &byte, &nbits)) {
       pputc(byte);
      }
      if (makebyte(0, &byte, &nbits)) {
       pputc(byte);
      }
     }
    }
   }
  }
  pputs("\x1b*rB");    /* end raster graphics */
  pputs("\x1b*p+16Y"); /* move down a bit to dump buffer */
 }
}

void agfxprn();  /* 1/9 3x3 dot (little dots) */
void agfxprn()  /* 1/9 3x3 dot (little dots) */
{
 unsigned x, y;
 unsigned byte, nbits, dot, i;
 unsigned xc, yc;
 unsigned xxc, yyc, xok, yok;
 xc = xgboard(1) - xrad;
 yc = ygboard(1) + yrad - 2;
 xxc = xgboard(nsize2) + xrad;
 yyc = ygboard(nsize2) - yrad - 2;
 if (1) {
  /* small p saves 89% ink (Herc graphics screen to HP Deskjet+ printer) */
  pputs("\x1b*p125X"); /* move pen to left margin */
  pputs("\x1b*t300R"); /* keep resolution at 300 dpi */
  pputs("\x1b*r2160S"); /* set raster width */
  pputs("\x1b*b0M");   /* select full graphics mode */
  pputs("\x1b*r1A");   /* start raster graphics */
  for (y=0; y<=347; ++y) {
   yok = (y <= yc) && (y > yyc);
   if ((y >= 0)) {
    byte = 0;
    nbits = 0;
    pputs("\x1b*b1W");
    pputc(0);
    pputs("\x1b*b1W");
    pputc(0);
    pputs("\x1b*b1W");
    pputc(0);
    pputs("\x1b*b270W"); /* transfer 270 bytes per line */
    for (x=0; x<=719; ++x) {
     xok = (x >= xc) && (x <= xxc);
     if (xok && yok) dot = gfxgetpix(x, y);
     else dot = 0;
     if (makebyte(0, &byte, &nbits)) {
      pputc(byte);
     }
     if (makebyte(0, &byte, &nbits)) {
      pputc(byte);
     }
     if (makebyte(dot, &byte, &nbits)) {
      pputc(byte);
     }
    }
   }
  }
  pputs("\x1b*rB");    /* end raster graphics */
  pputs("\x1b*p+16Y"); /* move down a bit to dump buffer */
 }
}

unsigned paws()  /* graphics mode pause */
{
 unsigned huh;
 flushkey();
 zymbol(600, 15, "press a key ");
 /* p for draft graphics to printer */
 /* P for more ink */
 zplt(593, 18, 0);
 zplt(593, 5, 1);
 zplt(592, 18, 0);
 zplt(592, 5, 1);
 zplt(696, 5, 1);
 zplt(696, 18, 1);
 zplt(592, 18, 1);
 zplt(695, 5, 0);
 zplt(695, 18, 1);
 setcolor(BLACK);
 zymbol(699, 15, "OK");
 setcolor(WHITE);
 huh = getkey();
 zymbol(699, 15, "OK");
 if (huh == 3) {
  restorecrtmode();
  _exit(0);
 }
 if (huh == 'p') {
  agfxprn();
  moveto(hercx(699), hercy(15));
  outtext("p");
  huh = getkey();  /* allow user to leave after printout */
  if (huh == 3) {
   restorecrtmode();
   _exit(0);
  }
 }
 if (huh == 'P') {
  bgfxprn();
  moveto(hercx(699), hercy(15));
  outtext("P");
  huh = getkey();  /* allow user to leave after printout */
  if (huh == 3) {
   restorecrtmode();
   _exit(0);
  }
 }
 hundelay(40);
 return(huh);
}

