Declare Function VerInstallFile& Lib "ver.dll" (ByVal Flags%, ByVal SrcFile$, ByVal DestFile$, ByVal SrcPath$, ByVal DestPath$, ByVal CurrDir$, ByVal TmpFile$, lpwTmpFileLen%)
Declare Function GetFileVersionInfoSize Lib "ver.dll" (ByVal lpszFileName As String, lpdwHandle As Long) As Long
Declare Function GetFileVersionInfo Lib "ver.dll" (ByVal lpszFileName As String, ByVal lpdwHandle As Long, ByVal cbbuf As Long, ByVal lpvdata As String) As Integer
Declare Function VerQueryValue Lib "ver.dll" (ByVal lpvBlock As String, ByVal lpszSubBlock As String, lplpBuffer As Long, lpcb As Integer) As Integer
Declare Function VerLanguageName Lib "ver.dll" (ByVal LangID As Integer, ByVal LangName As String, ByVal LangLen As Integer) As Integer
Declare Function lstrcpyn Lib "Kernel" (ByVal lpszString1 As Any, ByVal lpszString2 As Long, ByVal cChars As Integer) As Long
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lplFileName As String) As Integer
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Integer, ByVal lpFileName As String) As Integer

Type VerInfo
    FileVersion As String
    FileDescription As String
    CompanyName As String
    Language As String
    Comments As String
    OriginalFileName As String
    InternalName As String
    LegalCopyright As String
    LegalTrademarks As String
    ProductName As String
    ProductVersion As String
    SpecialBuild As String
    PrivateBuild As String
End Type

Global BrowseTop As Integer
Global BrowseLeft As Integer
Global DispTop As Integer
Global DispLeft As Integer
Global PrintTop As Integer
Global PrintLeft As Integer

Dim ResName(16) As String
Dim ResValue(16) As String

Function GetFileVersion (FileToCheck As String, VI As VerInfo) As Integer
    Dim VersionInfoSize As Long  ' size of Version Resource
    Dim Handle As Long ' Handle to Version Resource
    Dim VerRes As String ' Version resource, retrieved from File
    Dim Value As String '  String returned by API call
    Dim ValueLen As Integer ' Length of String returned by API call (Value)
    Dim Pointer As Long ' 32-bit address of string returned by API call
    Dim Result As Integer ' 16-bit value returned by API call
    Dim lResult As Long ' 32-bit value returned by API call
    Dim Translation As String ' Language/Charset value, in hex
    
    ' Reset Version info
    VI.FileVersion = ""
    VI.FileDescription = ""
    VI.CompanyName = ""
    VI.Language = ""
    VI.OriginalFileName = ""
    VI.InternalName = ""
    VI.Comments = ""
    VI.LegalCopyright = ""
    VI.LegalTrademarks = ""
    VI.ProductName = ""
    VI.ProductVersion = ""
    VI.SpecialBuild = ""
    VI.PrivateBuild = ""
    
    On Error Resume Next
    VersionInfoSize = GetFileVersionInfoSize(FileToCheck, Handle) ' How big is the V/R?
    If VersionInfoSize = 0 Then ' No Version Resource present :(
        GetFileVersion = False
        Exit Function
    End If

    VerRes = String$(VersionInfoSize, Chr$(0))
    Result = GetFileVersionInfo(FileToCheck, Handle, VersionInfoSize, VerRes) ' get copy of V/R

    Result = VerQueryValue(VerRes, "\VarFileInfo\Translation", Pointer, ValueLen) ' Get translation info
    If ValueLen = 4 Then ' Looks like we've got a valid translation info
        Value = String$(ValueLen + 1, Chr$(0))
        lResult = lstrcpyn(Value, Pointer, ValueLen + 1)
        Translation = ToHex(Left$(Value, 4)) ' trim the trailing null, and convert to hex
        GoTo GetValues ' Let's start extracting version info!
    Else ' apparently the Translation info is not there, let's try guessing ...
        Translation = "040904E4" ' Let's guess it's U.S. English/Charset 1252 (Windows Multilingual)
        Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\CompanyName", Pointer, ValueLen)
        If Result <> 0 Then GoTo GetValues ' Good Guess!
    End If

    GetFileVersion = False ' No Luck
    Exit Function

GetValues:
    'Retrieve File information
    Value = String$(32, " ")
    Result = VerLanguageName(Val("&h" + Left$(Translation, 4)), Value, 32)
    If Result Then
        VI.Language = Left$(Value, InStr(Value, Chr$(0)) - 1)
    End If

    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\FileVersion", Pointer, ValueLen)
    If Result = 1 Then
        VI.FileVersion = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.FileVersion, Pointer, ValueLen + 1)
        VI.FileVersion = Left$(VI.FileVersion, InStr(VI.FileVersion, Chr$(0)) - 1)
      End If
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\FileDescription", Pointer, ValueLen)
    If Result = 1 Then
        VI.FileDescription = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.FileDescription, Pointer, ValueLen + 1)
        VI.FileDescription = Left$(VI.FileDescription, InStr(VI.FileDescription, Chr$(0)) - 1)
    End If
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\CompanyName", Pointer, ValueLen)
    If Result = 1 Then
        VI.CompanyName = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.CompanyName, Pointer, ValueLen + 1)
        VI.CompanyName = Left$(VI.CompanyName, InStr(VI.CompanyName, Chr$(0)) - 1)
    End If
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\OriginalFileName", Pointer, ValueLen)
    If Result = 1 Then
        VI.OriginalFileName = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.OriginalFileName, Pointer, ValueLen + 1)
        VI.OriginalFileName = Left$(VI.OriginalFileName, InStr(VI.OriginalFileName, Chr$(0)) - 1)
    End If
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\InternalName", Pointer, ValueLen)
    If Result = 1 Then
        VI.InternalName = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.InternalName, Pointer, ValueLen + 1)
        VI.InternalName = Left$(VI.InternalName, InStr(VI.InternalName, Chr$(0)) - 1)
    End If
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\Comments", Pointer, ValueLen)
    If Result = 1 Then
        VI.Comments = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.Comments, Pointer, ValueLen + 1)
        VI.Comments = Left$(VI.Comments, InStr(VI.Comments, Chr$(0)) - 1)
    End If
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\LegalCopyright", Pointer, ValueLen)
    If Result = 1 Then
        VI.LegalCopyright = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.LegalCopyright, Pointer, ValueLen)
        VI.LegalCopyright = Left$(VI.LegalCopyright, InStr(VI.LegalCopyright, Chr$(0)) - 1)
    End If
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\LegalTrademarks", Pointer, ValueLen)
    If Result = 1 Then
        VI.LegalTrademarks = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.LegalTrademarks, Pointer, ValueLen + 1)
        VI.LegalTrademarks = Left$(VI.LegalTrademarks, InStr(VI.LegalTrademarks, Chr$(0)) - 1)
    End If
    
    ' Retrieve Product information
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\ProductName", Pointer, ValueLen)
    If Result = 1 Then
        VI.ProductName = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.ProductName, Pointer, ValueLen + 1)
        VI.ProductName = Left$(VI.ProductName, InStr(VI.ProductName, Chr$(0)) - 1)
    End If
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\ProductVersion", Pointer, ValueLen)
    If Result = 1 Then
        VI.ProductVersion = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.ProductVersion, Pointer, ValueLen + 1)
        VI.ProductVersion = Left$(VI.ProductVersion, InStr(VI.ProductVersion, Chr$(0)) - 1)
    End If

    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\SpecialBuild", Pointer, ValueLen)
    If Result = 1 Then
        VI.SpecialBuild = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.SpecialBuild, Pointer, ValueLen + 1)
        VI.SpecialBuild = Left$(VI.SpecialBuild, InStr(VI.SpecialBuild, Chr$(0)) - 1)
    End If
    Result = VerQueryValue(VerRes, "\StringFileInfo\" & Translation & "\PrivateBuild", Pointer, ValueLen)
    If Result = 1 Then
        VI.PrivateBuild = String$(ValueLen + 2, Chr$(0))
        lResult = lstrcpyn(VI.PrivateBuild, Pointer, ValueLen + 1)
        VI.PrivateBuild = Left$(VI.PrivateBuild, InStr(VI.PrivateBuild, Chr$(0)) - 1)
    End If
    
    GetFileVersion = True
End Function

Function ToHex (In As String) As String
    Dim Out As String
    Dim Temp As String

    If (Len(In) Mod 2) <> 0 Then In = "0" + In ' add leading 0 if needed

    Out = ""
    For i = 1 To Len(In) Step 2
        Temp = Hex$(Asc(Mid$(In, i + 1, 1))) ' Because of Intel's "Reversed-Byte" architecture
        If Len(Temp) = 1 Then Out = Out + "0" ' handle second byte first
        Out = Out + Temp

        Temp = Hex$(Asc(Mid$(In, i, 1)))  ' now handle first byte in word
        If Len(Temp) = 1 Then Out = Out + "0" ' add leading zero if necessary
        Out = Out + Temp
    Next
    ToHex = Out
End Function

