@echo OFF
REM *******************************************************************
REM *** KbdBuf.bat - CEnvi sample file which will, on most systems, ***
REM *** ver.1        increase the keyboard typeahead buffer size.   ***
REM *******************************************************************
@cenvi %0.bat %1 %2
GOTO CENVI_EXIT

#define MIN_TYPEAHEAD 1
#define MAX_TYPEAHEAD 127

main(argc,argv)
{
   if ( argc != 2  || !strcmpi(argv[1],"/?") )
      Instructions()
   else {
      // check input value for valid range
      typeahead = atoi(argv[1]);
      if ( typeahead < MIN_TYPEAHEAD || MAX_TYPEAHEAD < typeahead ) {
         printf("\aInvalid input value; enter /? for instructions\n");
      } else {
         SetTypeahead(typeahead);
      }
   }
}

SetTypeahead(BufSize)   // set size of the typeahead buffer
{
   #define NEXT_CHAR_PTR   0x41A
   #define LAST_CHAR_PTR   0x41C
   #define KYBD_BUF_START_PTR    0x480
   #define KYBD_BUF_END_PTR      0x482
   BufferLocation = ( BufSize <= 15 ) ? 0x1E : 0x200 ;
   poke(NEXT_CHAR_PTR,BufferLocation,UWORD16);
   poke(LAST_CHAR_PTR,BufferLocation,UWORD16);
   poke(KYBD_BUF_START_PTR,BufferLocation,UWORD16);
   poke(KYBD_BUF_END_PTR,BufferLocation+(2*(BufSize+1)),UWORD16);
}

Instructions()
{
   printf("\n")
   printf("KbdBuf - Set keyboard typeahead buffer size\n")
   printf("\n")
   printf("USAGE: KbdBuf <size>\n")
   printf("\n")
   printf("Where: size   Size of the typeahead buffer; min = %d max = %d\n",MIN_TYPEAHEAD,MAX_TYPEAHEAD);
   printf("\n")
}

:CENVI_EXIT
