@echo OFF
REM ********************************************************************
REM *** KbdRate.bat - CEnvi sample file which will, on most systems, ***
REM *** ver.1         set the keyboard typematic values.             ***
REM ********************************************************************
@cenvi %0.bat %1 %2 %3
GOTO CENVI_EXIT

#define MIN_DELAY    1
#define MAX_DELAY    4
#define MIN_RATE     2
#define MAX_RATE     30

main(argc,argv)
{
   if ( argc != 3 )
      Instructions()
   else {
      // check input values for valid ranges
      delay = atoi(argv[1]);
      rate = atoi(argv[2]);
      if ( delay < MIN_DELAY  ||  MAX_DELAY < delay
        || rate < MIN_RATE  ||  MAX_RATE < rate ) {
         printf("\aInvalid input value; enter /? for instructions\n");
      } else {
         SetDelayAndRate(delay,rate);
      }
   }
}

SetDelayAndRate(delay,rate)   // delay in 1/4 sec; rate in reps/sec
{
   // set delay value
   reg.bh = delay - 1;
   // set table for which delay corresponds to the rate
   DelayApproximations = {     31, 26, 23, 20, 18, 17, 15, 13, 12,
                           11, 10,  9,  9,  8,  7,  6,  5,  5,  4,
                            3,  3,  2,  2,  2,  1,  1,  1,  0,  0 };
   reg.bl = DelayApproximations[rate-MIN_RATE];
   // finall call dos interrupt 16, function 03 to set delay and rate
   reg.ax = 0x0305;
   interrupt(0x16,reg);
}

Instructions()
{
   printf("\n")
   printf("KbdRate - Set keyboard typematic rates.  This works with most BIOS's\n")
   printf("\n")
   printf("USAGE: KbdRate Delay Rate\n")
   printf("\n")
   printf("Where: Delay - Delay in 1/4 seconds before repeat; min = %d, max = %d\n",MIN_DELAY,MAX_DELAY);
   printf("       Rate  - Repetitions of key per second; min = %d, max = %d\n",MIN_RATE,MAX_RATE);
   printf("\n")
}

:CENVI_EXIT
