@echo off
REM *************************************************************************
REM *** Mouse.bat - Display mouse information.  This is an example of     ***
REM *** ver.1       using the CEnvi interrupt() function.  The            ***
REM ***             functions will make frequent use of a mouse           ***
REM ***             structure as follows:                                 ***
REM ***                 Col      - mouse column on screen                 ***
REM ***                 Row      - mouse row on screen                    ***
REM ***                 Left     - True if left button down, else False   ***
REM ***                 Middle   - True if middle button down, else False ***
REM ***                 Right    - True if right button down, else False  ***
REM *************************************************************************
cenvi %0.bat
GOTO CENVI_EXIT

main()
{
   if ( !InitializeMouse() ) {
      printf("I cannot find a mouse!\a\n")
   } else {
      printf("Displaying mouse status until you press any key:\n")
      printf("Col\tRow\tLeft\tMiddle\tRight\n")
      FlushKeyboard();
      DisplayMouse()
      OldMouse.Row = -1    // force first comparison to be not equal
      while( !kbhit() ) {
         GetMouseState(Mouse)
         if ( Mouse != OldMouse ) {
            // mouse state has changed, and so display new state
            HideMouse()       // must be hidden while screen is changed
            printf("\r%d\t%d\t%s\t%s\t%s",
                   Mouse.Col, Mouse.Row,
                   Mouse.Left ? "DOWN" : "UP  ",
                   Mouse.Middle ? "DOWN" : "UP  ",
                   Mouse.Right ? "DOWN" : "UP  " );
            DisplayMouse()    // must be hidden while screen is changed
            OldMouse = Mouse
         }
      }
      ResetMouse()
      FlushKeyboard();
      printf("\n")
   }
}


FlushKeyboard()
{
   while( kbhit() )
      getch()
}

#define  MOUSE_INTERRUPT      0x33
#define  DRIVER_INSTALLED     0xFFFF
#define  RESET_MOUSE_DRIVER   0
#define  GET_MOUSE_STATE      3
#define  HIDE_MOUSE           2
#define  DISPLAY_MOUSE        1
#define  LEFT_BUTTON_MASK     0x0001
#define  MIDDLE_BUTTON_MASK   0x0004
#define  RIGHT_BUTTON_MASK    0x0002

InitializeMouse()
{
   // determine if mouse exists be calling function to see if mouse driver exists
   // and then checking how many buttons it has.  If zero buttons then no mouse.
   reg.ax = RESET_MOUSE_DRIVER
   interrupt(MOUSE_INTERRUPT,reg)
   if ( DRIVER_INSTALLED != reg.ax )
      // Error, no mouse driver installed
      return(False)
   if ( 0 == reg.bx )
      // No buttons means no mouse
      return(False)
   return(True)
}

ResetMouse()
{
   InitializeMouse()
}

GetMouseState(m)
{
   reg.ax = GET_MOUSE_STATE
   interrupt(MOUSE_INTERRUPT,reg)
   m.Col = (reg.cx >> 3) + 1
   m.Row = (reg.dx >> 3) + 1
   m.Left = (reg.bx & LEFT_BUTTON_MASK) ? True : False
   m.Middle = (reg.bx & MIDDLE_BUTTON_MASK) ? True : False
   m.Right = (reg.bx & RIGHT_BUTTON_MASK) ? True : False
}

HideMouse()
{
   reg.ax = HIDE_MOUSE
   interrupt(MOUSE_INTERRUPT,reg)
}

DisplayMouse()
{
   reg.ax = DISPLAY_MOUSE
   interrupt(MOUSE_INTERRUPT,reg)
}

:CENVI_EXIT
