@echo off
REM *********************************************************
REM *** RunTime.bat - Execute commands at specified time. ***
REM *** ver.1                                             ***
REM *********************************************************

ECHO Command: %2 %3 %4 %5 %6 %7 %8 %9
CEnvi %0.bat %1
GOTO CENVI_EXIT

main(argc,argv)
{
   if ( argc < 2  ||  2 != sscanf(argv[1],"%d:%d",RunHour,RunMinute)
     || RunHour < 0  ||  23 < RunHour
     || RunMinute < 0  ||  59 < RunMinute ) {
      Instructions();
   } else {
      printf("Scheduled time: %02d:%02d:00\n",RunHour,RunMinute);
      // Loop here forever until RunHour:RunMinute comes along, then exit
      DisplayedSecond = -1; // force current time to print
      do {
         GetCurrentTime(CurrentHour,CurrentMinute,CurrentSecond);
         if ( CurrentSecond != DisplayedSecond )
            printf("\rCurrent Time:   %02d:%02d:%02d",
                   CurrentHour,CurrentMinute,DisplayedSecond=CurrentSecond);
      } while ( CurrentHour != RunHour  ||  CurrentMinute != RunMinute );
      printf("\n");
   }
}

GetCurrentTime(hour,minute,second)
{
   now = localtime(time());
   hour = now.tm_hour;
   minute = now.tm_min;
   second = now.tm_sec;
}

Instructions()
{
   printf("\n");
   printf("RunTime - Perform a command, with up to 7 parameters, at a specified time.\n");
   printf("\n");
   printf("SYNTAX: RunTime <hour>:<minute> [Command] [parm1] [parm2] [etc...]\n");
   printf("\n");
   printf("Where: hour   - hour of day (in 24-hour format) to run command; range 0 - 23\n");
   printf("       minute - minute of hour to run command: range 0 - 59\n");
   printf("\n");
   printf("Examples: RunTime 14:30 chkdsk c: /f   - run chkdsk at 2:30 PM\n");
   printf("          RunTime 0:00                 - pause computer until midnight\n");
   printf("\n");
}

:CENVI_EXIT
ECHO %2 %3 %4 %5 %6 %7 %8 %9
%2 %3 %4 %5 %6 %7 %8 %9
