@echo off
REM *****************************************************
REM *** ScrnSave.bat - Save screen contents to a file ***
REM *** ver.1                                         ***
REM *****************************************************

CEnvi %0.bat %1 %2
GOTO CENVI_EXIT

#include <Screen.lib>

ScrHeight = ScreenSize().row;
ScrWidth = ScreenSize().col;

main(argc,argv)
{
   if ( argc != 2  ||  !strcmpi(argv[1],"/?")  ||  !strcmpi(argv[1],"/help") )
      Instructions();
   else
      CaptureScreen(argv[1]);
}

Instructions()
{
   printf("\a\n")
   printf("ScrnSave - Save current ASCII screen to a file\n")
   printf("\n")
   printf("SYNTAX: ScrnSave <FileSpec>\n")
   printf("\n")
   printf("Where: FileSpec - Name of a file to capture screen to; if file then screen is\n")
   printf("                  appended to current file, else file is created\n")
   printf("\n")
   printf("\n")
   printf("Example: SCRNSAVE SCR.TXT\n")
   printf("\n")
}

CaptureScreen(FileSpec) // write screen to file
{
   if ( !(fp = fopen(FileSpec,"at")) ) {
      printf("\aUnable to open file \"%s\" for appending.\n",FileSpec);
      abort();
   }

   GetCursor(SaveCursorRow,SaveCursorCol); // save cursor pos
   for ( row = 0; row < ScrHeight; row++ ) {
      buf = ReadScreenRow(row);
      fprintf(fp,"%s\n",buf);
   }
   SetCursor(SaveCursorRow,SaveCursorCol); // restore cursor pos
   fclose(fp);
}

ReadScreenRow(row) // read this row to a buffer, turn 0 to blank and
{                  // shorten string to last non-whitespace character
   LastNonWhitespace = -1;
   for ( col = 0; col < ScrWidth; col++ ) {
      if ( !(c = ReadCharacter(row,col)) )
         c = ' ';
      else if ( !isspace(c) )
         LastNonWhitespace = col;
      buf[col] = c;
   }
   // terminate string beyond last nonwhitespace character
   buf[LastNonWhitespace+1] = 0;
   return(buf);
}

:CENVI_EXIT
