@echo off
REM ********************************************************************
REM *** SortLen.bat - CEnvi batch file to sort a file by line length ***
REM *** ver.1         with the shorter lines preceding longer lines. ***
REM ***               This is an example of the C standard library's ***
REM ***               qsort routine.                                 ***
REM ********************************************************************

REM ******************************************************************
REM *** Check that only one item was input, and that it was a file ***
REM *** name.  Else display usage screen.                          ***
REM ******************************************************************
   if "%1" == "" GOTO INSTRUCTIONS
   if not "%2" == "" GOTO INSTRUCTIONS
   if not exist %1 GOTO INSTRUCTIONS

REM **********************************************************************
REM *** Transfer control to the CEnvi code, which will input all lines ***
REM *** into an array, sort the array, and then print the sorted array ***
REM **********************************************************************
   cenvi %0.bat < %1
   GOTO CENVI_EXIT

/*************************************************************************
 *** Build array of all lines in the source file, which was redirected ***
 *** to standard input in the "cenvid %0.bat < %1" line above.         ***
 *************************************************************************/
   LineCount = 0;
   while ( NULL != (text[LineCount] = gets()) ) {
      LineCount++;
   }

   if ( 0 == LineCount ) {
      printf("No data to sort.\a\n");
      exit(EXIT_FAILURE);
   }

/******************************************
 *** Sort the data based on line length ***
 ******************************************/
   qsort(text,LineCount,"LengthCompare");

   LengthCompare(line1,line2) {
      // This routine is called by the qsort() library routine to compare
      // two lines.  Return < 0 if line1 is shorter than line 2, 0 if line1
      // is the same length as line 2, and > 0 if line1 is longer than line2
      return( strlen(line1) - strlen(line2) );
   }

/*******************************
 *** Display the sorted text ***
 *******************************/

   for ( i = 0; i < LineCount; i++ )
      puts(text[i])


return(EXIT_SUCCESS);
:CENVI_EXIT
REM *************************************
REM *** CEnvi is complete.  Clean up. ***
REM *************************************
GOTO FINISHED

:INSTRUCTIONS
ECHO .
ECHO SortLen.bat - Sort file by line length.
ECHO USAGE: SortLen.bat FileSpec
GOTO FINISHED


:FINISHED
