	SET TTHRU OFF		; Must be 1st line to suppress typethrough
	LEGEND "BBS Setup ver 1.0"
;****	TRACE ON		; Debugging
;
; ----- COM-AND BBS setup script
;	Commenced: 11/90 R.McG
; -----------------------------------------------------------------------
;	Purpose:
;	   This script, named BBSETUP.CMD, is executed to setup the BBS
;	script (version 1.1).  Setup 1) identifies the port and modem
;	control values, 2) identifies (and creates) the subdirs to be
;	used.  The script BBMAINT is used to update related files.
; -----------------------------------------------------------------------
;	NOTE: This script expects to find a file named BBSDAT on 1) the
;	current subdirectory, 2) The COM-AND= environment var specified
;	subdirectory, or 3) the subdirectory where THIS script resides.
;	If this file is found, it will be overwritten subsequently.  If
;	NOT found, BBSDAT will be created on the subdir where COM-AND=
;	points.  S29 is used to keep the file name (subroutine INIT).
; -----------------------------------------------------------------------
;
;	Establish a DWINDOW, and change the text display to window default.
;	.. Save the previous text display attribute, for restoration later.
;
	DWIND 1,2 22,78 	; Establish scrolling region
	N99 = "_TEXT"           ; Save original text attr
	SET TEXT "_DEFA"        ; Set text attr
	SET FLAG(9) OFF 	; Note if we did any saves
;
;	Perform tasks
;
	GOSUB Init		; Setup initial values
	GOSUB Main		; Paint main screen
;***	GOSUB ChkSave		; Check if save needed
	GOSUB ChkAll		; Check if subd's exist
;
;	Exit the script
;
Escape:
Exit:
	SET TEXT N99		; Reset text attr finally
	DWINDOW CLEAR		; Clear any scrolling region
	CLEAR			; Clear entire text window
	EXIT
; -----------------------------------------------------------------------
; ----- Subroutine: Init ->  Set initial values from BBSDAT
;	.. NOTE: S29 returns the file name to use for writes to BBSDAT
;
Init:
	S20 = "_PARM"(11:14)*","*"_PARM"(0:3) ; Port(4),speed(4)
	S21 = "ATE0Q0V1X1S0=2 S7=30 S9=10^M"  ; Standard MINIT for BBS
	S22 = "\BBS"            ; Set to our subdirectory
	S23 = "\BBS\FILES"      ; Set subdir for files
	S24 = "\BBS\MAIL"       ; Set subdir for mail
	S25 = "\BBS\BULLETIN"   ; Set subdir for bulletins
	S26 = ""                ; Doorway command
;
;	Replace above values from BBSDAT, if that script exists
;
	S29 = ""                ; Make value null
	IF ISSC "BBSDAT"        ; If file exists on dft subdir or COM-AND=
	   FCALL "BBSDAT"       ; .. execute it
	ELSE
	   S10 = "_SCRIPT"      ; Get current script fname
	   GOSUB Parse_Fname	; Extract drive:Subdir from name
	   S10 = S10*"\BBSDAT"  ; Make new name
	   IF ISSC S10		; Invoke it if its THERE
	      FCALL S10 	; Invoke it
	      S29 = S10 	; Save for later
	      ENDIF
	   ENDIF
	RETURN			; Done init
; -----------------------------------------------------------------------
;	Subroutine: Parse drive:subdirectory from file name
;
;	S10 passes fully name		S10 returns drive:subdirectory
;					S11 returns file name
;	N10,N11 are scratch values
; -----------------------------------------------------------------------
;
Parse_Fname:
	LENGTH S10 N10			; Find length of string
	FOR N11 = (N10-1),0,-1		; Scan backwards through string
	    IF STRCMP S10(N11:N11) ":" or STRCMP S10(N11:N11) "\" GOTO PAFN100
	    ENDFOR
	S11 = S10			; No drive or path
	S10 = ""                        ; Return null drive:path spec
	RETURN
;
;	Extract drive and path from name; N11 points to ":" or "\"
;
PAFN100:
	S11 = S10(N11+1:N10)		; Extract name portion
	IF STRCMP S10(N11:N11) "\" DEC N11
	S10 = S10(0:N11)		; Save ":", remove last "\"
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: Save -> Save values in BBSDAT
;	.. BBSDAT is placed in dft subdir; create file if need be
;
Save:
	IF NULL S29		; If INIT did not set a name
	;
	; Construct a file name on the appropriate directory
	;
	   S1 = ""              ; Initialize file name string
	   IF NOT ISFIL "BBSDAT"; If not on current subdir
	      ENVIRON S1 "COM-AND="; Look for COM-AND= environment var
	      IF FOUND		; If environment variable found
		 LENGTH S1 N0	; Get its length
		 N0 = N0-1	; Point to last char in string
		 IF not STRCMP S1(n0:n0) "\"
		    N0 = N0+1	; Point after last char
		    CONCAT S1(n0) "\"
		    ENDIF
		 ENDIF
	      ENDIF
	   S1 = S1&"BBSDAT"     ; Add the necessary file name
	ELSE S1 = S29		; Else use name set by INIT
	;
	; Open the file, write the file, and close it
	;
	FOPENO S1 TEXT		; Open the file name so constructed
	IF NOT SUCCESS
	   S0 = "Error opening BBSDAT file: "*S1
	   GOSUB Error		; Report
	   RETURN		; And we're done
	   ENDIF
       S29 = "_OFILE"           ; Save file name we opened
       ;
       ; Write values we have as of now
       ;
	WRITE "; --- BBS initialization !" ; Write initial comments
	WRITE ";     Updated "*"_DATE"*", at "*"_TIME"*"!"
	WRITE ";!"                         ; Write initial comments

	WRITE "S20=`""*S20&"`"!"    ; Write port and speed
	S0 = S21		; Copy control string
	PRESERVE S0		; Make it printable
	WRITE "S21=`""*S0&"`"!" ; Write modem control string
	WRITE "S22=`""*S22&"`"!"; Write BBS subdir
	WRITE "S23=`""*S23&"`"!"; Write BBS files subdir
	WRITE "S24=`""*S24&"`"!"; Write BBS mail subdir
	WRITE "S25=`""*S25&"`"!"; Write BBS bulletin subdir
	WRITE "S26=`""*S26&"`"!"; Write doorway command
	WRITE "FRETURN!^Z "     ; Write end of file
       ;
       ; Close the file and we're done
       ;
	SET FLAG(9) ON		; Note we did ONE save
	FCLOSEO 		; Close the file
	RETURN			; And we're done
; -----------------------------------------------------------------------
; ----- Error:	Open a window, display a message, and wait for keypress
;	S0 passes the error message
;
Error:
	WOPEN 10,10,12,70 (cont) Err_Esc
	ATSAY 10,12 (cont) " Error "
	ATSAY 11,12 (cont) S0(0:55); Max msg width 55 chars
	ATSAY 12,26 (cont) " Press any key to continue "
	;
	;    Wait a keypress
	;
	KEYGET S0		; Wait for any key
	WCLOSE
Err_Esc:
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: ChkSave ->	Save file?
;
ChkSave:
	IF FLAG(9) RETURN	; At least one save was performed
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " BBS Save "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
CHSA100:
	CLEAR			; Clear window
	LOCATE 2,2
	MESS " Do you wish to save the current values? (y/n) "
	MESS " "
	MESS "    Port and speed  is: "*S20
	S0 = S21		; Copy control string
	PRESERVE S0		; Make it printable
	MESS "    Modem control   is: "*S0
	MESS "    BBS main subdir is: "*S22
	MESS "    Files subdir    is: "*S23
	MESS "    Mail subdir     is: "*S24
	MESS "    Bulletin subdir is: "*S25
	MESS "    Doorway command is: "*S26
	MESS " "
	MESS " "
	MESS "Enter y or n (carriage return = n): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	IF NULL S0 GOTO CHSA200 ; If c/r, simply return
	SWITCH S0		; Act according to keyget
	  CASE "y"              ; Case insensitive
	       GOSUB Save
	       GOTO CHSA200
	       ENDCASE
	  CASE "n"              ; Case insensitive
	       GOTO CHSA200
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO CHSA100		; Repaint screen and ask again
;
;	Exit, closing the window
;
CHSA200:
	WCLOSE
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: ChkAll ->  Check for subdir creation req'd
;
ChkAll:
	WOPEN 10,10 12,70 (cont)
	ATSAY 10,12 (cont)   " BBS Subdirs "
	ATSAY 11,12 (cont) " Checking existance of subdirs... "
	PAUSE 1 		; Make it visible
;
;	Test for the existence of all subdirectories
;
	SET FLAG(0) ON
	FFIRST S22&"\*.*"       ; test for Main subd
	IF SUCCESS SET FLAG(0) OFF

	SET FLAG(1) ON
	FFIRST S23&"\*.*"       ; test for File subd
	IF SUCCESS SET FLAG(1) OFF

	SET FLAG(2) ON
	FFIRST S24&"\*.*"       ; test for Mail subd
	IF SUCCESS SET FLAG(2) OFF

	SET FLAG(3) ON
	FFIRST S25&"\*.*"       ; test for Main subd
	IF SUCCESS SET FLAG(3) OFF

	WCLOSE			; Close window we opened
	IF NOT (FLAG(0) or FLAG(1) or FLAG(2) or FLAG(3)) RETURN
;
;	Ask if we're to create subdirs
;
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " BBS Subdirs "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
;
;	Display subdirs that do not exist
;
CHAL100:
	CLEAR			; Clear window
	LOCATE 2,2

	IF FLAG(0) MESS S22&" does not exist"
	IF FLAG(1) MESS S23&" does not exist"
	IF FLAG(2) MESS S24&" does not exist"
	IF FLAG(3) MESS S25&" does not exist"
	MESS " "                ; Blank separator
	MESS " Do you wish to create the missing subdirs? (y/n) "
	MESS " "
	MESS " "
	MESS "Enter y or n (carriage return = n): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	IF NULL S0 GOTO CHAL200 ; If c/r, simply return
	SWITCH S0		; Act according to keyget
	  CASE "y"              ; Case insensitive
	       GOSUB CreateSd
	       GOTO CHAL200
	       ENDCASE
	  CASE "n"              ; Case insensitive
	       GOTO CHAL200
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO CHAL100		; Repaint screen and ask again
;
;	Exit, closing the window
;
CHAL200:
	WCLOSE
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: Main ->  main menu
;
Main:
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " BBS Setup "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
;
;	Paint the menu
;
Main100:
	CLEAR			; Clear window
	LOCATE 2,2
	MESS " 1) Identify subdirectories used by BBS;      Do this 1st!!"
	MESS " 2) Create BBS subdirectories and files;      Do this 2nd!!"
	MESS " 3) Identify modem values;                    ..."
	MESS " 4) Identify doorway command (if any).        Finally..."

	IF ISSCRIPT "BBMaint" MESS " 5) Invoke maintenance script"
	IF ISSCRIPT "BBS"     MESS " 6) Invoke the BBS"

	MESS " "
	MESS "    Port and speed  is: "*S20
	S0 = S21		; Copy control string
	PRESERVE S0		; Make it printable
	MESS "    Modem control   is: "*S0
	MESS "    BBS main subdir is: "*S22
	MESS "    Files subdir    is: "*S23
	MESS "    Mail subdir     is: "*S24
	MESS "    Bulletin subdir is: "*S25
	MESS "    Drop to DOS command is: "
	S0 = S26
	PRESERVE S0		; Make it printable
	MESS "    "*S0
	MESS " "
	MESS "BBSMAINT is used to update files once you have SETUP"
	MESS " "
	MESS " "
	MESS "Select item (carriage return = exit): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	SWITCH S0		; Act according to keyget
	  CASE "1"
	       GOSUB Subdirs
	       ENDCASE
	  CASE "2"
	       GOSUB ChkAll
	       ENDCASE
	  CASE "3"
	       GOSUB Modem
	       ENDCASE
	  CASE "4"
	       GOSUB DropDOS
	       ENDCASE
	  CASE "5"
	       IF ISSCRIPT "BBMaint"
		  WCLOSE		  ; Close open window
		  SET TEXT N99		  ; Reset text attr finally
		  DWINDOW CLEAR 	  ; Clear any scrolling region
		  CLEAR 		  ; Clear entire text window
		  EXECUTE "BBMaint"       ; Chain to it
		  ENDIF
	       ENDCASE
	  CASE "6"
	       IF ISSCRIPT "BBS"
		  WCLOSE		  ; Close open window
		  SET TEXT N99		  ; Reset text attr finally
		  DWINDOW CLEAR 	  ; Clear any scrolling region
		  CLEAR 		  ; Clear entire text window
		  EXECUTE "BBS"           ; Chain to it
		  ENDIF
	       ENDCASE
	  CASE "_NULL"          ; c/r alone is exit
	       WCLOSE		; Close window...
	       RETURN		; Leave Main routine
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO Main100		; Repaint screen and ask again
; -----------------------------------------------------------------------
; ----- Subroutine: Modem ->  modem values
;
Modem:
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " BBS Modem "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
;
;	Paint the menu
;
MODE100:
	CLEAR			; Clear window
	LOCATE 2,2
	MESS " 1) Identify modem port"
	MESS " 2) Identify modem speed"
	MESS " 3) Identify modem control string"
	MESS " "
	MESS "    Port and speed  is: "*S20
	S0 = S21		; Copy control string
	PRESERVE S0		; Make it printable
	MESS "    Modem control   is: "*S0
	MESS " "
	MESS " "
	MESS "Select item (carriage return = previous): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	SWITCH S0		; Act according to keyget
	  CASE "1"
	       GOSUB Modem_Port
	       ENDCASE
	  CASE "2"
	       GOSUB Modem_Speed
	       ENDCASE
	  CASE "3"
	       GOSUB Modem_Control
	       ENDCASE
	  CASE "_NULL"          ; c/r alone is exit
	       WCLOSE		; Close window...
	       RETURN		; Leave Main routine
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO MODE100		; Repaint screen and ask again
;
;	Escape during main
;
Main_Esc:
	S0 = ""                 ; Blank entry
	RETURN			; And execute it
;
; ----- Subroutine: Modem_port -> Set default modem port to use
;
Modem_Port:
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " BBS Port "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
	LOCATE 2,2

	MESS "The BBS is currently directed to run on the port: "*S20(0:3)
	MESS " "
	MESS "The BBS may use any port COM1 through COM4.  If you wish to use a port other"
	MESS "than the above, enter it here."
	MESS " "
	MESS "Port (carriage rtn alone accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 4		; Wait for a char
	IF NULL S0 GOTO MOPOEND ; Nothing entered
	IF NOT FIND S0(0:2) "com" GOTO MOPOERR
	IF S0(3) LT 1 or S0(3) GT 4 GOTO MOPOERR
;
;	Save the value
;
	S20(0:3) = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
MOPOEND:
	WCLOSE
	RETURN
;
;	Error in input string
;
MOPOERR:
	SOUND 100,100		; Bronx cheer
	GOTO Modem_Port 	; And try again
;
; ----- Subroutine: Modem_Speed -> Set default modem speed to use
;
Modem_Speed:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " BBS Speed "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
	LOCATE 2,2

	MESS "The BBS currently defaults to wait for call at: "*S20(5:8)*" baud"
	MESS " "
	MESS "The BBS may wait for a call at any rate you wish.  If you wish to use a "
	MESS "speed other than the above, enter it here. Legitimate speeds are: 300,"
	MESS "1200, 2400, 4800, 9600, and 19.2"
	MESS " "
	MESS "Speed (carriage rtn alone accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 4		; Wait for a char
	IF NULL S0 GOTO MOSPEND ; Nothing entered
	IF NOT FIND "300  300120024004800960019.2" S0(0:2) N0 GOTO MOSPERR
	IF 4*(N0/4) ne N0 GOTO MOSPERR
;
;	Save the value
;
	S20(5:8) = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
MOSPEND:
	WCLOSE
	RETURN
;
;	Error in input string
;
MOSPERR:
	SOUND 100,100		; Bronx cheer
	GOTO Modem_Speed	; And try again
;
; ----- Subroutine: Modem_Control -> Set the modem initialization string to use
;
Modem_Control:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " BBS Control "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
	LOCATE 2,2

	MESS "The BBS currently is set to initialize the modem with: "
	S0 = S21		; Fetch value
	PRESERVE S0		; Preserve for printing
	MESS S0 		; Display string
	MESS " "
	MESS "The initialization string must be correct for your modem.  Please refer to "
	MESS "the documentation that came with your modem.  The init string will probably"
	MESS "begin with modem attention (defa 'AT'), MUST enable autoanswer, and will"
	MESS "probably end with a carriage return.  "
	MESS " "
	MESS "Please note: Enter '^^A' through '^^Z' to indicate control chars, '^^^^ for'"
	MESS "a single caret, '!!' for a carriage return (or '^^M') and '!!!!' for a single"
	MESS "exclamation point."
	MESS " "
	MESS "Control string (carriage return accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 50		; Wait for a char
	IF NULL S0 GOTO MOCOEND ; Nothing entered
;
;	Save the value
;
	S21 = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
MOCOEND:
	WCLOSE
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: CreateSd -> Create subdirectories
;	.. Flags 0-3 control
;
CreateSd:
	IF FLAG(0)		; Main subd does not exist
	   S0 = S22		; Set-up passed parm
	   GOSUB Create 	; Attempt to create it
	   GOSUB NewUser	; Create needed file (if d.n.e)
	   ENDIF

	IF FLAG(1)		; File subd does not exist
	   S0 = S23		; Set-up passed parm
	   GOSUB Create 	; Attempt to create it
	   GOSUB NewFile	; Create needed file (if d.n.e)
	   ENDIF

	IF FLAG(2)		; Mail subd does not exist
	   S0 = S24		; Set-up passed parm
	   GOSUB Create 	; Attempt to create it
	   GOSUB NewMail	; Create needed file (if d.n.e)
	   ENDIF

	IF FLAG(3)		; Bulletin subd does not exist
	   S0 = S25		; Set-up passed parm
	   GOSUB Create 	; Attempt to create it
	   GOSUB NewBull	; Create needed file (if d.n.e)
	   ENDIF
	RETURN
;
; ----- Subroutine: CheckSd -> Create an subdirectories
;	.. Flags 0-3 control
;
CheckSd:
	FFIRST S0&"\*.*"        ; Test for existence of subdir
	IF SUCCESS RETURN	; Return if it exists
	GOSUB Create		; Attempt to create it
	RETURN
;
; ----- Subroutine: Create -> Create a subdirectory
;	.. S0 passes the subdirectory to create
;
Create:
	MDIR S0 		; Attempt to create subdir
	IF FAILURE		; Set-up passed parm
	   S0 = "Error creating: "*S0
	   GOSUB Error		; Report the error
	   SET SUCCESS OFF	; Return FAILED condition
	   ENDIF
	RETURN
;
; ----- Subroutine: NewUser -> Create a new BBS-User file
;
NewUser:
	IF ISFILE S22&"\BBS-User" RETURN
	FOPENO S22&"\BBS-User" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error creating: "*S22&"\BBS-User"
	   GOSUB Error		; Report
	   RETURN		; And we're done
	   ENDIF
	WRITE "!^Z"             ; Make it empty
	FCLOSEO 		; Done with it
	RETURN
;
; ----- Subroutine: NewFile -> Create a new BBS-File file
;
NewFile:
	IF ISFILE S23&"\BBS-File" RETURN
	FOPENO S23&"\BBS-File" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error creating: "*S23&"\BBS-File"
	   GOSUB Error		; Report
	   RETURN		; And we're done
	   ENDIF
	WRITE "!^Z"             ; Make it empty
	FCLOSEO 		; Done with it
	RETURN
;
; ----- Subroutine: NewMail -> Create a new BBS-Mail file
;
NewMail:
	IF ISFILE S24&"\BBS-Mail" RETURN
	FOPENO S24&"\BBS-Mail" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error creating: "*S24&"\BBS-Mail"
	   GOSUB Error		; Report
	   RETURN		; And we're done
	   ENDIF
	WRITE "!^Z"             ; Make it empty
	FCLOSEO 		; Done with it
	RETURN
;
; ----- Subroutine: NewBull -> Create a new BBS-Bull file
;
NewBull:
	IF ISFILE S25&"\BBS-Bull" RETURN
	FOPENO S25&"\BBS-Bull" TEXT
	IF NOT SUCCESS		; Open failed
	   S0 = "Error creating: "*S25&"\BBS-Bull"
	   GOSUB Error		; Report
	   RETURN		; And we're done
	   ENDIF
	WRITE "!^Z"             ; Make it empty
	FCLOSEO 		; Done with it
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: NewDat ->  Ask if a new BBSDAT file is to be placed?
;
NewDat:
	IF NULL S29 AND NOT ISSC "BBSDAT" RETURN
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " BBS Subdirs "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
NEDA100:
	CLEAR			; Clear window
	LOCATE 2,2
	MESS "Do you wish to place BBSDAT on the new BBS main subdirectory? (y/n) "
	MESS " "
	MESS " "
	IF NOT NULL S29
	   MESS "BBSDAT is currently: "*S29
	ELSE
	   S0 = "_SUBD"&"\BBSDAT"
	   IF NOT ISFILE "BBSDAT"
	      ENVIRON S0 "COM-AND="; Look for COM-AND= environment var
	      IF FOUND		; If environment variable found
		 LENGTH S0 N0	; Get its length
		 N0 = N0-1	; Point to last char in string
		 IF STRCMP S0(n0:n0) "\" S0(n0:n0) = ""
		 S0 = S0&"\BBSDAT"
		 ENDIF
	      ENDIF
	   IF ISFILE S0
	      MESS "BBSDAT is now: "*S0
	   ELSE
	      MESS "BBSDAT would be: "*S0
	      ENDIF
	   ENDIF
	MESS " "
	MESS " "
	MESS "Enter y or n (carriage return = y): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	IF NULL S0 GOTO NEDA200 ; If c/r, simply accept
	SWITCH S0		; Act according to keyget
	  CASE "y"              ; Case insensitive
	       GOTO NEDA200
	       ENDCASE
	  CASE "n"              ; Case insensitive
	       WCLOSE		; DO nothing
	       RETURN
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO NEDA100		; Repaint screen and ask again
;
;	Construct the other subdir names
;
NEDA200:
	S29 = S22&"\BBSDAT"
	WCLOSE
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: DftSds ->  Main subdir changed - default the others?
;
DftSds:
	WOPEN 0,0 23,79 (defa) Main_ESC
	ATSAY 0,2 (defa)   " BBS Subdirs "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
DFSD100:
	CLEAR			; Clear window
	LOCATE 2,2
	MESS " Do you wish to use the new main subdir as the root for others? (y/n) "
	MESS " "
	MESS "    BBS main subdir is now:   "*S22
	MESS "    Files subdir WOULD be:    "*S22&"\Files"
	MESS "    Mail subdir WOULD be:     "*S22&"\Mail"
	MESS "    Bulletin subdir WOULD be: "*S22&"\Bulletin"
	MESS " "
	MESS " "
	MESS "Enter y or n (carriage return = y): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	IF NULL S0 GOTO DFSD200 ; If c/r, simply accept
	SWITCH S0		; Act according to keyget
	  CASE "y"              ; Case insensitive
	       GOTO DFSD200
	       ENDCASE
	  CASE "n"              ; Case insensitive
	       WCLOSE		; DO nothing
	       RETURN
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO DFSD100		; Repaint screen and ask again
;
;	Construct the other subdir names
;
DFSD200:
	S23 = S22&"\Files"
	S24 = S22&"\Mail"
	S25 = S22&"\Bulletin"
	WCLOSE
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: Subdirs ->	Update subdirectories used by BBS
;
Subdirs:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " BBS Subdirs "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
SUBD100:
	CLEAR
	LOCATE 2,2
	MESS " 1) Identify BBS main subdir"
	MESS " 2) Identify BBS Files subdir"
	MESS " 3) Identify BBS Mail subdir"
	MESS " 4) Identify BBS Bulletins subdir"

	MESS " "
	MESS "    Main subdir     is: "*S22
	MESS "    Files subdir    is: "*S23
	MESS "    Mail subdir     is: "*S24
	MESS "    Bulletin subdir is: "*S25
	MESS " "
	MESS " "
	MESS "Select item (carriage return = previous): "
;
;	Wait for a keypress
;
	GET S0 1		; Wait for it
	SWITCH S0		; Act according to keyget
	  CASE "1"
	       GOSUB MainSd
	       ENDCASE
	  CASE "2"
	       GOSUB FileSd
	       ENDCASE
	  CASE "3"
	       GOSUB MailSd
	       ENDCASE
	  CASE "4"
	       GOSUB BullSd
	       ENDCASE
	  CASE "_NULL"          ; c/r alone is exit
	       WCLOSE		; Close window...
	       RETURN		; Leave Main routine
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO Subd100		; Repaint screen and ask again
;
; ----- Subroutine: MainSd -> Set the main subdirectory
;
MainSd:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " BBS Main Subdir "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
	LOCATE 2,2

	MESS "The BBS main subdirectory is: "
	MESS S22
	MESS " "
	MESS "The main subdirectory must exist (it will be created if need be), and will "
	MESS "contain at least one file (BBS-User).  The user ID file (BBS-User) residing"
	MESS "there may be updated with from the main menu of this script."
	MESS " "
	MESS "BBS Main subdir (carriage return accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 50		; Wait for a char
	IF NULL S0 GOTO MASDEND ; Nothing entered
	GOSUB CheckSd		; Test for create needed
	IF FAILED GOTO MASDEND	; Skip if create failed
;
;	Save the value
;
	S22 = S0		; Set new value
	GOSUB NewUser		; Create needed file (if d.n.e)
	GOSUB DftSds		; Ask if we're to default the other subdirs
	GOSUB NewDat		; Ask if a new BBSDAT to be used
	GOSUB Save		; Save the new value
;
;	End of window
;
MASDEND:
	WCLOSE
	RETURN
;
; ----- Subroutine: FileSd -> Set the file subdirectory
;
FileSd:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " BBS File Subdir "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
	LOCATE 2,2

	MESS "The BBS file subdirectory is: "
	MESS S23
	MESS " "
	MESS "The main subdirectory must exist (it will be created if need be), and will "
	MESS "contain at least one file (BBS-File).  The file list (BBS-File) residing"
	MESS "there may be updated with from the main menu of this script."
	MESS " "
	MESS "BBS File subdir (carriage return accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 50		; Wait for a char
	IF NULL S0 GOTO FISDEND ; Nothing entered
	GOSUB CheckSd		; Test for create needed
	IF FAILED GOTO FISDEND	; Skip if create failed
	GOSUB NewFile		; Create needed file (if d.n.e)
;
;	Save the value
;
	S23 = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
FISDEND:
	WCLOSE
	RETURN
;
; ----- Subroutine: MailSd -> Set the mail subdirectory
;
MailSd:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " BBS Mail Subdir "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
	LOCATE 2,2

	MESS "The BBS Mail subdirectory is: "
	MESS S24
	MESS " "
	MESS "The Mail subdirectory must exist (it will be created if need be), and will "
	MESS "contain at least one file (BBS-Mail).  The user ID file (BBS-Mail) residing"
	MESS "there may be updated with from the main menu of this script."
	MESS " "
	MESS "BBS Mail subdir (carriage return accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 50		; Wait for a char
	IF NULL S0 GOTO MLSDEND ; Nothing entered
	GOSUB CheckSd		; Test for create needed
	IF FAILED GOTO MLSDEND	; Skip if create failed
	GOSUB NewMail		; Create needed file (if d.n.e)
;
;	Save the value
;
	S24 = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
MLSDEND:
	WCLOSE
	RETURN
;
; ----- Subroutine: BullSd -> Set the bulletin subdirectory
;
BullSd:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " BBS Bulletin Subdir "
	ATSAY 23,25 (defa) " Press ESC to cancel BBSETUP "
	LOCATE 2,2

	MESS "The BBS bulletin subdirectory is: "
	MESS S25
	MESS " "
	MESS "The Bulletin subdirectory must exist (it will be created if need be), and will "
	MESS "contain at least one file (BBS-Bull).  The user ID file (BBS-Bull) residing"
	MESS "there may be updated with from the main menu of this script."
	MESS " "
	MESS "BBS Bulletin subdir (carriage return accepts): "
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 50		; Wait for a char
	IF NULL S0 GOTO BUSDEND ; Nothing entered
	GOSUB CheckSd		; Test for create needed
	IF FAILED GOTO BUSDEND	; Skip if create failed
	GOSUB NewBull		; Create needed file (if d.n.e)
;
;	Save the value
;
	S25 = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
BUSDEND:
	WCLOSE
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: DropDOS -> Define the DROP-to-DOS mode command
;
DropDOS:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " HOST DropDOS command "
	ATSAY 23,25 (defa) " Press ESC to cancel HOSETUP "
	LOCATE 2,2

	MESS "The Drop-to-DOS command currently is: "
	S0 = S26
	PRESERVE S0		; Make it printable
	MESS S0
	MESS " "
	MESS "The Drop-To-DOS command must execute a function such as DOORWAY for a"
	MESS "drop into DOS.  This feature is not available if the command here is"
	MESS "set null.  If this feature IS not null, the command here will be built"
	MESS "into a temporary batch file and executed on request (DOS passworded)."
	MESS " "
	MESS "HOST Drop-to-DOS command (you MUST enter new value): ^M^J"
;
;	Wait for entry, and interpret
;
	S0 = "    "             ; Default value
	GET S0 70		; Wait for entry
;
;	Save the value
;
	S26 = S0		; Set new value
	GOSUB Save		; Save the new value
;
;	End of window
;
DRDOEND:
	WCLOSE
	RETURN
