; ----- INDIR: Load the dialing directory from an ASCII file
; ----------------------------------------------------------------
;	Note: This script writes to the filele DIALING.TXT.  The file
;	is given AN ASCII file format.	Records have the structure:
;
;  Col: 0		  38		    57		      61
;	+-----+-/ /-+-----+-----+-/ /-+-----+-----+-/ /-+-----+-//
;	!  Entry name	  !  Phone number   ! Speed	      !
;	+-----+-/ /-+-----+-----+-/ /-+-----+-----+-/ /-+-----+-//
;		 !		   !		     +--------- 4 chars
;		 !		   +--------------------------- 14 chars
;		 +--------------------------------------------- 24 chars
;
;  Col:       61    62	  63	64    65    66	  67	68    69    70
;	      +-----+-----+-----+-----+-----+-----+-----+-----+-----+-//
;	      !     !  P  !	!  D  !     !  S  !	!  E  !     !
;	      +-----+-----+-----+-----+-----+-----+-----+-----+-----+-//
;		       !	   !	       !	   +--- Echo Y/N
;		       !	   !	       +--------------- Stop 1/2
;		       !	   +--------------------------- Data 7/8
;		       +--------------------------------------- Parity E/N/O
;
;  Col:       70		78
;	      +-----+-/ /-+-----+
;	      ! Script file	!
;	      +-----+-/ /-+-----+
;		       +--------------------------------------- 8 chars
;
;	2/93: R.McG PRESERVE directory entry name...
; ----------------------------------------------------------------
;
;	Open the output file, purgins if it exists
;
	FOPENO "DIALING.TXT" TEXT
	LEGEND "OutDir: Dialing directory output"
;
;	Write 100 lines of output
;
	FOR N0 = 1,100
	    DIRECTO S0 N0	; Entry name
	    PRESERVE S0 	; Retain !s, etc
	    IF NOT STRCMP S0(0:5) "......" ; Skip empty entries
	       LEGEND "OutDir: Entry # "*N0*" output"
	       DNUMBER S1 N0	; Entry number
	       DPARMS  S2 N0	; Entry parameters
	       DSCRIPT S3 N0	; Script name when used
	       UPPER S3 	; Make upper case
	       S0(38:79) = S1	; Put 'em together
	       S0(57:79) = S2
	       S0(70:79) = S3
	       WRITE S0 79	; Write to disc
	       WRITE "!" 1
	       ENDIF
	    ENDFOR
;
;	And close the output file
;
	FCLOSEO
