S0 = 10				; Dialing directory number we'll use
; ----- SprintNet: Connect to SprintNet
; ----------------------------------------------------------------
;	Note: This script may be used by itself (to put you at Sprint-
;	Net's "@ " prompt, or may be FCALLed by another script.	 This
;	script is written to be FCALLed, executed directly (F2) or
;	attached to a dialing directory entry (for manual execution).
; ----------------------------------------------------------------
;	Note: Change the value above to reflect the dialing directory
;	entry number you have prepared.	 The default is "10".
; ----------------------------------------------------------------
;	S0 is modified by this script.
;	SUCCESS/FAILED is returned by this script to an FCALLer
; ----------------------------------------------------------------
;	Make connection to SprintNet.  The dialing directory (or current
;	.. setting define parity and speed).
;
	LEGEND " Dialing SprintNet... "
	IF NOT LINKED		; If script not invoked from Alt-D
	   DIAL S0		; Call dial dir entry number 10 (SprintNet)
	   IF FAILED GOTO Exit	; IF esc out, terminate script
	   ENDIF		; End if not linked
;
;	Make connection according to the dialing directory's parity/speed
;	.. i.e: parity and speed make a difference in how we connect
;
	PAUSE 5				; Wait for the modem to settle
	COMPARMS S0			; Get current settings
	IF STRCMP "N" S0(5:5)		; If no parity
	   IF STRCMP "2400" S0(0:3)	; If 2400 baud connect Send @D<cr>
	      TRANS "@"			;    Send @D<cr> slowly
	      PAUSE 1			;    Wait a moment
	      TRANS "D"			;    Set to 8N1
	      PAUSE 1			;    Wait a moment
	      TRANS "!"			;    Set to 8N1
	   ELSE				; ELSE 300/1200 (send <cr>D<cr>)
	      TRANSMIT "!D"		;    Transmit Carriage return <CR> D
	      PAUSE 1			;    Wait 1 sec
	      TRANSMIT "!"		;    .. (8 bit identifier)
	      ENDIF
	ELSE				; ELSE even or odd parity
	   IF STRCMP "2400" S0(0:3)	; If 2400 baud connect Send @D<cr>
	      TRANS "@"			;    Send @D<cr> slowly
	      PAUSE 1			;    Wait a moment
	      TRANS "D"			;    Set to 8N1
	      PAUSE 1			;    Wait a moment
	      TRANS "!"			;    Set to 8N1
	   ELSE				; ELSE 300/1200 (send <cr><cr>)
	      TRANSMIT "!"		;    Transmit Carriage return <CR>
	      PAUSE 2			;    Wait 1 sec
	      TRANSMIT "!"		;    Transmit Carriage return <CR>
	      ENDIF
	   ENDIF
;
;	Send terminal identification
;
	WAITFOR "TERMINAL="	; Wait for the prompt
	TRANSMIT "D1!"		; Set terminal type
	WAITFOR "@"		; Wait for next prompt
;
;	Set a few more values
;
	SET BSUPPRESS OFF	; Turn off blank line suppression
	SET MASK ON		; Turn on high bit mask
	SET CDISPLAY ON		; Display ctl chars
	SET SUCCESS ON		; Report success
;
;	Exit - this script may be called
;
Exit:
	IF FCALLED FRETURN	; Return to caller if called
	ALARM			; Sound alarm - we're done
