#define DLL_MAIN    

#include "re_comm.h"
#include <stdlib.h>

#define INICOM 	1
#define SETCOM 	2
#define SETQUE 	3
#define RECCOM 	4
#define SNDCOM 	5
#define CTX		6
#define TRMCOM	7
#define STACOM	8
#define CEXTFCN 9
#define CFLUSH	10
#define CEVT 	11
#define CEVTGET 12
#define CSETBRK 13
#define CCLRBRK 14
#define GETDCB  15
#define CWSTRING 16
#define CRSTRING 17
#define ENABLENOTI 18

DCB dcb;
HINSTANCE hUser;



int event = 0;
int huge * lpevent;

int sendData();
char debug[60];
BOOL REMOTE_RUNNING = FALSE;

HWND hNoti = NULL;

HWND 	(FAR PASCAL * lpFindWindow)(LPSTR, LPSTR);
int  	(FAR PASCAL * lpMessageBox)(HWND, LPSTR, LPSTR, UINT);
void 	(FAR PASCAL * lpPostQuitMessage)(int);
LRESULT (FAR PASCAL * lpSendMessage)(HWND, UINT, WPARAM, LPARAM);	
long    (FAR PASCAL * lpGetTickCount)();

LPSTR numtoA(int x)
{
	static char zahl[] = "0123456789";
	static char num[20];
	int y;
	
	_fmemcpy(num, "                 \n\n\0", 20);
	y = 10;
	
	while(x > 0)
	{
		num[y--] = 	zahl[x % 10];
		x /= 10;
	}   
	return(num);  
}	

int far pascal inicom(DCB far * lpdcb)
{
	WORD (far pascal * lpfn)(DCB far * lpdcb);
	
	if(lpdcb->Id == REMOTE_COM)
	{	
		comData.fnc = INICOM;
		
		_fmemcpy(&comData.a.dcb, lpdcb, sizeof(comData.a.dcb));
		
		if(sendData() == FALSE) return IE_HARDWARE;
		
		_fmemcpy(lpdcb, &comData.a.dcb, sizeof(comData.a.dcb));
		
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(1, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(lpdcb);
		}
	}                   
	return IE_HARDWARE;	
}
int far pascal setcom(DCB far * lpdcb)
{	
	WORD (far pascal * lpfn)(DCB far * lpdcb);
	
	if(lpdcb->Id == REMOTE_COM)
	{	
		comData.fnc = SETCOM;
		
		_fmemcpy(&comData.a.dcb, lpdcb, sizeof(comData.a.dcb));
		
		if(sendData() == FALSE) return IE_HARDWARE;
		
		_fmemcpy(lpdcb, &comData.a.dcb, sizeof(comData.a.dcb));
		
		return(LOWORD(comData.rc));
	}
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(2, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(lpdcb);
		}
	}
	return IE_HARDWARE;	
}
int far pascal setque(int cid, QDB FAR * lpqdb )
{
	int (far pascal * lpfn)(int cid, QDB FAR * lpqdb );
	
	if(cid == REMOTE_COM)
	{	
		comData.fnc = SETQUE;
		
		_fmemcpy(&comData.a.qdb, lpqdb, sizeof(comData.a.qdb));
		
		if(sendData() == FALSE) return IE_BADID;
		
		_fmemcpy(lpqdb, &comData.a.qdb, sizeof(comData.a.qdb));
		
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(3, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid, lpqdb );
		}
	}
	return IE_BADID;	
}
int far pascal reccom(int cid)
{
	int (far pascal * lpfn)(int cid);
	
	if(cid == REMOTE_COM)
	{	
		comData.fnc = RECCOM;
		
		if(sendData() == FALSE) return -1;
		
		return (comData.a.x);
	}
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(4, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid);
		}
	}
	return -1;	
}
int far pascal sndcom(int cid, int ch)
{
	WORD (far pascal * lpfn)(int cid, int ch);
	
	if(cid == REMOTE_COM)
	{	
		comData.fnc = SNDCOM;
		comData.a.x = ch;
		if(sendData() == FALSE) return -1;
		
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(5, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid, ch);
		}
	}
	return -1;	
}
WORD far pascal ctx(int cid, int ch)
{	WORD (far pascal * lpfn)(int cid, int ch);

	if(cid == REMOTE_COM)
	{	
		comData.fnc = CTX;
		comData.a.x = ch;
		if(sendData() == FALSE) return 0x8000;
		
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(6, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid, ch);
		}
	}
	return 0x8000;	
}

int far pascal trmcom(int cid)
{
	int (far pascal * lpfn)(int cid);
	int rc;
	
	if(cid == REMOTE_COM)
	{	
		comData.fnc = TRMCOM;
		
		if(sendData() == FALSE) return 0x8000;
		
		return (LOWORD(comData.rc));
	}
	
	rc = 0x8000;
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(7, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			rc = (*lpfn)(cid);
		}
	}
	return rc;	
	
}
WORD far pascal stacom(int cid, COMSTAT FAR * cs)
{
	WORD (far pascal * lpfn)(int cid, COMSTAT FAR * cs);
	
	if(cid == REMOTE_COM)
	{	
		comData.fnc = STACOM;
		              
		if(cs != (COMSTAT FAR *)NULL)
		{		              
			_fmemcpy(&comData.a.cs, cs, sizeof(comData.a.cs));
		}
		
		if(sendData() == FALSE) 
		{
			return CE_FRAME | CE_MODE | CE_BREAK;
		}
		
		if(cs != (COMSTAT FAR *)NULL)
		{		              
			_fmemcpy(cs, &comData.a.cs, sizeof(comData.a.cs));
		}
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{   
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(8, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{   
			return (*lpfn)(cid, cs);
		}
	}   
	return CE_IOE;	
	
}
LONG far pascal cextfcn(int cid, int fcn)
{	LONG (far pascal * lpfn)(int cid, int fcn);
	
	int maxcom;                	
	
	comData.fnc = CEXTFCN;
	
	lpfn = NULL;
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(9, 0));
    }
	switch(fcn)
	{
		case GETBASEIRQ:
			if(cid == REMOTE_COM) 
			{	
				return 0L;
			}
			break;
		case GETMAXCOM:
				
				if((FARPROC)lpfn != (FARPROC)NULL)
				{
					maxcom = LOWORD((*lpfn)(cid, fcn));
					return(max(maxcom, REMOTE_COM));
				}
				break; 
	}           
	lpfn = NULL;
	
	if(cid == REMOTE_COM)
	{	                       
		comData.a.x = fcn;
		if(sendData() == FALSE) return -1;
		return(comData.rc);
	}
	if((FARPROC)lpfn != (FARPROC)NULL)
	{
		return (*lpfn)(cid, fcn);
	}
	return -1;	
}
WORD far pascal cflush(int cid, int q)
{	WORD (far pascal * lpfn)(int cid, int q);

	if(cid == REMOTE_COM)
	{	
		comData.fnc = CFLUSH;
		comData.a.x = q;
		if(sendData() == FALSE) return 0x8000;
		
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(10, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid, q);
		}
	}
	return 0x8000;	
}
LPWORD far pascal cevt(int cid, int evtmask)
{	LPWORD (far pascal * lpfn)(int cid, int evtmask);
	        
	event = 0;

	if(cid == REMOTE_COM)
	{	
		comData.fnc = CEVT;
		comData.a.x = evtmask;
		sendData();
		
		if(comData.rc == 0) 
		{   
			// return 0;     
		}
		return (&event);
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(11, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{          
			return (*lpfn)(cid, evtmask);
		}
	}
	return (&event);
}
WORD  far pascal cevtGet(int cid, int evtmask)
{	WORD (far pascal * lpfn)(int cid, int evtmask);
	
	
	if(cid == REMOTE_COM)
	{	
		comData.fnc = CEVTGET;
		comData.a.x = evtmask;
		if(sendData() == FALSE) 
		{
			return EV_ERR;
		}
		
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(12, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid, evtmask);
		}
	}
	return EV_ERR;	
}
int far pascal csetbrk(int cid)
{	int (far pascal * lpfn)(int cid);
	
	if(cid == REMOTE_COM)
	{	
		comData.fnc = CSETBRK;
		if(sendData() == FALSE) return -1;
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(12+1, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid);
		}
	}
	return -1;	
}
int far pascal cclrbrk(int cid)
{	int (far pascal * lpfn)(int cid);
	
	if(cid == REMOTE_COM)
	{	
		comData.fnc = CCLRBRK;
		if(sendData() == FALSE) return -1;
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(14, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid);
		}
	}
	return -1;	
}
DCB far * far pascal getdcb(int cid)
{	DCB far * (far pascal * lpfn)(int cid);
	
	if(cid == REMOTE_COM)
	{	
		comData.fnc = GETDCB;
		if(sendData() == FALSE) return NULL;
		
		_fmemcpy(&dcb, &comData.a.dcb, sizeof(dcb));
		
		return(&dcb);
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(15, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid);
		}
	}
	return NULL;	
}   
int far pascal CommWriteString(int cid, LPSTR pbbuf, int size)
{	int (far pascal * lpfn)(int cid, LPSTR pbbuf, int size);
	
	int x;        
	
	if(cid == REMOTE_COM)
	{	
		x = 0;
		
		while(x < size)
		{	
			comData.fnc = CWSTRING;
			comData.len = min(sizeof(comData.a.txt), size -x);
			_fmemcpy(comData.a.txt, pbbuf+x, comData.len);
			
			x += comData.len;
			
			if(sendData() == FALSE) return -1;
		}
		return(x);
	}
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(19, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid, pbbuf, size);
		}
	}
	return NULL;	
}   
int far pascal ReadCommString(int cid, LPSTR pbbuf, int size)
{	int (far pascal * lpfn)(int cid, LPSTR pbbuf, int size);
	int x;                   
	
	if(cid == REMOTE_COM)
	{	
		x = 0;
		
		while(x < size)
		{	
			comData.fnc = CRSTRING;
			comData.len = min(sizeof(comData.a.txt), size -x);
			
			if(sendData() == FALSE) return -1;
			
			if(comData.rc == 0) break; // no more Data
			
			_fmemcpy(pbbuf+x, comData.a.txt, comData.len);
			
			x += comData.len;
		}
		return(x);
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(20, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid, pbbuf, size);
		}
	}
	return NULL;	
}   
int far pascal EnableNotification(int cid, HWND hwnd, WORD wInTrigger, WORD wOutTrigger)
{	int (far pascal * lpfn)(int cid, HWND hwnd, WORD wInTrigger, WORD wOutTrigger);

	hNoti = hwnd;
	
	if(cid == REMOTE_COM)
	{
		comData.fnc = ENABLENOTI;
		comData.a.noti.hwnd = hwnd;
		comData.a.noti.inTrig = wInTrigger;
		comData.a.noti.outTrig = wOutTrigger;
		
		if(sendData() == FALSE) return NULL;
		
		return(LOWORD(comData.rc));
	}
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(100, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			return (*lpfn)(cid, hwnd, wInTrigger, wOutTrigger);
		}
	}
	return NULL;	
}   
void far pascal ReactivateOpenCommPorts(void)
{
	void (far pascal * lpfn)(void);
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(18, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			(*lpfn)();
		}
	}
}
void far pascal SuspendOpenCommPorts(void)
{
	void (far pascal * lpfn)(void);
	
	if(hCm > HINSTANCE_ERROR)
	{
		(FARPROC)lpfn = (FARPROC)GetProcAddress(hCm, (LPSTR)MAKELONG(17, 0));
		if((FARPROC)lpfn != (FARPROC)NULL)
		{
			(*lpfn)();
		}
	}
}   

void getFunctions()
{
	static BOOL INIT = FALSE;
	
	if(INIT == FALSE)
	{                  
		hUser = LoadLibrary("USER.EXE");
		
		(FARPROC)lpFindWindow = (FARPROC)GetProcAddress(hUser, "FINDWINDOW");
		(FARPROC)lpMessageBox = (FARPROC)GetProcAddress(hUser, "MESSAGEBOX");
		(FARPROC)lpPostQuitMessage = (FARPROC)GetProcAddress(hUser, "PostQuitMessage");
		(FARPROC)lpSendMessage = (FARPROC)GetProcAddress(hUser, "SENDMESSAGE");	
		(FARPROC)lpGetTickCount   = (FARPROC)GetProcAddress(hUser, "GETTICKCOUNT");	
		FreeLibrary(hUser);
		INIT = TRUE;
	}	
}
WaitForReCommNet()
{
	long x;
	
	x = lpGetTickCount();
	
	while((x - lpGetTickCount()) < 3600000) // 3 minuten
	{
		if(REMOTE_RUNNING == TRUE) return TRUE;
		Yield();
	}   
	return FALSE;
}       
//---------------------------------------------------------------------------------------
sendData()
{	
	static int errcnt = 0;
	static HINSTANCE hNet = NULL;
	static int (FAR PASCAL * lpInitRecomNet)();
	static int (FAR PASCAL * lpReCommCmd)     (struct recComData far * lpComData);
	          
	getFunctions();               
	
	if(REMOTE_RUNNING == FALSE)
	{	            
		
		if(comData.fnc == TRMCOM)
		{	comData.rc = 0;
			return TRUE;
		}
		
		if( (comData.fnc == INICOM)
		||  (comData.fnc == SETQUE))
		{
			hNet = LoadLibrary("recomnet.dll");
			
			if(hNet <= HINSTANCE_ERROR)
			{
				// OutputDebugString("COMM.DRV: could'nt load recomnet.dll");
				// OutputDebugString(numtoA(hNet));				
				FatalAppExit(0, "RECOMM.DLL (COMM.DRV) RECOMNET.DLL nicht gefunden");
			    return FALSE;
			}
			errcnt = 0;
			
			(FARPROC)lpReCommCmd = (FARPROC)GetProcAddress(hNet, "RECOMMCMD");		
		
			if( (FARPROC)lpReCommCmd == (FARPROC)NULL) 
			{
				// OutputDebugString("COMM.DRV: could'nt  find INITRECOMNET/RECOMMCMD\n");
				FatalAppExit(0, "RECOMM.DLL (COMM.DRV) Falsche RECOMNET.DLL");
				FreeLibrary(hNet);
				hNet = NULL;
				return FALSE;
			}
		}else
		{
			return FALSE;
		}
		
	}   
	if( (comData.fnc == INICOM)
	||  (comData.fnc == SETQUE))
	{
		errcnt = 0;
	}	
	if(lpReCommCmd(&comData) == FALSE)
	{
		event = EV_ERR;
		if(hNoti != NULL) 
		{	lpSendMessage(hNoti, WM_CLOSE, 0, 0L);
		}
		return FALSE;
	}           
	event = comData.evmask;
	
	if( (comData.fnc == TRMCOM)
	&&  (hNet > HINSTANCE_ERROR))
	{	
		FreeLibrary(hNet);
		hNet = NULL;
		REMOTE_RUNNING = FALSE;    
	}
	return TRUE;
}       

#ifdef CLIENT_EXE
		
sendData()
{	
	HWND hCl;
	static int errcnt = 0;
	          
	getFunctions();               
	
	hCl = lpFindWindow("RE_COM_CTRL", NULL);
	
	if(hCl == NULL)
	{	            
		REMOTE_RUNNING = FALSE;    
		
		if(comData.fnc == TRMCOM)
		{	comData.rc = 0;
			return TRUE;
		}
		
		if( (comData.fnc == INICOM)
		||  (comData.fnc == SETQUE))
		{
			WinExec("MODEMCL.EXE", SW_SHOWMINIMIZED);
			
			errcnt = 0;
		
			if(WaitForModemCL() == FALSE) 
			{
				if(hNoti != NULL) lpSendMessage(hNoti, WM_CLOSE, 0, 0L);
				return FALSE;
			}
			hCl = lpFindWindow("RE_COM_CTRL", NULL);
		
			if(hCl == NULL)
			{   if(hNoti != NULL) lpSendMessage(hNoti, WM_CLOSE, 0, 0L);
				return FALSE;
			}				
		}else
		{
			return FALSE;
		}
	}
	if(lpSendMessage(hCl, WM_COMMAND, 666, (LPARAM)(LPSTR)&comData) == FALSE)
	{
		event = EV_ERR;
		if(hNoti != NULL) 
		{	lpSendMessage(hNoti, WM_CLOSE, 0, 0L);
		}else
		{                 
			if(errcnt++ > 100)
			{   
				lpPostQuitMessage(2); // jetzt reichts aber !
				errcnt = 0;
			}
		}			
		return FALSE;
	}           
	event = comData.evmask;
	
	return TRUE;
}
#endif

void FAR PASCAL setRemoteRunning(int evmask)
{
	REMOTE_RUNNING = TRUE;
	event = evmask; // Set by Client Timer
}
