//      Robot demonstration program in
//      Portable C++

//      The // at the begining of the line indicates that this is a comment
//      line. Everything else on the line is ignored by the compiler.

//      Create the required objects

//      To create an object in Portable C++ we specify the class
//      of the object followed by a name we wish to use for the
//      instance we are creating. Each instance must have a
//      unique name with which to identify it. The statement
//      is ended with a semicolin.

keyboard kbd;
screen   scr;
circle   acircle;
line     vline;
line     hline;
console  aconsole;




//      Define the robot class

//      Portable C++ defines classes with the class statement.
//      The syntax of the class statement is the word class followed
//      the name of the class in this case robot. The body of the class
//      statement is enclosed in braces. { }

class robot
        {

//      The keyword public is used to denote methods that are
//      accessable by external objects. The default is private.

public:










//      Each of the methods are defined. The word void at the beginning
//      indicates that the method does not return a value.
//      The method is named followed by brackets () containing
//      the parameter names and types. The names are optional.
//      The word void used here indicates that the method takes no
//      parameters. The statement is ended with a semicolin.

        void    forward(void);
        void    backward(void);
        void    up(void);
        void    down(void);

//      A special method called a constructor is defined by giving it
//      the same name as the class. This method is run automatically
//      whenever an object or instance of the class is created.
//      A constructor does not return a value.

                robot(void);

//      The class statement ends with a closing brace and semicolon.

        };


//      Robot constructor

//      A method is created by entering its name followed by the
//      parameter list in brackets. Since many classes could have
//      a method by the same name it is necessary to specify the
//      classname first followed by 2 colons. :: The body of the
//      method follows enclosed in braces. { }

robot::robot(void)
{

//      Initialize the vertical line for the cross

//      Most methods involve sending messages to other objects.
//      A message is sent to an object by entering its name followed
//      by a dot then the name of the method and its parameters in
//      brackets.

vline.setx1(20);
vline.sety1(460);
vline.setx2(20);
vline.sety2(480);


//      Initialize the horizontal line for the cross

hline.setx1(10);
hline.sety1(470);
hline.setx2(30);
hline.sety2(470);

//      Draw the cross

//      If a method has no parameters,
//      the brackets are still required.

hline.draw();
vline.draw();

//      Initialize and draw the circle for the button

//      We are modifying the default attributes of the circle
//      as defined in the constructor. Then we draw it.

acircle.setattr(0x0c);
acircle.draw();


//      The method is ended with a closing brace.

}


//      Robot forward method

//      Since methods could return a value, it is necessary to specify
//      the type of the returned value. This is placed before the name of
//      the class. Since a constructor cannot return a value, the return
//      type is not required for a constructor.

void robot::forward(void)
{

//      Set the cross colour to black and draw it

vline.setattr(0x00);
hline.setattr(0x00);
vline.draw();
hline.draw();



//      Move the cross to a new location

vline.movex(10);
hline.movex(10);

//      Set the cross colour to white and draw it

vline.setattr(0x0f);
hline.setattr(0x0f);
vline.draw();
hline.draw();

//      Redraw the circle
//      Print a status message
//      Wait a bit to slow the display down

acircle.draw();
aconsole.write(" forward  ");
aconsole.mwait(50);
}




//      Robot backward method

void robot::backward(void)
{

//      Set the cross colour to black and draw it

vline.setattr(0x00);
hline.setattr(0x00);
vline.draw();
hline.draw();

//      Move the cross to a new location

vline.movex(-10);
hline.movex(-10);

//      Set the cross colour to white and draw it

vline.setattr(0x0f);
hline.setattr(0x0f);
vline.draw();
hline.draw();

//      Redraw the circle
//      Print a status message
//      Wait a bit to slow the display down

acircle.draw();
aconsole.write(" backward ");
aconsole.mwait(80);
}

//      Robot up method

void robot::up(void)
{

//      Set the cross colour to black and draw it

vline.setattr(0x00);
hline.setattr(0x00);
vline.draw();
hline.draw();




//      Move the cross to a new location

vline.movey(-10);
hline.movey(-10);

//      Set the cross colour to white and draw it

vline.setattr(0x0f);
hline.setattr(0x0f);
vline.draw();
hline.draw();

//      Redraw the circle
//      Print a status message
//      Wait a bit to slow the display down

acircle.draw();
aconsole.write(" up       ");
aconsole.mwait(25);
}




//      Robot down method

void robot::down(void)
{

//      Set the cross colour to black and draw it

vline.setattr(0x00);
hline.setattr(0x00);
vline.draw();
hline.draw();

//      Move the cross to a new location

vline.movey(10);
hline.movey(10);

//      Set the cross colour to white and draw it

vline.setattr(0x0f);
hline.setattr(0x0f);
vline.draw();
hline.draw();

//      Redraw the circle
//      Print a status message
//      Wait a bit to slow the display down

acircle.draw();
aconsole.write(" down     ");
aconsole.mwait(50);
}

//      Create the robot

//      The robot object must be created after the constructor
//      is defined to ensure that the constructor is executed

robot    arobot;









//      Main program

//      Every Portable C++ program has one method called main, not
//      associated with a class. This is the one that starts the
//      main body of the program.

void main(void)
{
//      Set the screen to 640x480x16 graphics mode

scr.setmode(0x12);

//      Move the robot in various directions

arobot.forward();
arobot.forward();
arobot.forward();
arobot.up();
arobot.up();
arobot.forward();
arobot.forward();
arobot.up();
arobot.up();
arobot.up();
arobot.forward();
arobot.forward();
arobot.up();
arobot.forward();
arobot.forward();
arobot.forward();
arobot.up();
arobot.up();
arobot.down();
arobot.up();
arobot.up();
arobot.up();
arobot.forward();
arobot.forward();
arobot.forward();
arobot.up();
arobot.forward();
arobot.forward();
arobot.up();
arobot.up();
arobot.down();
arobot.up();
arobot.up();
arobot.up();
arobot.forward();
arobot.down();
arobot.forward();
arobot.forward();
arobot.up();
arobot.forward();
arobot.forward();
arobot.forward();
arobot.up();
arobot.up();
arobot.forward();
arobot.forward();
arobot.up();
arobot.up();
arobot.up();
arobot.forward();
arobot.forward();
arobot.forward();
arobot.forward();
arobot.up();
arobot.up();
arobot.up();
arobot.forward();
arobot.forward();
arobot.forward();

//      Print several lines and a message

aconsole.newline();
aconsole.newline();
aconsole.newline();
aconsole.newline();
aconsole.write("We made it!");

//      Wait 100 milliseconds

aconsole.mwait(100);

//      Print several lines and a message

aconsole.newline();
aconsole.newline();
aconsole.newline();
aconsole.write("Press any key to exit");

//      Wait for a key

kbd.get();

//      Reset the screen to text mode

scr.setmode(0x03);
}



















