#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<stdlib.h>
#include<malloc.h>

int rfxfd;

struct header_s
	{
	unsigned char mfgr;
	unsigned char version;
	unsigned char encoding;
	unsigned char bppix;
	unsigned short xmin;
	unsigned short ymin;
	unsigned short xmax;
	unsigned short ymax;
	unsigned short hdpi;
	unsigned short vdpi;
	unsigned char cmap[48];
	unsigned char reserved;
	unsigned char nplanes;
	unsigned short bypl;
	unsigned short paltinf;
	unsigned short hscrnsz;
	unsigned short vscrnsz;
	unsigned char filler[54];
	};

int dcsvr;

int pcxfd, faxlines;
struct header_s header;

pcxwriteheader()
	{
	int i;
	header.mfgr=10;
	header.version=45;
	header.encoding=1;
	header.bppix=1;
	header.xmin=0;
	header.ymin=0;
	header.xmax=1727;
	header.ymax=(faxlines*(2-dcsvr))-1;
	header.hdpi=200;
	header.vdpi=192;
	header.reserved=0;
	header.nplanes=1;
	header.bypl=216;
	header.paltinf=1;
	header.hscrnsz=0;
	header.vscrnsz=0;
	for(i=0;i<54;++i)
		header.filler[i]=0;
	lseek(pcxfd, (long)0, SEEK_SET);
	if(write(pcxfd, &header, 128)!=128)
		{
		printf("Error overwriting final pcx file header.\n");
		exit(9);
		}
	}

#define RBUFSIZ 16384

unsigned char rbuf[RBUFSIZ];
int rbufindex, rbufn;

int rch(cptr)
	unsigned char *cptr;
	{
	if(rbufindex>=rbufn)
		{
		if((rbufn=read(rfxfd, rbuf, RBUFSIZ))<=0)
			return(0);
		rbufindex=0;
		}
	(*cptr)=rbuf[rbufindex++];
	return(1);
	}		

unsigned char fcfr[]="+FCFR\r\n\r\n";
unsigned char fhng[]="+FHNG";
unsigned char connect[]="CONNECT\r\n";

int scanfcfr()
	{
	int i, j, k;
	unsigned char c;
	i=j=k=0;
	while(rch(&c))
		{
		if(fcfr[i]==c)
			{
			i++;
			if(fcfr[i]=='\0')
				return(1);
			}
		else
			i=0;
		if(connect[k]==c)
			{
			k++;
			if(connect[k]=='\0')
				return(0);
			}
		else
			k=0;
		if(fhng[j]==c)
			{
			j++;
			if(fhng[j]=='\0')
				{
				printf("End of document. Exit code +FHNG");
				while(1)
					{
					if(!rch(&c))
						{
						printf("\nPremature end of file while seeking +FHNG code.\n");
						exit(6);
						}
					putchar(c);
					if(c=='\n')
						break;
					}
				exit(0);
				}
			}
		else
			j=0;
		}
	printf("Premature end of file while seeking +FCFR.\n");
	exit(5);
	}

int scanconnect()
	{
	int i;
	unsigned char c;
	i=0;
	while(rch(&c))
		{
		if(connect[i]==c)
			{
			i++;
			if(connect[i]=='\0')
				return(0);
			}
		else
			i=0;
		}
	printf("Premature end of file while seeking CONNECT.\n");
	exit(7);
	}

int rfxgets(str)
	unsigned char *str;
	{
	int i;
	i=0;
	while(rch(&str[i]))
		if(str[i]=='\r')
			{
			str[i]='\0';
			return(i);
			}
		else
			i++;
	return(-1);
	}

#define WBUFSIZ 17248
#define WBUFTHRESH 16384

unsigned char wbuf[WBUFSIZ];
int wbufindex, wlinebeg;

int linenbits;
unsigned char curwbyte;
int curwbytebit;

int putwhite(n)
	int n;
	{
	int i, fragn;
	unsigned char mask;
	linenbits+=n;
	if(linenbits>1728)
		return(0);
	if(n<(fragn=8-curwbytebit))
		{
		for(i=fragn,mask=1;i;--i)
			{
			curwbyte|=mask;
			mask<<=1;
			}
		curwbytebit+=n;
		return(1);
		}
	for(i=fragn, mask=1;i;i--)
		{
		curwbyte|=mask;
		mask<<=1;
		}
	n-=fragn;
	if((curwbyte&0xc0)==0xc0)
		wbuf[wbufindex++]=0xc1;
	wbuf[wbufindex++]=curwbyte;
	curwbytebit=0;
	fragn=(n>>3)&0x1fff;
	while(fragn>=63)
		{
		wbuf[wbufindex++]=0xff;
		wbuf[wbufindex++]=0xff;
		fragn-=63;
		}
	if(fragn)
		{
		wbuf[wbufindex++]=(0xc0|fragn);
		wbuf[wbufindex++]=0xff;
		}
	curwbyte=0xff;
	curwbytebit=(n&0x0007);
	return(1);
	}

int putblack(n)
	int n;
	{
	int i, fragn;
	unsigned char mask;
	linenbits+=n;
	if(linenbits>1728)
		return(0);
	if(n<(fragn=8-curwbytebit))
		{
		for(i=fragn,mask=0xfe;i;--i)
			{
			curwbyte&=mask;
			mask<<=1;
			}
		curwbytebit+=n;
		return(1);
		}
	for(i=fragn, mask=0xfe;i;i--)
		{
		curwbyte&=mask;
		mask<<=1;
		}
	n-=fragn;
	if((curwbyte&0xc0)==0xc0)
		wbuf[wbufindex++]=0xc1;
	wbuf[wbufindex++]=curwbyte;
	curwbytebit=0;
	fragn=(n>>3)&0x1fff;
	while(fragn>=63)
		{
		wbuf[wbufindex++]=0xff;
		wbuf[wbufindex++]=0x00;
		fragn-=63;
		}
	if(fragn)
		{
		wbuf[wbufindex++]=(0xc0|fragn);
		wbuf[wbufindex++]=0x00;
		}
	curwbyte=0x00;
	curwbytebit=(n&0x0007);
	return(1);
	}

int pcxwriteline()
	{
	int i, count;
	if(!linenbits)
		return(0); /* Special case extra EOLs (start and finish) */
	if(linenbits!=1728)
		{
		printf("\rLine %d bad length: %d pels.\n", faxlines, linenbits);
		wbufindex=wlinebeg;
		return(0);
		}
	if((faxlines++&0x001f)==0x001f)
		printf("\rLine %d", faxlines);
	if(!dcsvr)
		for(i=wlinebeg, count=wbufindex-wlinebeg;count;i++, wbufindex++, count--)
			wbuf[wbufindex]=wbuf[i];
	if((wlinebeg=wbufindex)>=WBUFTHRESH)
		{
		if(write(pcxfd, wbuf, wbufindex)!=wbufindex)
			{
			printf("\nPCX write error.\n");
			exit(111);
			}
		wbufindex=wlinebeg=0;
		}
	linenbits=0;
	}

abortpage()
	{
	unsigned char c;
	printf("Flushing page...\n");
	while(1)
		{
		if(!rch(&c))
			{
			printf("Premature end of file while flushing bad page.\n");
			exit(30);
			}
		if(c==0x10)
			{
			if(!rch(&c))
				{
				printf("Premature end of file while flushing bad page.\n");
				exit(30);
				}
			if(c==0x03)
				break;
			}
		}
	}

unsigned char *states, *results1, *results2, *results3;

main(argc, argv)
	int argc;
	char **argv;
	{
	int fd, dcswd, dcsdf, page, bitcount, oflag;
	int npelschk, gotfcfr;
	unsigned char c, str[256];
	union
		{
		unsigned word;
		struct
			{
			unsigned char lobyte;
			unsigned char hibyte;
			}
			bytes;
		}
		mess;
	unsigned char *tilo, *tihi;
	unsigned *tindex;
	printf("Copyright (C) 1992 Peter Edward Cann\n\n");
	if(argc!=2)
		{
		printf("USAGE: rfx2pcx <rfx filename>\n");
		exit(10);
		}
	tilo=&(mess.bytes.lobyte);
	tihi=&(mess.bytes.hibyte);
	tindex=&(mess.word);
	rbufindex=rbufn=wbufindex=wlinebeg=0;
	curwbytebit=0;
	if((states=malloc(57856))==NULL)
		{
		printf("Malloc error for states.\n");
		exit(1);
		}
	if((results1=malloc(57856))==NULL)
		{
		printf("Malloc error for results1.\n");
		exit(1);
		}
	if((results2=malloc(57856))==NULL)
		{
		printf("Malloc error for results2.\n");
		exit(1);
		}
	if((results3=malloc(57856))==NULL)
		{
		printf("Malloc error for results3.\n");
		exit(1);
		}
	if(getenv("PCCPPATH")==NULL)
		sprintf(str, "statmach.dat");
	else
		sprintf(str, "%s\\statmach.dat", getenv("PCCPPATH"));
	if((fd=open(str, O_RDONLY|O_BINARY))==-1)
		{
		printf("Unable to open state machine file %s.\n", str);
		exit(2);
		}
	if(read(fd, states, 57856)!=(unsigned)57856)
		{
		printf("Read error on states.\n");
		exit(3);
		}
	if(read(fd, results1, 57856)!=(unsigned)57856)
		{
		printf("Read error on results1.\n");
		exit(3);
		}
	if(read(fd, results2, 57856)!=(unsigned)57856)
		{
		printf("Read error on results2.\n");
		exit(3);
		}
	if(read(fd, results3, 57856)!=(unsigned)57856)
		{
		printf("Read error on results3.\n");
		exit(3);
		}
	close(fd);
	printf("State machine table allocated and loaded successfully.\n\n");
	(*tindex)=0;
	if((rfxfd=open(argv[1], O_RDONLY|O_BINARY))==-1)
		{
		printf("Error opening %s for read.\n", argv[1]);
		exit(11);
		}
	oflag=0;
	while(1)
		{
		if(!rch(&c))
			{
			printf("Premature end of file while seeking initial doublequote.\n");
			exit(12);
			}
		if(c=='"')
			{
			oflag=0;
			break;
			}
		if(oflag)
			if(c=='K')
				break;
			else
				oflag=0;
		if(c=='O')
			oflag=1;
		}
	printf("Sender ID: ");
	if(oflag)
		printf("Not specified.");
	else
		while(1)
			{
			if(!rch(&c))
				{
				printf("Premature end of file while seeking final doublequote.\n");
				exit(13);
				}
			if(c=='"')
				break;
			putchar(c);
			}
	putchar('\n');
	page=0;
	gotfcfr=0;
	while(1)
		{
		page++;
		if(scanfcfr()) /* Normal exit is in this function */
			{
			if(rfxgets(str)==-1)
				{
				printf("Premature end of file while seeking +FDCS.\n");
				exit(15);
				}
			if(sscanf(str, " +FDCS: %d,%*d,%d,%*d,%d,%*d,%*d,%*d",
				&dcsvr, &dcswd, &dcsdf)!=3)
				{
				printf("Error scanning +FDCS params.\n");
				exit(14);
				}
			else
				gotfcfr=1;
			if(dcsvr)
				printf("High vertical resolution.\n");
			else
				printf("Standard vertical resolution.\n");
			if(dcswd)
				{
				printf("Non-supported width!\n");
				exit(13);
				}
			if(dcsdf)
				{
				printf("Non-supported coding scheme (must be 1-D)!\n");
				exit(14);
				}
			scanconnect();
			gotfcfr=1;
			}
		if(!gotfcfr)
			{
			printf("Never got initial +FCFR; aborting.\n");
			exit(60);
			}
		while(1)
			{
			printf("Enter filename for Page %d (include .PCX):\n--> ", page);
			gets(str);
			if((pcxfd=open(str, O_CREAT|O_BINARY|O_TRUNC|O_WRONLY, S_IWRITE))!=-1)
				break;
			else
				printf("Error opening file.\n");
			}
		/* Save a dummy block for PCX file header */
		if(write(pcxfd, str, 128)!=128)
			{
			printf("Error writing dummy header to file.\n");
			exit(20);
			}
		/* Translate */
		faxlines=0;
		linenbits=0;
		/* flush 1 bits */
		do
			if(rch(&c)!=1)
				break;
		while(c==0xff);
		/* If we prime state machine with 0x0000 we can trash first */
		/* byte that isn't 0xff and still recognize EOL. */
		(*tihi)=states[0x0000];
		(*tilo)=0x00;
		(*tihi)=states[*tindex];
		while(1)
			{
			if(rbufindex>=rbufn)
				if(rch(tilo)!=1)
					{
					printf("Premature EOF.\n");
					break;
					}
				else;
			else
				(*tilo)=rbuf[rbufindex++];
			if((*tilo)==0x10)
				{
				if(rch(tilo)!=1)
					{
					printf("Premature EOF.\n");
					break;
					}
				if((*tilo)!=0x10)
					break; /* No randomness allowed. */
				}
			if((c=results1[*tindex])!=255)
				{
				if(c==254)
					pcxwriteline();
				else
					{
					if(c&0x80)
						if(c&0x40)
							putblack(((int)(c&63))<<6);
						else
							putblack(c&63);
					else
						if(c&0x40)
							putwhite(((int)(c&63))<<6);
						else
							putwhite(c);
					}
				if((c=results2[*tindex])!=255)
					{
					if(c==254)
						pcxwriteline();
					else
						{
						if(c&0x80)
							if(c&0x40)
								putblack(((int)(c&63))<<6);
							else
								putblack(c&63);
						else
							if(c&0x40)
								putwhite(((int)(c&63))<<6);
							else
								putwhite(c);
						}
					if((c=results3[*tindex])!=255)
						{
						if(c==254)
							pcxwriteline();
						else
							{
							if(c&0x80)
								if(c&0x40)
									putblack(((int)(c&63))<<6);
								else
									putblack(c&63);
							else
								if(c&0x40)
									putwhite(((int)(c&63))<<6);
								else
									putwhite(c);
							}
						}
					}
				}
			(*tihi)=states[*tindex];
			}
		printf("\rLine %d\n", faxlines);
		if(wbufindex) /* Flush */
			{
			if(write(pcxfd, wbuf, wbufindex)!=wbufindex)
				{
				printf("PCX write error.\n");
				exit(112);
				}
			wbufindex=wlinebeg=0;
			}
		pcxwriteheader();
		close(pcxfd);
		printf("Page translate completed.\n");
		}
	}
