/* Copyright 1992, 1993 Peter Edward Cann, all rights reserved */

#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<bios.h>
#include<dos.h>
#include<graph.h>
#include<stdlib.h>
#include<malloc.h>

struct header_s
	{
	unsigned char mfgr;
	unsigned char version;
	unsigned char encoding;
	unsigned char bppix;
	unsigned short xmin;
	unsigned short ymin;
	unsigned short xmax;
	unsigned short ymax;
	unsigned short hdpi;
	unsigned short vdpi;
	unsigned char cmap[48];
	unsigned char reserved;
	unsigned char nplanes;
	unsigned short bypl;
	unsigned short paltinf;
	unsigned short hscrnsz;
	unsigned short vscrnsz;
	unsigned char filler[54];
	};

struct header_s header;

unsigned long tick;

void (interrupt far *oldtick)();

void interrupt far tickhndl()
	{
	tick++;
	}

struct lrunode
	{
	char prev;
	char which;
	char next;
	}
	lru[20];

char lruhead, lrutail, nlru, cachetab[128];

unsigned char *buf[20];
char nblocks, swapsize;

int swapfd;

xseek(which)
	char which;
	{
	if(!swapsize)
		if((swapfd=open("viewpcx.swp", O_RDWR|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE))==-1)
			{
			_setvideomode(_DEFAULTMODE);
			printf("Swap open error.\n");
			exit(43);
			}
	if(which>swapsize)
		{
		if(lseek(swapfd, (long)swapsize<<15, SEEK_SET)==(long)-1)
			{
			_setvideomode(_DEFAULTMODE);
			printf("Swap grow seek error; existing banks %d.\n", (int)swapsize);
			exit(70);
			}
		while(which>swapsize)
			{
			if(write(swapfd, buf[0], 32768)!=(unsigned)32768)
				{
				_setvideomode(_DEFAULTMODE);
				printf("Swap grow write error, existing banks %d.\n", (int)swapsize);
				exit(44);
				}
			swapsize++;
			}
		}
	if(which==swapsize)
		swapsize++; /* We trust us to write. */
	if(lseek(swapfd, ((long)which)<<15, SEEK_SET)==(long)-1)
		{
		_setvideomode(_DEFAULTMODE);
		printf("Swap seek error, bank %d.\n", which);
		exit(42);
		}
	}

char getcache()
	{
	char tmp;
	if(!nlru)
		{
		lruhead=lrutail=(char)0;
		lru[0].prev=lru[0].next=(char)-1;
		return(nlru++);
		}
	if(nlru<nblocks)
		{
		lru[nlru].prev=(char)-1;
		lru[nlru].next=lruhead;
		lru[lruhead].prev=nlru;
		lruhead=nlru;
		return(nlru++);
		}
	xseek(lru[lrutail].which);
	if(write(swapfd, buf[lrutail], 32768)!=(unsigned)32768)
		{
		_setvideomode(_DEFAULTMODE);
		printf("Swap write error, buf[%d].\n", lrutail);
		exit(41);
		}
	cachetab[lru[lrutail].which]=(char)-1;
	tmp=lrutail;
	lrutail=lru[tmp].prev;
	lru[lrutail].next=(char)-1;
	lru[tmp].prev=(char)-1;
	lru[tmp].next=lruhead;
	lru[lruhead].prev=tmp;
	lruhead=tmp;
	return(tmp);
	}

char ntotal;

unsigned char *getnew()
	{
	char cachepos;
	if(ntotal>=127)
		{
		_setvideomode(_DEFAULTMODE);
		printf("Too much storage requested.\n");
		exit(45);
		}
	cachepos=getcache();
	cachetab[ntotal]=cachepos;
	lru[cachepos].which=ntotal++;
	return(buf[cachepos]);
	}

unsigned char *fetch(which)
	char which;
	{
	char cachepos, prevcp, nextcp;
	if((cachepos=cachetab[which])!=-1)
		{
		if(cachepos==lruhead)
			return(buf[cachepos]);
		if(cachepos==lrutail)
			{
			lrutail=lru[cachepos].prev;
			lru[lrutail].next=(char)-1;
			lru[lruhead].prev=cachepos;
			lru[cachepos].next=lruhead;
			lru[cachepos].prev=(char)-1;
			lruhead=cachepos;
			return(buf[cachepos]);
			}
		prevcp=lru[cachepos].prev;
		nextcp=lru[cachepos].next;
		lru[prevcp].next=nextcp;
		lru[nextcp].prev=prevcp;
		lru[cachepos].next=lruhead;
		lru[cachepos].prev=(char)-1;
		lru[lruhead].prev=cachepos;
		lruhead=cachepos;
		return(buf[cachepos]);
		}
	cachepos=getcache();
	lru[cachepos].which=which;
	xseek(which);
	if(read(swapfd, buf[cachepos], 32768)!=(unsigned)32768)
		{
		_setvideomode(_DEFAULTMODE);
		printf("Swap read error, buf[%d].\n", cachepos);
		exit(46);
		}
	cachetab[which]=cachepos;
	return(buf[cachepos]);
	}

#define INS 0x5200
#define DEL 0x5300
#define HOME 0x4700
#define END 0x4f00
#define PGUP 0x4900
#define PGDN 0x5100
#define UP 0x4800
#define DN 0x5000
#define LT 0x4b00
#define RT 0x4d00
#define ESC 0x011b

unsigned char barr1[1024], barr2[1024], barr3[1024], bassack[256];
unsigned char bbarr1[1024], bbarr2[1024], bbarr3[1024];

/* If you want to get rid of the black-priority feature in the zoom
 * mode, I think you do it here, in the table preparation.
 * If you want to recover some speed by doing that, remove the
 * shifty stuff from the z-whatever-redisplay functions.
 */

mkbtab()
	{
	int i, j;
	for(i=0;i<256;++i)
		{
		bassack[i]=0;
		for(j=0;j<8;++j)
			if(i&(1<<j))
				bassack[i]|=(((unsigned char)0x80)>>j);
		}
	for(i=0;i<1024;i++)
		{
		barr1[i]=barr2[i]=barr3[i]=bbarr1[i]=bbarr2[i]=bbarr3[i]=0;
		/* There's probably a faster way to handle this,
		 * but every time I try, I bomb! */
		if((i&0xe0)==0xe0)
			{
			barr1[i]|=0x80;
			bbarr1[i]|=0x01;
			}
		if((i&0x1c)==0x1c)
			{
			barr1[i]|=0x40;
			bbarr1[i]|=0x02;
			}
		if((i&0x380)==0x380)
			{
			barr2[i]|=0x20;
			bbarr2[i]|=0x04;
			}
		if((i&0x70)==0x70)
			{
			barr2[i]|=0x10;
			bbarr2[i]|=0x08;
			}
		if((i&0x0e)==0x0e)
			{
			barr2[i]|=0x08;
			bbarr2[i]|=0x10;
			}
		if((i&0x1c0)==0x1c0)
			{
			barr3[i]|=0x04;
			bbarr3[i]|=0x20;
			}
		if((i&0x38)==0x38)
			{
			barr3[i]|=0x02;
			bbarr3[i]|=0x40;
			}
		if((i&0x07)==0x07)
			{
			barr3[i]|=0x01;
			bbarr3[i]|=0x80;
			}
		}
	}

unsigned uibpl, uiheight;
int vheight, vbpl, leftbyte, topline, iheight, ibpl;
long  vidbase;

normredisplay()
	{
	long l, l1, lvid, bvid;
	unsigned llocnt;
	int byte, lcnt, bcnt, llo, lhi, ibcnt, ilcnt;
	unsigned char *arr;
	for(l=((long)topline*ibpl), lvid=vidbase, lcnt=vheight, ilcnt=iheight-topline;lcnt--;l+=ibpl, lvid+=vbpl)
		if(ilcnt)
			{
			ilcnt--;
			l1=l+leftbyte;
			lhi=(l1>>15)&0x0f;
			arr=fetch(lhi);
			llo=l1&0x7fff;
			llocnt=32768-llo;
			arr=&arr[llo];
			for(bvid=lvid, bcnt=vbpl, ibcnt=ibpl-leftbyte;bcnt--;++bvid)
				if(ibcnt--)
					{
					(*(unsigned char *)bvid)=*arr++;
					if(!(--llocnt))
						{
						llocnt=32768;
						arr=fetch(++lhi);
						}
					}
				else
					{
					ibcnt++; /* Cancel 0-- */
					(*(unsigned char *)bvid)=0;
					}
			}
		else
			for(bvid=lvid,bcnt=vbpl;bcnt--;bvid++)
				(*(unsigned char *)bvid)=0;
	}

normredisplay180()
	{
	long l, l1, lvid, bvid;
	unsigned llocnt;
	int byte, lcnt, bcnt, llo, lhi, ibcnt, ilcnt;
	unsigned char *arr;
	for(l=((long)topline*ibpl), lvid=vidbase+(((long)vbpl)*vheight)-1, lcnt=vheight, ilcnt=iheight-topline;lcnt--;l+=ibpl, lvid-=vbpl)
		if(ilcnt)
			{
			ilcnt--;
			l1=l+leftbyte;
			lhi=(l1>>15)&0x0f;
			arr=fetch(lhi);
			llo=l1&0x7fff;
			llocnt=32768-llo;
			arr=&arr[llo];
			for(bvid=lvid, bcnt=vbpl, ibcnt=ibpl-leftbyte;bcnt--;--bvid)
				if(ibcnt--)
					{
					(*(unsigned char *)bvid)=bassack[*arr++];
					if(!(--llocnt))
						{
						llocnt=32768;
						arr=fetch(++lhi);
						}
					}
				else
					{
					ibcnt++; /* Cancel 0-- */
					(*(unsigned char *)bvid)=0;
					}
			}
		else
			for(bvid=lvid,bcnt=vbpl;bcnt--;bvid--)
				(*(unsigned char *)bvid)=0;
	}

hercredisplay()
	{
	long l, l1, lvid, bvid;
	unsigned llocnt;
	int byte, line, lcnt, bcnt, llo, lhi, ibcnt, ilcnt;
	unsigned char *arr;
	for(l=((long)topline*ibpl), line=0, lcnt=vheight, ilcnt=iheight-topline;lcnt--;l+=ibpl, ++line)
		{
		lvid=vidbase+(((line>>2)&0xff)*90)+((line&3)<<13);
		if(ilcnt)
			{
			ilcnt--;
			l1=l+leftbyte;
			lhi=(l1>>15)&0x0f;
			arr=fetch(lhi);
			llo=l1&0x7fff;
			llocnt=32768-llo;
			arr=&arr[llo];
			for(bvid=lvid, bcnt=vbpl, ibcnt=ibpl-leftbyte;bcnt--;++bvid)
				if(ibcnt--)
					{
					(*(unsigned char *)bvid)=*arr++;
					if(!(--llocnt))
						{
						llocnt=32768;
						arr=fetch(++lhi);
						}
					}
				else
					{
					ibcnt++;
					(*(unsigned char *)bvid)=0;
					}
			}
		else
			for(bvid=lvid,bcnt=vbpl;bcnt--;bvid++)
				(*(unsigned char *)bvid)=0;
		}
	}

hercredisplay180()
	{
	long l, l1, lvid, bvid;
	unsigned llocnt;
	int byte, line, lcnt, bcnt, llo, lhi, ibcnt, ilcnt;
	unsigned char *arr;
	for(l=((long)topline*ibpl), line=vheight-1, lcnt=vheight, ilcnt=iheight-topline;lcnt--;l+=ibpl, --line)
		{
		lvid=vidbase+(((line>>2)&0xff)*90)+((line&3)<<13);
		if(ilcnt)
			{
			ilcnt--;
			l1=l+leftbyte;
			lhi=(l1>>15)&0x0f;
			arr=fetch(lhi);
			llo=l1&0x7fff;
			llocnt=32768-llo;
			arr=&arr[llo];
			for(bvid=lvid+vbpl-1, bcnt=vbpl, ibcnt=ibpl-leftbyte;bcnt--;--bvid)
				if(ibcnt--)
					{
					(*(unsigned char *)bvid)=bassack[*arr++];
					if(!(--llocnt))
						{
						llocnt=32768;
						arr=fetch(++lhi);
						}
					}
				else
					{
					ibcnt++;
					(*(unsigned char *)bvid)=0;
					}
			}
		else
			for(bvid=lvid,bcnt=vbpl;bcnt--;bvid++)
				(*(unsigned char *)bvid)=0;
		}
	}

znormredisplay()
	{
	long l, l1, lvid, bvid;
	unsigned llocnt;
	int byte, lcnt, bcnt, llo, lhi, ibcnt, ilcnt, zibpl, bai;
	unsigned char *arr;
	zibpl=ibpl*3;
	for(l=((long)topline*ibpl), lvid=vidbase, lcnt=vheight, ilcnt=(iheight-topline)/3;lcnt--;l+=zibpl, lvid+=vbpl)
		if(ilcnt)
			{
			ilcnt--;
			l1=l+leftbyte;
			lhi=(l1>>15)&0x0f;
			arr=fetch(lhi);
			llo=l1&0x7fff;
			llocnt=32768-llo;
			arr=&arr[llo];
			for(bai=0xff, bvid=lvid, bcnt=vbpl, ibcnt=ibpl-leftbyte;bcnt--;++bvid)
				if(ibcnt--)
					{
					(*(unsigned char *)bvid)=barr1[bai=(*arr++)];
					if(!(--llocnt))
						{
						llocnt=32768;
						arr=fetch(++lhi);
						}
					if(ibcnt--)
						{
						(*(unsigned char *)bvid)|=barr2[bai=(((bai<<8)|(*arr++))&0x3ff)];
						if(!(--llocnt))
							{
							llocnt=32768;
							arr=fetch(++lhi);
							}
						if(ibcnt--)
							{
							(*(unsigned char *)bvid)|=barr3[bai=(((bai<<8)|(*arr++))&0x1ff)];
							if(!(--llocnt))
								{
								llocnt=32768;
								arr=fetch(++lhi);
								}
							}
						else
							ibcnt++;
						}
					else
						ibcnt++;
					}
				else
					{
					ibcnt++;
					(*(unsigned char *)bvid)=0;
					}
			}
		else
			for(bvid=lvid,bcnt=vbpl;bcnt--;bvid++)
				(*(unsigned char *)bvid)=0;
	}

znormredisplay180()
	{
	long l, l1, lvid, bvid;
	unsigned llocnt;
	int byte, lcnt, bcnt, llo, lhi, ibcnt, ilcnt, zibpl, bai;
	unsigned char *arr;
	zibpl=ibpl*3;
	for(l=((long)topline*ibpl), lvid=vidbase+(((long)vbpl)*vheight)-1, lcnt=vheight, ilcnt=(iheight-topline)/3;lcnt--;l+=zibpl, lvid-=vbpl)
		if(ilcnt)
			{
			ilcnt--;
			l1=l+leftbyte;
			lhi=(l1>>15)&0x0f;
			arr=fetch(lhi);
			llo=l1&0x7fff;
			llocnt=32768-llo;
			arr=&arr[llo];
			for(bai=0xff, bvid=lvid, bcnt=vbpl, ibcnt=ibpl-leftbyte;bcnt--;--bvid)
				if(ibcnt--)
					{
					(*(unsigned char *)bvid)=bbarr1[bai=(*arr++)];
					if(!(--llocnt))
						{
						llocnt=32768;
						arr=fetch(++lhi);
						}
					if(ibcnt--)
						{
						(*(unsigned char *)bvid)|=bbarr2[bai=(((bai<<8)|(*arr++))&0x3ff)];
						if(!(--llocnt))
							{
							llocnt=32768;
							arr=fetch(++lhi);
							}
						if(ibcnt--)
							{
							(*(unsigned char *)bvid)|=bbarr3[bai=(((bai<<8)|(*arr++))&0x1ff)];
							if(!(--llocnt))
								{
								llocnt=32768;
								arr=fetch(++lhi);
								}
							}
						else
							ibcnt++;
						}
					else
						ibcnt++;
					}
				else
					{
					ibcnt++;
					(*(unsigned char *)bvid)=0;
					}
			}
		else
			for(bvid=lvid,bcnt=vbpl;bcnt--;bvid--)
				(*(unsigned char *)bvid)=0;
	}

zhercredisplay()
	{
	long l, l1, lvid, bvid;
	unsigned llocnt, bai;
	int byte, line, lcnt, bcnt, llo, lhi, ibcnt, ilcnt, zibpl;
	unsigned char *arr;
	zibpl=ibpl*3;
	for(l=((long)topline*ibpl), line=0, lcnt=vheight, ilcnt=(iheight-topline)/3;lcnt--;l+=zibpl, ++line)
		{
		lvid=vidbase+(((line>>2)&0xff)*90)+((line&3)<<13);
		if(ilcnt)
			{
			ilcnt--;
			l1=l+leftbyte;
			lhi=(l1>>15)&0x0f;
			arr=fetch(lhi);
			llo=l1&0x7fff;
			llocnt=32768-llo;
			arr=&arr[llo];
			for(bai=0xff, bvid=lvid, bcnt=vbpl, ibcnt=ibpl-leftbyte;bcnt--;++bvid)
				if(ibcnt--)
					{
					(*(unsigned char *)bvid)=barr1[bai=(*arr++)];
					if(!(--llocnt))
						{
						llocnt=32768;
						arr=fetch(++lhi);
						}
					if(ibcnt--)
						{
						(*(unsigned char *)bvid)|=barr2[bai=(((bai<<8)|(*arr++))&0x3ff)];
						if(!(--llocnt))
							{
							llocnt=32768;
							arr=fetch(++lhi);
							}
						if(ibcnt--)
							{
							(*(unsigned char *)bvid)|=barr3[bai=(((bai<<8)|(*arr++))&0x1ff)];
							if(!(--llocnt))
								{
								llocnt=32768;
								arr=fetch(++lhi);
								}
							}
						else
							ibcnt++;
						}
					else
						ibcnt++;
					}
				else
					{
					ibcnt++;
					(*(unsigned char *)bvid)=0;
					}
			}
		else
			for(bvid=lvid,bcnt=vbpl;bcnt--;bvid++)
				(*(unsigned char *)bvid)=0;
		}
	}

zhercredisplay180()
	{
	long l, l1, lvid, bvid;
	unsigned llocnt, bai;
	int byte, line, lcnt, bcnt, llo, lhi, ibcnt, ilcnt, zibpl;
	unsigned char *arr;
	zibpl=ibpl*3;
	for(l=((long)topline*ibpl), line=vheight-1, lcnt=vheight, ilcnt=(iheight-topline)/3;lcnt--;l+=zibpl, --line)
		{
		lvid=vidbase+(((line>>2)&0xff)*90)+((line&3)<<13);
		if(ilcnt)
			{
			ilcnt--;
			l1=l+leftbyte;
			lhi=(l1>>15)&0x0f;
			arr=fetch(lhi);
			llo=l1&0x7fff;
			llocnt=32768-llo;
			arr=&arr[llo];
			for(bai=0xff, bvid=lvid+vbpl-1, bcnt=vbpl, ibcnt=ibpl-leftbyte;bcnt--;--bvid)
				if(ibcnt--)
					{
					(*(unsigned char *)bvid)=bbarr1[bai=(*arr++)];
					if(!(--llocnt))
						{
						llocnt=32768;
						arr=fetch(++lhi);
						}
					if(ibcnt--)
						{
						(*(unsigned char *)bvid)|=bbarr2[bai=(((bai<<8)|(*arr++))&0x3ff)];
						if(!(--llocnt))
							{
							llocnt=32768;
							arr=fetch(++lhi);
							}
						if(ibcnt--)
							{
							(*(unsigned char *)bvid)|=bbarr3[bai=(((bai<<8)|(*arr++))&0x1ff)];
							if(!(--llocnt))
								{
								llocnt=32768;
								arr=fetch(++lhi);
								}
							}
						else
							ibcnt++;
						}
					else
						ibcnt++;
					}
				else
					{
					ibcnt++;
					(*(unsigned char *)bvid)=0;
					}
			}
		else
			for(bvid=lvid,bcnt=vbpl;bcnt--;bvid--)
				(*(unsigned char *)bvid)=0;
		}
	}

char herc, zoom, rotp;

redisplay()
	{
	if(herc)
		if(zoom)
			if(rotp)
				zhercredisplay180();
			else
				zhercredisplay();
		else
			if(rotp)
				hercredisplay180();
			else
				hercredisplay();
	else
		if(zoom)
			if(rotp)
				znormredisplay180();
			else
				znormredisplay();
		else
			if(rotp)
				normredisplay180();
			else
				normredisplay();
	}

poot() /* A less irritating beep */
	{
	oldtick=_dos_getvect(0x1c);
	_dos_setvect(0x1c, tickhndl);
	outp(0x43, 0xb6); /* Ctl Reg = #3 Lo-Hi Square Wave */
	outp(0x42, 164); /* Divisor LSB (250 Hz) */
	outp(0x42, 18); /* Divisor MSB (250 Hz) */
	tick=0L;
	while(tick==0L); /* Synchronize w/ tick phase; i.e. eliminate slop  */
	outp(0x61, inp(0x61)|0x03); /* PortB; 2^0: timer gate, 2^1: AND/OR? */
	while(1)
		{
		if(tick>1) /* EXACTLY 1 tick */
			break;
		}
	outp(0x61, inp(0x61)&~(unsigned char)0x03);
	_dos_setvect(0x1c, oldtick);
	}

#define FBUFSIZ 16384

unsigned char fbuf[FBUFSIZ];

main(argc, argv)
	int argc;
	char **argv;
	{
	unsigned int k;
	int i, count, vstep, hstep, bbytes, fd;
	unsigned llocnt;
	unsigned char c, *arr, *fbp;
	struct videoconfig *vconf;
	swapfd=-1;
	nlru=0;
	ntotal=0;
	swapsize=0;
	i=0;
	rotp=0;
	if(!strcmp(getenv("REMOTE"), "YES"))
		{
		printf("You appear to be logged in remotely, judging by the environment\n");
		printf("variable REMOTE, so this is probably a very bad idea.\n");
		printf("Are you sure you want to run VIEWPCX? (y or n) --> ");
		if(getchar()!='y') /* Note getchar() and not getch()! */
			{
			printf("n\nI didn't think so!\n");
			exit(99);
			}
		else
			printf("y\nOK, you're the boss!\n");
		}
	while(i<20)
		if((buf[i]=malloc(32768))==NULL)
			break;
		else
			++i;
	nblocks=i;
	if((argc!=2)&&(argc!=4))
		{
		printf("\nUSAGE: viewpcx <file> [<vertical step> <horizontal step>]\n");
		printf("\nKey Commands:\n\n");
		printf("\t   INSERT - Toggle 3:1 Zoom\n");
		printf("\t   DELETE - Rotate 180\n");
		printf("\t     HOME - Go to Top of Image\n");
		printf("\t      END - Go to Bottom of Image\n");
		printf("\t  PAGE UP - View Screenfull Above\n");
		printf("\tPAGE DOWN - View Screenfull Below\n\n");
		printf("\t <arrows> - Move view by default or specified steps.\n");
		printf("\t      ESC - Exit\n");
		exit(1);
		}
	if(argc==4)
		{
		vstep=atoi(argv[2]);
		hstep=atoi(argv[3])/8;
		}
	else
		vstep=hstep=0;
	mkbtab();
	_getvideoconfig(vconf);
	herc=zoom=0;
	if((vconf->adapter==_HGC)||(vconf->adapter==_MDPA))
		{
		herc=1;
		vidbase=(long)0xb0000000;
		vheight=348;
		vbpl=90;
		if(!vstep)
			{
			vstep=100;
			hstep=30;
			}
		if(!_setvideomode(_HERCMONO))
			{
			printf("Couldn't set Hercules video mode. Did you run MSHERC.COM?\n");
			exit(5);
			}
		}
	else if(vconf->adapter==_CGA)
		{
		vidbase=(long)0xb8000000;
		vheight=200;
		vbpl=40;
		if(!vstep)
			{
			vstep=67;
			hstep=13;
			}
		if(!_setvideomode(_MRESNOCOLOR))
			{
			printf("Couldn't set CGA mono video mode.\n");
			exit(5);
			}
		}
	else if(vconf->adapter==_EGA)
		{
		vidbase=(long)0xb8000000;
		vheight=350;
		vbpl=80;
		if(!vstep)
			{
			vstep=110;
			hstep=26;
			}
		if(!_setvideomode(_ERESNOCOLOR))
			{
			printf("Couldn't set EGA mono video mode.\n");
			exit(5);
			}
		}
	else
		{
		vidbase=0xa0000000;
		vheight=480;
		vbpl=80;
		if(!vstep)
			{
			vstep=160;
			hstep=26;
			}
		if(!_setvideomode(_VRES2COLOR))
			{
			if(vconf->adapter!=_VGA)
				printf("Couldn't set unrecognized video adapter to VGA mono mode.\n");
			else
				printf("Couldn't set VGA mono video mode.\n");
			exit(5);
			}
		}
	if((fd=open(argv[1], O_RDONLY|O_BINARY))==-1)
		{
		_setvideomode(_DEFAULTMODE);
		printf("Error opening %s for read.\n", argv[1]);
		exit(6);
		}
	if(read(fd, &header, sizeof(header))!=sizeof(header))
		{
		_setvideomode(_DEFAULTMODE);
		printf("Error reading pcx file header.\n");
		exit(7);
		}
	if(((long)(uibpl=header.bypl)*(uiheight=(header.ymax+1-header.ymin)))>(128*32768))
		{
		_setvideomode(_DEFAULTMODE);
		printf("Sorry, image too big for paging code.\n");
		exit(8);
		}
	if((uiheight>16384)||(uibpl>16384))
		{
		printf("Sorry, image dimension(s) too great for math.\n");
		exit(8);
		}
	iheight=(int)uiheight;
	ibpl=(int)uibpl;
	if(header.nplanes!=1)
		{
		_setvideomode(_DEFAULTMODE);
		printf("Sorry, monochrome only.\n");
		exit(12);
		}
	if(header.bppix!=1)
		{
		_setvideomode(_DEFAULTMODE);
		printf("Sorry, I don't do grayscales.\n");
		exit(50);
		}
	llocnt=32767;
	count=0;
	arr=getnew();
	while((bbytes=read(fd, fbuf, FBUFSIZ))>0)
		for(fbp=fbuf;bbytes--;)
			{
			if(count)
				{
				while(count--)
					{
					*arr++=*fbp;
					if(!(llocnt--))
						{
						llocnt=32767;
						arr=getnew();
						}
					}
				fbp++;
				count=0;
				}
			else if(((*fbp)&0xc0)!=0xc0)
				{
				*arr++=*fbp++;
				if(!(llocnt--))
					{
					llocnt=32767;
					arr=getnew();
					}
				}
			else
				count=0x3f&*fbp++;
			}
	leftbyte=topline=0;
	redisplay();
	while((k=_bios_keybrd(_KEYBRD_READ))!=ESC)
		{
		if(rotp)
			{
			if(k==HOME)
				k=END;
			else if(k==END)
				k=HOME;
			else if(k==PGUP)
				k=PGDN;
			else if(k==PGDN)
				k=PGUP;
			else if(k==UP)
				k=DN;
			else if(k==DN)
				k=UP;
			else if(k==LT)
				k=RT;
			else if(k==RT)
				k=LT;
			}
		switch(k)
			{
			case INS:
				zoom=!zoom;
				redisplay();
				break;
			case LT:
				if(leftbyte<=0)
					{
					poot();
					break;
					}
				if(zoom)
					leftbyte-=hstep*3;
				else
					leftbyte-=hstep;
				if(leftbyte<0)
					leftbyte=0;
				redisplay();
				break;
			case RT:
				if(leftbyte>=(ibpl-((zoom?3:1)*vbpl)))
					{
					poot();
					break;
					}
				if(zoom)
					leftbyte+=hstep*3;
				else
					leftbyte+=hstep;
				if(leftbyte>(ibpl-((zoom?3:1)*vbpl)))
					leftbyte=ibpl-((zoom?3:1)*vbpl);
				redisplay();
				break;
			case UP:
				if(topline<=0)
					{
					poot();
					break;
					}
				if(zoom)
					topline-=vstep*3;
				else
					topline-=vstep;
				if(topline<0)
					topline=0;
				redisplay();
				break;
			case PGUP:
				if(topline<=0)
					{
					poot();
					break;
					}
				if(zoom)
					topline-=vheight*3;
				else
					topline-=vheight;
				if(topline<0)
					topline=0;
				redisplay();
				break;
			case DN:
				if(topline>=(iheight-((zoom?3:1)*vheight)))
					{
					poot();
					break;
					}
				if(zoom)
					topline+=vstep*3;
				else
					topline+=vstep;
				if(topline>(iheight-((zoom?3:1)*vheight)))
					topline=iheight-((zoom?3:1)*vheight);
				redisplay();
				break;
			case PGDN:
				if(topline>=(iheight-((zoom?3:1)*vheight)))
					{
					poot();
					break;
					}
				if(zoom)
					topline+=vheight*3;
				else
					topline+=vheight;
				if(topline>(iheight-((zoom?3:1)*vheight)))
					topline=iheight-((zoom?3:1)*vheight);
				redisplay();
				break;
			case HOME:
				topline=0;
				redisplay();
				break;
			case END:
				topline=iheight-((zoom?3:1)*vheight);
				if(topline<0)
					topline=0;
				redisplay();
				break;
			case DEL:
				rotp=!rotp;
				redisplay();
				break;
			default:
				putch(7);
			}
		}
	_setvideomode(_DEFAULTMODE);
	if(swapfd!=-1)
		unlink("viewpcx.swp");
	}
