/* Copyright (C) 1993 Peter Edward Cann */

#include<stdio.h>
#include<fcntl.h>
#include<time.h>
#include<signal.h>
#include<bios.h>
#include"port.h"


sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)));
	outp(basereg, c);
	}

int follow;

quit()
	{
	cleanup(0);
	exit(129);
	}

sendstr(str)
	char *str;
	{
	int i;
	for(i=0;str[i]!='\0';++i)
		sendchar(str[i]);
	}

#define NSCANS 3
unsigned char scans[NSCANS][16]={"CONNECT\r\n", "ERROR\r\n", "VCON\r\n"};
#define SCANTIMEOUT 8

int scan()
	{
	time_t timestamp;
	int i, j, scani[NSCANS];
	timestamp=time(NULL);
	for(i=0;i<NSCANS;++i)
		scani[i]=0;
	while(1)
		{
		while(follow==index)
			{
			if(kbhit())
				getch();
			if((time(NULL)-timestamp)>SCANTIMEOUT)
				{
				for(j=0;j<NSCANS;j++)
					scani[j]=0;
				return(-1);
				}
			}
		putch(buf[follow]);
		for(i=0;i<NSCANS;i++)
			if(scans[i][scani[i]]==buf[follow])
				{
				scani[i]++;
				if(scans[i][scani[i]]=='\0')
					{
					for(j=0;j<NSCANS;j++)
						scani[j]=0;
					follow++;
					follow%=TBUFSIZ;
					return(i);
					}
				}
			else
				scani[i]=0;
		follow++;
		follow%=TBUFSIZ;
		}
	}

#define VBUFSIZ 4096

unsigned char vbuf[VBUFSIZ];
int fd, vbufi, vbufn;

int getbyte()
	{
	if(vbufi>=vbufn)
		if((vbufn=read(fd, vbuf, VBUFSIZ))<=0)
			{
			printf("End of disk file without endcode.\n");
			sendchar(0x00); /* Kill possible pending DLE */
			sendchar(0x10);
			sendchar(0x03);
			while(!(inp(basereg+STATREG)&TXSHMTMASK));
			scan(); /* Makes life easier for scripts */
			cleanup(0);
			exit(138);
			}
		else
			vbufi=0;
	return(vbuf[vbufi++]);
	}

#define MAXCHECKS 64
unsigned char checks[MAXCHECKS];
int nchecks;

main(argc, argv)
	int argc;
	char **argv;
	{
	int dleflag, rdleflag, i, tmpi;
	unsigned kc;
	unsigned char c;
	if(argc<4)
		{
		printf("USAGE: voicetx <comnum> <speed> <file> [endcode] ...\n");
		printf("Endcodes are shielded codes, reported as exit codes starting with 0 (first).\n");
		printf("Real live errors are >128, which is play completed.\n");
		printf("Multi-char args are assumed hex.\n");
		exit(140);
		}
	if((fd=open(argv[3], O_RDONLY|O_BINARY))==-1)
		{
		printf("Unable to open voice file %s for read.\n", argv[3]);
		exit(150);
		}
	nchecks=0;
	while(1)
		{
		if(nchecks>=MAXCHECKS)
			{
			printf("Too many endcodes for this compile.\n");
			exit(145);
			}
		if(nchecks>=(argc-4)) /* Waste a few usec; who cares? */
			break;
		if(!argv[nchecks+4][0])
			{
			printf("Endcode %d null; exiting.\n", nchecks);
			exit(141);
			}
		if(!argv[nchecks+4][1])
			checks[nchecks]=argv[nchecks+4][0];
		else
			if(sscanf(argv[nchecks+4], "%x", &tmpi)!=1)
				{
				printf("Bad endcode scan %d; exiting.\n", nchecks);
				exit(142);
				}
			else
				checks[nchecks]=tmpi;
		nchecks++;
		}
	vbufi=vbufn=0;
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	databits='8';
	parity='n';
	stopbits='1';
	setport();
	readset();
	follow=index=0;
	setup();
	signal(SIGINT, quit);
	printf("Transmitting voice. Control-D to end, Control-C to nuke.\n");
	sendstr("AT#VTX\r");
	switch(scan())
		{
		case -1:
			cleanup(0);
			printf("Timeout waiting for CONNECT.\n");
			exit(130);
			break;
		case 0:
			break;
		case 1:
			cleanup(0);
			printf("Modem rejected play command.\n");
			exit(131);
			break;
		default:
			cleanup(0);
			printf("Strange scan() return.\n");
			exit(132);
			break;
		}
	dleflag=rdleflag=0;
	while(1)
		{
		if(_bios_keybrd(_KEYBRD_READY))
			{
			kc=_bios_keybrd(_KEYBRD_READ);
			if((kc&0xff)==('C'&31))
				quit();
			else if((kc&0xff)==('D'&31))
				{
				printf("^D");
				if(!dleflag)
					sendchar(0x10);
				sendchar(0x03);
				while(!(inp(basereg+STATREG)&TXSHMTMASK));
				scan(); /* Eat whatever, maybe */
				cleanup(0);
				exit(128); /* at least it matches VOICERX */
				}
			}
		sendchar(c=getbyte());
		if(c==0x10)
			dleflag=!dleflag;
		else if(dleflag&(c==0x03))
			break;
		else
			dleflag=0;
		if(follow!=index)
			{
			c=buf[follow++];
			if(follow>=TBUFSIZ)
				follow=0;
			if(c==0x10)
				rdleflag=1;
			else if(rdleflag)
				{
				putch(c);
				rdleflag=0;
				for(i=0;i<nchecks;i++)
					if(c==checks[i])
						{
						sendchar(0x00);
						sendchar(0x10);
						sendchar(0x18);
						scan();
						while(!(inp(basereg+STATREG)&TXSHMTMASK));
						cleanup(0);
						exit(i);
						}
				}
			}
		}
	sendchar(0x00);
	sendchar(0x10);
	sendchar(0x03);
	while(!(inp(basereg+STATREG)&TXSHMTMASK));
	scan(); /* Wait for VCON or whatever */
	cleanup(0);
	exit(128);
	}
