/*	Copyright (C) 1992, 1993 Peter Edward Cann, all rights reserved.
 */

#include<stdio.h>
#include<bios.h>
#include<dos.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<signal.h>
#include"port.h"

#define NAK 21
#define ACK 6
#define SOH 1
#define EOT 4
#define CAN 24

unsigned long tick;

void (interrupt far *oldtick)();

void interrupt far tickhndl()
	{
	tick++;
	}

sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)))
		if(_bios_keybrd(_KEYBRD_READY))
			if((_bios_keybrd(_KEYBRD_READ)&0xff)==0x03)
				quit();
	outp(basereg, c);
	}

int follow;

int rcharto(ticks)
	int ticks;
	{
	int c;
	tick=0L;
	while(1)
		{
		if(_bios_keybrd(_KEYBRD_READY))
			if((_bios_keybrd(_KEYBRD_READ)&0xff)==0x03)
				quit();
		if(tick>ticks)
			return(-1); /* NOTE: This is an INT!!! */
		if(follow!=index)
			{
			c=buf[follow++];
			if(follow>=TBUFSIZ)
				follow=0;
			return(c);
			}
		}
	}


unsigned char block[128];

sblock(blockn)
	unsigned char blockn;
	{
	int i;
	unsigned char checksum;
	checksum=0;
	sendchar(SOH);
	sendchar(blockn);
	sendchar((blockn^0xff)&0xff);
	for(i=0;i<128;++i)
		{
		sendchar(block[i]);
		checksum+=block[i];
		}
	sendchar(checksum);
	}

quit()
	{
	cleanup(0);
	_dos_setvect(0x1c, oldtick);
	exit(99);
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	int i, j, infd, ok, c;
	unsigned char blocknum;
	long nbytes;
	index=follow=0;
	printf("Copyright (C) 1992 Peter Edward Cann, all rights reserved.\n");
	printf("xmodem checksum send of %s.\n", argv[4]);
	if(argc!=5)
		{
		printf("USAGE: xmodemr <comnum> <bps> <stopbits> <file pathname>\n");
		exit(1);
		}
	if((infd=open(argv[4], O_RDONLY|O_BINARY))==-1)
		{
		printf("Error opening file %s.\n", argv[4]);
		exit(2);
		}
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	databits='8';
	parity='n';
	stopbits=argv[3][0];
	setport();
	readset();
	oldtick=_dos_getvect(0x1c);
	signal(SIGINT, quit);
	_dos_setvect(0x1c, tickhndl);
	setup();
	nbytes=0;
	for(i=0;;++i)
		{
		if((c=rcharto(100))==CAN)
			{
			c=rcharto(100);
			if(c==CAN)
				{
				printf("Received two consecutive CANcel codes (^X).\n");
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(40);
				}
			}
		if(c=='C')
			break;
		if(i>=20)
			{
			printf("No C in 20 five-second tries.\n");
			cleanup(0);
			_dos_setvect(0x1c, oldtick);
			exit(10);
			}
		}
	blocknum=1;
	while(1)
		{
		if((j=read(infd, block, 128))==0)
			{
			printf("End of file.\n");
			sendchar(EOT);
			do
				{
				c=rcharto(300);
				if(c==CAN)
					c=rcharto(300);
				}
			while((c!=ACK)&&(c!=NAK)&&(c!=CAN)&&(c!=-1));
			if(c==-1)
				{
				printf("\nTimeout.\n");
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(30);
				}
			else if(c==NAK)
				{
				printf("\nEOT NAKed.\n");
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(13);
				}
			else if(c==CAN)
				{
				printf("\nReceiver sent two CANcel codes (^X).\n");
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(31);
				}
			else
				{
				printf("\nSuccessful.\n");
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(0);	
				}
			}
		for(c=j;c<128;c++)
			block[c]=26;
		i=0;
		do
			{
			printf("\nSending block %d. ", blocknum);
			sblock(blocknum);
			do
				{
				c=rcharto(200);
				printf("%02x ", c);
				if(c==CAN)
					{
					c=rcharto(200);
					printf("%02x ", c);
					}
				}
			while((c!=ACK)&&(c!=NAK)&&(c!=CAN)&&(c!=-1));
			}
		while((c==NAK)&&(i++<10));
		if(c!=ACK)
			if(c==NAK)
				{
				printf("\nRetry limit exceeded.\n");
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(14);
				}
			else if(c==-1)
				{
				printf("\nTimeout.\n");
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(33);
				}
			else
				{
				printf("\nReceiver sent two CANcel codes (^X).\n");
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(11);
				}
		nbytes+=128;
		printf(" Successful. Bytes so far: %ld", nbytes);
		blocknum++;
		}
	printf("Programming error; fell through end; see code.\n");
	cleanup(0);
	_dos_setvect(0x1c, oldtick);
	exit(12);
	}
