'Menusys / Menulib Shell
'
'Use this program as a shell for writing your
'own programs that incorporate Menusys and Menulib
'routines.  It should be compilable as-is, however,
'providing limited functionality as a demonstration.

'---------------------
'Tell PB to link in
'necessary routines
'---------------------

$compile exe
$link "menusys.pbu"
$link "menulib.pbu"
$float procedure

'----------------------------
'Declare Public Variables for
'MENUSYS and MENULIB - include
'in ALL programs that use
'Menusys/Menulib routines.
'----------------------------

public mouse%, segment&        'Mouse Flag and Video Segment
public msx%, msy%, lb%, rb%    'Mouse X and Y pos, Left/Right Buttons
public topcount%, bottomcount% 'Top/Bottom Menu Counts
public mainclr%, mainbckg%     '"Main" Screen Colors
public clr%, bckg%             'Temporary (Current) Colors
public clr1%, clr2%, clr3%     'Alternate Character Colors
public bckg1%, bckg2%, bckg3%  'Alternate Background Colors
public helpfn$, progname$      'Help File and Program Name
			       'Help filename should contain path as
			       'well as main filename.  Leave helpfn$
			       'undefined for no help.

'---------------------
'Check Mouse and Video -
'This sets the PUBLIC
'variables declared
'in the last section to
'specific values.
'---------------------

CALL mhardreset(ms%, nb%)
IF ms% = 0 THEN mouse% = 0 ELSE mouse% = 1
segment& = vidseg&
IF segment& = &HB000 THEN
	mainclr% = 7: mainbckg% = 0
	clr1% = 0: clr2% = 15
	clr3% = 0
	bckg1% = 7: bckg2% = 7
	bckg3% = 7
ELSE
	mainclr% = 15: mainbckg% = 1
	clr1% = 0: clr2% = 15
	clr3% = 8
	bckg1% = 7: bckg2% = 7
	bckg3% = 3
END IF


'--------------
'Read Menu Data
'--------------

topcount% = 2: bottomcount% = 4  'Number of TOP (bar) and
					     'BOTTOM (box) menus.

REDIM menu$(0 : topcount%, 1 : bottomcount%)
REDIM help$(1 : topcount%, 1 : bottomcount%)
REDIM menutype%(1 : topcount%, 1 : bottomcount%)
REDIM menucount%(1 : topcount%)

RESTORE menudatapoint

FOR t% = 1 TO topcount%
	READ menu$(0, t%)
NEXT t%

FOR t% = 1 TO topcount%
	READ menucount%(t%)
	FOR u% = 1 TO menucount%(t%)
		READ menu$(t%, u%)
	NEXT u%
NEXT t%

FOR t% = 1 TO topcount%
	FOR u% = 1 TO menucount%(t%)
	READ help$(t%, u%)
	NEXT u%
NEXT t%


'---------------------------------
'Substitute the following with
'your own program.
'---------------------------------

color mainclr%, mainbckg%  'Main Screen Colors
cls
CALL MENUSYS(menu$(), help$(), menucount%(), menutype%(), topchoice%, bottomchoice%)
locate 10,1
print "Top Menu: ";topchoice%
print "Bottom Menu: ";bottomchoice%
END


'---------------------
'Menu Data Starts Here
'---------------------

menudatapoint:

'--------------------------------------------
'TOP MENU BAR SELECTION TITLES (Enclose The
'Hot-Key Letter to Highlight in Parentheses).
'Set topcount% to number of top menu entries
'before reading (2 entries, in this case.)

DATA "  (F)ile", "  (E)dit"

'--------------------------------------------
'BOX MENU TITLES (For each box menu: Number of Entries
'followed by the text for the entries.  Use "-" for horiz.
'line.  Set bottomcount% to MAXIMUM number of bottom menu
'entries (should be >= topcount% - quirk of the program).
'bottomcount% = 3, in this case.

DATA 3,(N)ew Program, "-", (O)pen Program
DATA 2, (U)ndo, (C)ut

'--------------------------------------------
'BOX MENU HELP
'Must correspond to (be in the same order and
'the same quantity as) the Box Menu Titles, including
'the "-" corresponding to the "-" entries in the box
'menu titles.

DATA Removes currently loaded program from memory, "-", Loads new program into memory
DATA Restores current edited line to its original condition, Deletes selected text and copies it to buffer
