#include <process.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <math.h>

int total_frames=0;

struct window
{
	double xmin;
	double xmax;
	double ymin;
	double ymax;
	int s;                  //steps for this frame to the next
	int m;                  //maxiter for this frame to the next
};

void doleg(window *,window *, char *, int, int);  //first,last,pal_name,rot_flag,rot_speed
void rotate(char *, int);
window *load_script(int *, int *, int *, char *);
char *set_rotate(int *, int *);

/* ************************************* */
int main()
{
window *script;  
int sp=0;
char pal_name[80];
int rot_speed, rot_flag;
printf("\n\nMAKEFILM - A fractal zoom generator\n");
printf("----------==============-----------\n\n");
script=load_script(&sp, &rot_flag, &rot_speed, pal_name);
for (int count=0; count<sp-1; count++) //last point serves only as endpoint-no leg genereated for it
	doleg(script+count,script+count+1,pal_name,rot_flag,rot_speed);
printf("\nThanks for playing!");
return EXIT_SUCCESS;
}



/* ************************************************ */
void doleg(window *first, window *last, char *pal_name, int rot_flag, int rot_speed)
{
double s,xscale,yscale,xcutoff,ycutoff,xc1,xc2,yc2,yc1,xoffset,yoffset,xcurr, ycurr;
window current;
FILE *fp;

xc1=last->xmin - first->xmin; //note this is probably negative
xc2=last->xmax - first->xmax;
yc1=last->ymin - first->ymin; // note this is probably negative
yc2=last->ymax - first->ymax;

xscale = (last->xmax - last->xmin)/(first->xmax - first->xmin);
yscale = (last->ymax - last->ymin)/(first->ymax - first->ymin);
xcutoff = log(xscale);
ycutoff = log(yscale);
int n;
for (s = n = 0; n < first->s; n += 1) {
	xcurr = exp(s*xcutoff); //fraction of orig box to use
	ycurr = exp(s*ycutoff); //?scale is NEGATIVE?!
	current.xmin = first->xmin;
	current.xmax = first->xmin+xcurr*(first->xmax - first->xmin);
	current.ymin = first->ymin;
	current.ymax = first->ymin+ycurr*(first->ymax - first->ymin);
		// Set mins to firstmin and max to min+size
	
	if (xscale==1) xoffset=s*xc1; //need if to prevent div by 0 (on next line)
	  else xoffset=(1-xcurr)/(1-xscale)*xc1;
	if (yscale==1) yoffset=s*yc1;
	  else yoffset=(1-ycurr)/(1-yscale)*yc1;
		// Figure out how far in to move the coordinates (all 4)

	current.xmin += xoffset;
	current.xmax += xoffset;
	current.ymin += yoffset;
	current.ymax += yoffset;
		// Move coordinates in by that amount

//      ****************************  Create Respfile
	if ((fp = fopen("respfile.par","w")) == NULL) {
		fprintf(stderr,"Can't open RESPFILE.PAR");
		exit(1);
		}
	int count=0;
	int dummy = first->m+s*(last->m - first->m);
	fprintf(fp,"MAXITER=%d\n",dummy);
	fprintf(fp,"CORNERS=%.16f/%.16f/%.16f/%.16f\n",
		current.xmin,current.xmax,current.ymin,current.ymax);
	fclose(fp);
	
	char *argv[5]; char buffer[50];
	sprintf (buffer,"%s",pal_name);
	argv[0]=getenv("COMSPEC"); argv[1]="/c"; argv[2]="addit.bat"; argv[3]=buffer; argv[4]=NULL;
	if (spawnvp(0, getenv("COMSPEC"), argv) != 0) {
		fprintf(stderr,"Error calling ADDIT.BAT!! Exiting...");
		exit(1);
		}
	printf("Finished with frame: %d.\n",++total_frames);
	if (rot_flag) for (count=0; count<rot_speed; count++) rotate(pal_name,rot_flag);
	s += (double)1/(double)first->s;
	}
}




void rotate(char *pal_name,int rot_flag)
{
int cr,cb,cg;
int tr,tb,tg;
int r[256],g[256],b[256];
char in_line[50];
FILE *fp;

srand(clock());

if ((fp=fopen("rotate.dat","r"))==NULL) {
	fclose(fp);
	if ((fp=fopen("rotate.dat","w"))==NULL) printf("Can't open ROTATE.DAT for write");
	fprintf(fp,"%d,%d,%d",0,0,0);
	fclose(fp);
        if ((fp=fopen("rotate.dat","r"))==NULL) printf("Can't open ROTATE.DAT for read");
}	//file contains target values for red, green and blue
fscanf(fp,"%d,%d,%d",&tr, &tb, &tg);
fclose(fp);

if ((fp=fopen(pal_name,"r"))==NULL) {printf("Can't find %s",pal_name); return;}

printf("Rotating %s...\n",pal_name);
fgets(in_line,40,fp);
sscanf(in_line,"%d %d %d",r,g,b);
fgets(in_line,40,fp);
if (rot_flag == 2) sscanf(in_line,"%d %d %d",r+255,g+255,b+255);
for (int count=1; count<255; count++) {
	fgets(in_line,40,fp);
	sscanf(in_line,"%d %d %d\n",r+count,g+count,b+count);
	}
fclose(fp);
cr = r[254]; cg = g[254]; cb = b[254];
if (cr==tr) {
	if (tb>128 && tg>128) tr = rand()%128;
	else tr = rand()%256;
	}
if (cb==tb) {
	if (tg>128 && tr>128) tb = rand()%128;
	else tb = rand()%256;
	}
if (cg==tg) {
	if (tb>128 && tr>128) tg = rand()%128;
	else tg = rand()%256;
	}
if (cg>tg) cg--;
else if (cg<tg) cg++;
if (cb>tb) cb--;
else if (cb<tb) cb++;
if (cr>tr) cr--;
else if (cr<tr) cr++;
if (rot_flag == 1) {
	r[255] = cr;
	g[255] = cg;
	b[255] = cb;
	}
if ((fp=fopen(pal_name,"w"))==NULL) printf("can't write %s",pal_name);
for (count=0; count<256; count++)
	fprintf(fp,"%3d %3d %3d\n",r[count],g[count],b[count]);
fclose(fp);
if ((fp=fopen("rotate.dat","w"))==NULL) printf("Can't open ROTATE.DAT for write");
fprintf(fp,"%d,%d,%d",tr,tb,tg);
fclose(fp);
}

window *load_script(int *sp, int *rot_flag, int *rot_speed, char *pal_name)
{
window *script;
FILE *sf;
if ((sf= fopen("Internal.scr","r"))==NULL) {
	fprintf(stderr, "Ooops, no internal.scr\n"); exit(2);
	}
fgets(pal_name, 79, sf); char *pos=strchr(pal_name, '\n'); if (pos) *pos=0;
char tmp;
fscanf(sf,"%c\n",&tmp);
switch (tmp) {
	case 'N':  *rot_flag=0; break;
	case 'S':  *rot_flag=1; break;
	case 'R':  *rot_flag=2; break;
	};
fscanf(sf,"%d\n",rot_speed);
fscanf(sf,"%d\n",sp);
script = new window[*sp];
for (int count=0; count<*sp; count++) {
	fscanf(sf,"%lf,%lf\n",&(script[count].xmin),&(script[count].ymin));
	fscanf(sf,"%lf,%lf\n",&(script[count].xmax),&(script[count].ymax));
	fscanf(sf,"%d\n",&(script[count].s));
	fscanf(sf,"%d\n",&(script[count].m));
	}
fclose(sf);
return script;
}
