'--- MLIB version-specific definitions for Visual Basic

'$INCLUDE: 'vbdos.bi'

'--------------------



' Play/R interface module.
' Copyright 1992, Kevin Weiner, All rights reserved.

'$INCLUDE: 'mlib.bi'

DECLARE SUB CallPlayR (fcn%)
DECLARE FUNCTION CheckRes% ()

COMMON SHARED /mlibx/ param AS STRING, idnum AS INTEGER

CONST playrid$ = "Play/R  "

CONST tessmpx = 21587

CONST fcnPause = 0
CONST fcnPlay = 1
CONST fcnPopup = 2
CONST fcnRewind = 3
CONST fcnLoadPlay = 4
CONST fcnPlayStat = 5
CONST fcnLoadStat = 6
CONST fcnDoneStat = 7
CONST fcnLoad = 8
CONST fcnQuiet = 9
CONST fcnPopEna = 10
CONST fcnVolume = 11
CONST fcnReset = 12
CONST fcnTimeMode = 13
CONST fcnGetChan = 14
CONST fcnSetChan = 15
CONST fcnSetPos = 16
CONST fcnSkipSong = 17
CONST fcnLoopMode = 18

CONST fcnGetName% = 20
CONST fcnSendShort% = 21
CONST fcnSendLong% = 22
CONST fcnCheckInp% = 23
CONST fcnGetInput% = 24
CONST fcnGetTime% = 25
CONST fcnGetCID% = 26
CONST fcnGetEntry% = 27

CONST fcnRemove% = 99


SUB CallPlayR (fcn AS INTEGER)

DIM reg AS RegTypeX

  MID$(param, 1, 1) = CHR$(fcn)
  reg.ax = tessmpx
  reg.es = SSEG(param)     ' VB
  reg.di = SADD(param)
  reg.cx = idnum
  reg.bx = 32
  CALL INTERRUPTX(47, reg, reg)

END SUB

FUNCTION CheckRes%

DIM reg AS RegTypeX

  id$ = playrid$
  reg.ax = tessmpx
  reg.ds = SSEG(id$)    'VB
  reg.si = SADD(id$)
  reg.cx = 0
  reg.bx = 0
  reg.es = -1
  CALL INTERRUPTX(47, reg, reg)
  IF reg.ax = -1 THEN
	idnum = reg.cx
  ELSE
	idnum = -1
  END IF
  CheckRes% = idnum

END FUNCTION

SUB mfContinue

  CALL CallPlayR(fcnPlay)

END SUB

SUB mfFileStat (stat AS INTEGER, filename AS STRING)

  CALL CallPlayR(fcnLoadStat)
  stat% = ASC(MID$(param, 1, 1))
  i% = 2
  c$ = MID$(param, 2, 1)
  filename = ""
  DO WHILE ASC(c$) <> 0
	filename = filename + c$
	i% = i% + 1
	c$ = MID$(param, i%, 1)
  LOOP

END SUB

SUB mfGetChan (datatype AS INTEGER, chan() AS INTEGER)

  MID$(param, 2, 1) = CHR$(datatype)
  CALL CallPlayR(fcnGetChan)
  FOR i% = 1 TO 16
	chan(i%) = ASC(MID$(param, i% + 2, 1))
        if chan(i%) > 127 then
          chan(i%) = chan(i%) - 256
        end if
  NEXT i%

END SUB

SUB mfInit

  param = SPACE$(64)
  midiDriverLoaded = CheckRes >= 0
  IF midiDriverLoaded THEN
	CALL CallPlayR(fcnGetCID)
	MID = ASC(MID$(param, 2, 1))
  ELSE
	MID = 0
  END IF

END SUB

FUNCTION mfLoad% (filename$)

  param = " " + filename$ + CHR$(0)
  CALL CallPlayR(fcnLoad)
  mfLoad% = ASC(MID$(param, 1, 1))

END FUNCTION

SUB mfLoopMode (n AS INTEGER)

  MID$(param, 2, 1) = CHR$(n%)
  CALL CallPlayR(fcnLoopMode)

END SUB

SUB mfPause

  CALL CallPlayR(fcnPause)

END SUB

FUNCTION mfPlay% (filename AS STRING)

  param = " " + filename + CHR$(0)
  CALL CallPlayR(fcnLoadPlay)
  mfPlay% = ASC(MID$(param, 1, 1))

END FUNCTION

SUB mfPopEnable (stat AS INTEGER)

  MID$(param, 2, 1) = CHR$(stat)
  CALL CallPlayR(fcnPopEna)

END SUB

SUB mfPopup

  CALL CallPlayR(fcnPopup)

END SUB

SUB mfQuiet

  CALL CallPlayR(fcnQuiet)

END SUB

SUB mfRewind

  CALL CallPlayR(fcnRewind)

END SUB

SUB mfSetChan (datatype AS INTEGER, chan() AS INTEGER)

  MID$(param, 2, 1) = CHR$(datatype)
  FOR i% = 1 TO 16
	MID$(param, i% + 2, 1) = CHR$(chan(i%) and 255)
  NEXT i%
  CALL CallPlayR(fcnSetChan)

END SUB

SUB mfSetPos (time AS LONG)

  t& = time
  FOR i% = 2 TO 5
	MID$(param, i%, 1) = CHR$(t& AND 255)
	t& = t& \ 256
  NEXT i%
  CALL CallPlayR(fcnSetPos)

END SUB

SUB mfSkipSong (n AS INTEGER)

  MID$(param, 2, 1) = CHR$(n)
  CALL CallPlayR(fcnSkipSong)

END SUB

SUB mfSongStat (playing AS INTEGER, done AS INTEGER, position AS LONG, songcount AS INTEGER, cursong AS INTEGER)

  CALL CallPlayR(fcnPlayStat)
  playing = ASC(MID$(param, 1, 1))
  done = ASC(MID$(param, 2, 1))
  temp& = 0
  FOR i% = 3 TO 6
	temp& = temp& * 256 + ASC(MID$(param, i%, 1))
  NEXT i%
  songcount = ASC(MID$(param, 7, 1))
  cursong = ASC(MID$(param, 8, 1))

END SUB

SUB mfTimeMode (mode AS INTEGER)

  MID$(param, 2, 1) = CHR$(mode)
  CALL CallPlayR(fcnTimeMode)

END SUB

SUB mfVolume (adjust AS INTEGER)

  MID$(param, 2, 1) = CHR$(adjust AND 255)
  CALL CallPlayR(fcnVolume)

END SUB

FUNCTION midiDevName% (dev AS INTEGER, devname AS STRING, devdesc AS STRING)

  MID$(param, 2, 1) = CHR$(dev)
  CALL CallPlayR(fcnGetName)
  d% = ASC(MID$(param, 2, 1))
  IF d% = 0 THEN
	devname = ""
	devdesc = ""
  ELSE
	devname = MID$(param, 3, 3)
	devdesc = MID$(param, 6, 20)
  END IF
  midiDevName% = d%

END FUNCTION

FUNCTION midiGetBuffer% (dev AS INTEGER, buf AS STRING, max AS INTEGER)

  MID$(param, 2, 1) = CHR$(dev)               'Device num
  MID$(param, 3, 1) = CHR$(max AND 255)       'Low byte of buf max
  MID$(param, 4, 1) = CHR$(max \ 256)         'High byte of buf max
  bofs% = SADD(buf)
  MID$(param, 5, 1) = CHR$(bofs% AND 255)      'Buffer offset
  MID$(param, 6, 1) = CHR$(bofs% \ 256)
  bseg% = SSEG(buf)     'VB
  MID$(param, 7, 1) = CHR$(bseg% AND 255)      'Buffer segment
  MID$(param, 8, 1) = CHR$(bseg% \ 256)

  CallPlayR (fcnGetInput)

  midiGetBuffer% = ASC(MID$(param, 10, 1)) * 256 + ASC(MID$(param, 9, 1))
 
END FUNCTION

FUNCTION midiInputReady% (dev AS INTEGER)

  MID$(param, 2, 1) = CHR$(dev)
  CALL CallPlayR(fcnCheckInp)
  midiInputReady% = (ASC(MID$(param, 3, 1)) = 1)

END FUNCTION

SUB midiPutBuffer (dev AS INTEGER, buf AS STRING, datalen AS INTEGER)

  MID$(param, 2, 1) = CHR$(dev)               'Device num
  MID$(param, 3, 1) = CHR$(datalen AND 255)   'Low byte of length
  MID$(param, 4, 1) = CHR$(datalen \ 256)     'High byte of length
  bofs% = SADD(buf)
  MID$(param, 5, 1) = CHR$(bofs% AND 255)     'Buffer offset
  MID$(param, 6, 1) = CHR$(bofs% \ 256)
  bseg% = SSEG(buf)     'VB
  MID$(param, 7, 1) = CHR$(bseg% AND 255)      'Buffer segment
  MID$(param, 8, 1) = CHR$(bseg% \ 256)
  FOR i% = 1 TO 4                              'Reserved space
	MID$(param, i% + 8, 1) = CHR$(0)
  NEXT i%

  CallPlayR (fcnSendLong)

END SUB

SUB midiPutShort (dev AS INTEGER, b1 AS INTEGER, b2 AS INTEGER, b3 AS INTEGER)

  MID$(param, 2, 1) = CHR$(dev)

  MID$(param, 4, 1) = CHR$(b1)
  IF b2 < 0 THEN
	dlen% = 1
  ELSE
	MID$(param, 5, 1) = CHR$(b2)
	IF b3 < 0 THEN
	  dlen% = 2
	ELSE
	  MID$(param, 6, 1) = CHR$(b3)
	  dlen% = 3
	END IF
  END IF
 
  MID$(param, 3, 1) = CHR$(dlen%)
 
  CALL CallPlayR(fcnSendShort)

END SUB

SUB midiRemove

  CALL CallPlayR(fcnRemove)

END SUB

SUB midiReset (dev AS INTEGER)

  MID$(param, 2, 1) = CHR$(dev)
  CALL CallPlayR(fcnReset)

END SUB

FUNCTION msTimer&
 
  CALL CallPlayR(fcnGetTime)
  temp& = 0
  FOR i% = 2 TO 5
	temp& = temp& * 256 + ASC(MID$(param, i%, 1))
  NEXT i%
  msTimer& = temp&

END FUNCTION

