/*****************************************************************************/
/*                                                                           */
/*                 Always remember - The Code is Obvious !!!                 */
/*                                                                           */
/*                                                                           */
/* Who  : Michael "Maxwell" Lamertz, CIS: 100341,76                          */
/* What : XWindows-display-module for POVRay 2.0                             */
/* When : Somewhere January 1994 - 29th of April 1994                        */
/* Why  : Problems running the distributed version of xwindows.c and fun     */
/*        trying it myself.                                                  */
/*                                                                           */
/* Dear POVRAY-People, there are no credits or copyrights in here, because   */
/* this module was  totally private on my machine until i joined CIS a month */
/* ago. I hope this module is somewhat portable and fits your needs.         */
/* Feel free to use or modify it as you please.                              */
/*                                                                           */
/* I use the externals DisplayFormat,                                        */
/*                     PaletteOption,                                        */
/*                     Options,                                              */
/*                     VerboseFormat,                                        */
/*                     and Output_File_Name                                  */
/* DisplayFormat = d0 : Greyscale palette 256 entries                        */
/*                      This is the default.                                 */
/*                 d1 : use 8 shades of red and green, 4 shades of blue      */
/*                      This isn't optimal for grey-coloured objects, but    */
/*                      uses all 256 available colours, what is sometimes    */
/*                      nice to have.                                        */
/*                 d2 : 6 shades of red, green and blue - 216 colours        */
/*                      This palette is was also used in Allan H. Wax's hack */
/*                      to xwindows.c in the POVRay distribution.            */
/*                      I implemented it by myself when the '1' option       */
/*                      made problems with grey objects.                     */
/*                                                                           */
/* The module installs it's own colourmap so the picture is optimally dis-   */
/* played.                                                                   */
/*                                                                           */
/* When the POVRay is started with the +p option click into the pic-window   */
/* with Button-1 when finished.                                              */
/* I also made some experiments with an alarm-handler, when i saw that       */
/* plotting into the picture-bitmap and updating the window at every pixel   */
/* costs loads of time. The alarm-handler sets the DoBlit-Flag and on the    */
/* next display_plot the window is updated. *Don't* change AlarmHandler to   */
/* do the blit itself! AlarmHandler is a signal-function and therfore a pro- */
/* cess. When POVRay calls display_plot and AlarmHandler is invoked in-      */
/* between, X seems to crash. This can be tried out when doing a continued   */
/* trace, because there are many plot-operations and the chance for a con-   */
/* flict is very high. If anybody has a solution to this problem, send me    */
/* a note, because this makes it impossible to fork an update-process in     */
/* other programs too.                                                       */
/*                                                                           */
/* The problem that i couldn't solve for now is how to replace math_err.     */
/* I grep'ed math_err in the usr/include directory and no entry was found.   */
/*                                                                           */
/* I believe SIGFPE seems to be the right idea, but how do i know what type  */
/* of error occured? I would like to hear ideas to this problem too.         */
/*                                                                           */
/* During some of my debugging-sessions i wrote VerboseMsg. If any error     */
/* occurs, try using the +v option from +V2 up to +V4 until you have any     */
/* idea when the error happens.                                              */
/*                                                                           */
/* Bye for now - Michael Lamertz, 29.04.1994                                 */
/*                                                                           */
/*****************************************************************************/
/*****************************      Includes      ****************************/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "frame.h"
#include "config.h"

/*****************************      Defines       ****************************/

#define TIMEOUT 5

#define GR256  '0'
#define R8G8B4 '1'
#define R6G6B6 '2'

/*****************************     Externals      ****************************/

extern char      DisplayFormat;
extern char      PaletteOption;
extern int       Options;
extern char      VerboseFormat;
extern char      Output_File_Name[FILE_NAME_LENGTH];

/*****************************     Prototypes     ****************************/
/*****************************    Static Data     ****************************/

static char      AppName[256];

static Display  *theDisplay;
static int       theScreen;
static Window    theWindow;
static GC        theGC;
static Pixmap    thePixmap;
static Colormap  theCMap;

static int       PicWdt;
static int       LastColl, CurrColl;
static int       LastLine, CurrLine;

static struct sigaction OldAlarm;
static int       Done=0;
static int       DoBlit=0;

static int       ExitLevel=0;

/*****************************    Global Data     ****************************/
/*****************************  Static Functions  ****************************/

static void VerboseMsg(int level, char *fmt, ...)
{
  va_list
    *ap;

  if ((Options & VERBOSE) && VerboseFormat>=level)
    {
      va_start(ap, fmt);
      vfprintf(stderr, fmt, ap);
      va_end(ap);
    }
}

static void Cleanup(void)
{
  static int
    IsClean=0;

  if (!IsClean)
    {
      VerboseMsg('3', "Cleaning up...");

      switch(ExitLevel)		/* DON'T insert breaks here! */
	{
	case 5:
	  XFreeColormap(theDisplay, theCMap);
	case 4:
	  XFreeGC(theDisplay, theGC);
	case 3:
	  XFreePixmap(theDisplay, thePixmap);
	case 2:
	  XDestroyWindow(theDisplay, theWindow);
	case 1:
	  XCloseDisplay(theDisplay);
	case 0:
	  break;
	}
      IsClean=1;

      VerboseMsg('3', "done\n");
    }
}

static void AlarmHandler()
{
  VerboseMsg('4', "AlarmHandler update\n");

  DoBlit=1;

  if (Done)
    sigaction(SIGALRM, &OldAlarm, NULL);
  else
    alarm(TIMEOUT);
}

static void UpdateBitmap(void)
{
  VerboseMsg('4', "Blitting...");
  
  if (LastLine==CurrLine)
    {
      XCopyArea(theDisplay, thePixmap, theWindow, theGC,
		LastColl, CurrLine, CurrColl, CurrLine,
		LastColl, CurrLine);
      LastColl=CurrColl;
    }
  else
    {
      XCopyArea(theDisplay, thePixmap, theWindow, theGC,
		0, LastLine, PicWdt, CurrLine,
		0, LastLine);
      LastLine=CurrLine;
    }

  VerboseMsg('4', "done\n");
}

static int HandleEvents(int ExitAllowed)
{
  int
    res=0;

  while (XPending(theDisplay)>0)
    {
      XEvent
	theEvent;

      XNextEvent(theDisplay, &theEvent);
      switch(theEvent.type)
	{
	case Expose:
	  VerboseMsg('4', "Expose-event...");

	  XCopyArea(theDisplay,
		    thePixmap, theWindow, theGC,
		    theEvent.xexpose.x, theEvent.xexpose.y,
		    theEvent.xexpose.width, theEvent.xexpose.height,
		    theEvent.xexpose.x, theEvent.xexpose.y);
	  XFlushGC(theDisplay, theGC);

	  VerboseMsg('4', "done\n");
	  break;

	case ButtonPress:
	  if (ExitAllowed && 
	      theEvent.xbutton.button==Button1)
	    res=1;
	  break;
	  
	}
    }

  return res;
}

static int GenColormap(void)
{
  int
    r, g, b,
    idx,
    res=0;

  XColor
    colfld[256];

  VerboseMsg('3', "Creating palette...");
  
  if ((theCMap=XCreateColormap(theDisplay, theWindow,
			       DefaultVisual(theDisplay, theScreen),
			       AllocAll))==0)
    fprintf(stderr, "Cannot allocate colourmap\n");

  switch(DisplayFormat)
    {
    case R8G8B4:
      VerboseMsg('4', "R8G8B4...");
      
      idx=0;
      for (r=0; r<8; r++) /* 3 bits red */
	for (g=0; g<8; g++) /* 3 bits green */
	  for (b=0; b<4; b++) /* 2 bits blue */
	    {
	      colfld[idx].flags=DoRed | DoGreen | DoBlue;

	      colfld[idx].red  =(r<<5)<<8;
	      colfld[idx].green=(g<<5)<<8;
	      colfld[idx].blue =(b<<6)<<8;

	      colfld[idx].pixel=idx++;
	    }
      break;

    case R6G6B6:
      VerboseMsg('4', "R6G6B6...");
      
      idx=0;
      for (r=0; r<6; r++)	/* 6 shades red */
	for (g=0; g<6; g++)	/* 6 shades green */
	  for (b=0; b<6; b++)	/* 6 shades blue */
	    {
	      colfld[idx].flags=DoRed | DoGreen | DoBlue;
	      colfld[idx].red  =(255*r/5)<<8;
	      colfld[idx].green=(255*g/5)<<8;
	      colfld[idx].blue =(255*b/5)<<8;
	      colfld[idx].pixel=idx++;
	    }
      break;
      
    case GR256:
    default:
      VerboseMsg('4', "GR256");
      
      idx=0;
      for (idx=0; idx<256; idx++)
	{
	  colfld[idx].flags=DoRed | DoGreen | DoBlue;

	  colfld[idx].red  =idx<<8;
	  colfld[idx].green=idx<<8;
	  colfld[idx].blue =idx<<8;

	  colfld[idx].pixel=idx;
	}
      break;
    }
  
  if (XStoreColors(theDisplay, theCMap, colfld, idx)==0)
    res=1;
  
  VerboseMsg('3', "done\n");
  return res;
}

/*****************************  Global Functions  ****************************/

void unix_init_povray PARAMS ((void))
{
  VerboseMsg('1', "Hello, world\n");
}

int matherr (x)
     struct libm_exception *x;
{
#ifdef 0
  switch(x->type) 
    {
    case DOMAIN:
    case OVERFLOW:
      x->retval = 1.0e17;
      break;
    case SING:
    case UNDERFLOW:
      x->retval = 0.0;
      break;

    default:
      break;
    }
#endif
  return(1);
}

void display_init (int wdt, int hgt)
{
  XGCValues
    theGCValues;
  
  XSetWindowAttributes
    theAttribs;

  XSizeHints
    theSizeHints;

  long
    theBlackPixel,
    theWhitePixel;

  struct sigaction
    alarminfo;

  VerboseMsg('3', "display_init...\n");
  
  ExitLevel=0;
  
  VerboseMsg('4', "still alive...\n");
  atexit(Cleanup);

  VerboseMsg('4', "XOpenDisplay...\n");
  if ((theDisplay = XOpenDisplay(NULL))==NULL)
    {
      fprintf(stderr, "XOpenDisplay failed\n");
      exit(-1);
    }

  ExitLevel++;

  VerboseMsg('4', "XCreateDisplay...\n");
  theScreen=DefaultScreen(theDisplay);
  theBlackPixel=BlackPixel(theDisplay, theScreen);
  theWhitePixel=WhitePixel(theDisplay, theScreen);
  if ((theWindow=XCreateSimpleWindow(theDisplay,
				     RootWindow(theDisplay, theScreen),
				     0, 0, wdt, hgt, 1,
				     theBlackPixel, theWhitePixel))==0)
    {
      fprintf(stderr, "XCreateSimpleWindow failed\n");
      exit(-1);
    }

  ExitLevel++;

  VerboseMsg('4', "XSetWMNormalHints...\n");
  PicWdt=wdt;
  theSizeHints.flags=PSize | PMinSize | PMaxSize;
  theSizeHints.min_width =wdt;
  theSizeHints.max_width =wdt;
  theSizeHints.min_height=hgt;
  theSizeHints.max_height=hgt;
				/* Make window-sized fixed! */
  XSetWMNormalHints(theDisplay, theWindow, &theSizeHints);

  sprintf(AppName, "POVRay 2.0 - %s", Output_File_Name);
  XStoreName(theDisplay, theWindow, AppName);

  VerboseMsg('4', "XCreatePixmap...\n");
  if ((thePixmap=XCreatePixmap(theDisplay,
			       RootWindow(theDisplay, theScreen),
			       wdt, hgt,
			       DefaultDepth(theDisplay, theScreen)))==0)
    {
      fprintf(stderr, "XCreatePixmap failed\n");
      exit(-1);
    }

  ExitLevel++;

  VerboseMsg('4', "XCreateGC...\n");
  theGCValues.foreground=theWhitePixel;
  theGCValues.background=theBlackPixel;
  theGCValues.function=GXcopy;
  if ((theGC=XCreateGC(theDisplay, thePixmap,
		       GCForeground |
		       GCBackground |
		       GCFunction, &theGCValues))==0)
    {
      fprintf(stderr, "XCreateGC failed\n");
      exit(-1);
    }

  ExitLevel++;

  XSelectInput(theDisplay, theWindow, ButtonPressMask | ExposureMask);

  VerboseMsg('4', "GenColormap...\n");
  if (GenColormap()!=0)
    {
      fprintf(stderr, "GenColormap failed\n");
      exit(-1);
    }

  ExitLevel++;
  
  VerboseMsg('4', "install AlarmHandler...\n");
  alarminfo.sa_handler=AlarmHandler;
  alarminfo.sa_mask=0;
  alarminfo.sa_flags=0;
  if (sigaction(SIGALRM, &alarminfo, &OldAlarm)!=0)
    {
      fprintf(stderr, "Alarmhandler-installation failled\n");
      exit(-1);
    }

  theAttribs.colormap=theCMap;
  XChangeWindowAttributes(theDisplay, theWindow, CWColormap, &theAttribs);

  XSetForeground(theDisplay, theGC, 0);
  XFillRectangle(theDisplay, thePixmap, theGC, 0, 0, wdt, hgt);
  XMapWindow(theDisplay, theWindow);
  XFlush(theDisplay);

  LastLine=CurrLine=0;
  alarm(TIMEOUT);
  VerboseMsg('4', "display_init done\n");
}

void display_plot (int x, int y,
		   unsigned char Red,
		   unsigned char Green,
		   unsigned char Blue)
{
  int
    ridx, gidx, bidx,
    cidx;

  VerboseMsg('5', "Plotting...");
  
  switch(DisplayFormat)		/* See GenPalette for info */
    {
    case R8G8B4:
      ridx=Red  >>5;
      gidx=Green>>5;
      bidx=Blue >>6;
      cidx=(ridx<<5)+(gidx<<2)+bidx;
      break;

    case R6G6B6:
      ridx=5*Red  /255;
      gidx=5*Green/255;
      bidx=5*Blue /255;
      cidx=36*ridx+6*gidx+bidx;
      break;

    case GR256:
    default:
      if (PaletteOption==GREY)
	cidx=Red;
      else
	cidx=(Red*30+Green*59+Blue*11)/100;
      break;
    }
  
  VerboseMsg('5', "CIDX=%x...", cidx);
  XSetForeground(theDisplay, theGC, cidx);
  XDrawPoint(theDisplay, thePixmap, theGC, x, y);

  CurrColl=x;
  CurrLine=y;

  if (DoBlit)			/* Update window on timeout */
    {
      VerboseMsg('5', "Blitting...");
      
      UpdateBitmap();
      DoBlit=0;
    }

  HandleEvents(0);		/* Cleanup any pending events */

  VerboseMsg('5', "done\n");
}

void display_finished ()
{
  VerboseMsg('3', "display_finished...");

  UpdateBitmap();		/* Do last update of picture */
  Done=1;			/* Switch alarm-handler off */

  if (Options & PROMPTEXIT)	
    while (!HandleEvents(1));	/* Wait for mouse-button-1 */

  VerboseMsg('3', "done\n");
}

void display_close ()
{
  Cleanup();
}

/*****************************************************************************/
