/*
	Copyright (c) 1993, George Byrkit,
				Software Professionals Limited
				1809 Saxon Street
				Ann Arbor, MI 48103
				(313)-663-1009

				ALL RIGHTS RESERVED

	THIS FILE MAY BE INCLUDED ROYALTY-FREE in any program as long as the
	above copyright notice also appears in the text of the program executable.

	filename:	inifile.h

	purpose:	emulate windows API functions to access the ini files

	These functions are extracted from windows.h

	instructions for building:
		compile:
		link:
		other:

	change log:
	When		Version	Who		Why
	01-jan-93	1.0		ghb		created
*/

#ifndef	INIFILE_H
#define	INIFILE_H

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */

/******* Common definitions and typedefs ***********************************/

#define FAR                 _far

#define WINAPI              _far _pascal

/****** Simple types & common helper macros *********************************/

typedef int                 BOOL;
#define FALSE               0
#define TRUE                1

typedef unsigned int        UINT;

#if !defined(NOMINMAX) && !defined(__cplusplus)
#ifndef max
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif
#endif  /* NOMINMAX */

/* Types use for passing & returning polymorphic values */

/****** Common pointer types ************************************************/

#ifndef NULL
#define NULL                0
#endif

typedef char FAR*           LPSTR;
typedef const char FAR*     LPCSTR;

/* User Profile Routines */
UINT    WINAPI GetProfileInt(LPCSTR, LPCSTR, int);
int     WINAPI GetProfileString(LPCSTR, LPCSTR, LPCSTR, LPSTR, int);
BOOL    WINAPI WriteProfileString(LPCSTR, LPCSTR, LPCSTR);

UINT    WINAPI GetPrivateProfileInt(LPCSTR, LPCSTR, int, LPCSTR);
int     WINAPI GetPrivateProfileString(LPCSTR, LPCSTR, LPCSTR, LPSTR, int, LPCSTR);
BOOL    WINAPI WritePrivateProfileString(LPCSTR, LPCSTR, LPCSTR, LPCSTR);

#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */

#endif	// inifile.h
