{$R-,S-,I-,D-,T-,F+,V-,B+,N-,L+ }
{$M 1024,0,0}

program EmulATT;
uses dos;
{ Copyright 1988 University of Saskatchewan Computing Services }
{ All rights reserved                                          }


{**************************************************************************}
{ Program Name : EMULATT                                                   }
{ VERSION:       1.00c (Completed)                                         }
{ DATE:          02 February 1988                                          }
{ Author:        Kevin Lowey                                               }
{                Department of Computing Services                          }
{                Room 56 Physics Building                                  }
{                University of Saskatchewan                                }
{                Saskatoon Saskatchewan                                    }
{                S7N 0W0                                                   }
{                                                                          }
{                LOWEY@SASK.BITNET                                         }
{                ...!ihnp4!sask!lowey.uucp                                 }
{                Phone: (306) 966-4826                                     }
{                                                                          }
{ Description:                                                             }
{                                                                          }
{ This program is a memory resident (TSR) utility which makes the VAXmate  }
{ 640x400x2 graphics mode emulate the AT&T 640x400x2 graphics mode.  The   }
{ only difference between the AT&T and VAXmate is that the mode number used}
{ by the SET MODE function (Interrupt $10 function $00) and the REPORT MODE}
{ function (Interrupt $10 function $F0) is $D0 in the VAXmate and $40 in   }
{ the AT&T 6300 (Olivetti). The memory map, etc. are all identical.        }
{                                                                          }
{ This emulation allows software which supports the AT&T computer to use   }
{ the high resolution 640x400x2 mode on the VAXmate, even if the VAXmate   }
{ is not supported by the software.  Simply tell the software it is using  }
{ an AT&T graphics display.                                                }
{                                                                          }
{ This program finds an empty interrupt vector, and moves interrupt $10    }
{ into this unused vector.  It then places its own procedure (INT10HANDLER)}
{ into interrupt $10.  INT10HANDLER passes all $10 interrupt calls to the  }
{ "real" interrupt $10.  If function $00 or $F0 is called, INT10HANDLER    }
{ substitutes the VAXmate $D0 graphics mode for the AT&T $40 mode number.  }
{                                                                          }
{ This can cause problems if software expecting to see the AT&T mode number}
{ (like the AT&T graphics.com program) receives the VAXmate mode number.   }
{ Thus I also implemented the following extra functions for interrupt $10  }
{                                                                          }
{  Registers                          Description                          }
{  AX = $FF00      Signature function.  Returns $FF42 if EMULATT is loaded }
{  AX = $FF01      Makes function $F0 return the AT&T $40 mode, not $D0    }
{  AX = $FF02      Makes function $F0 return the VAXmate $D0, not $40      }
{                  This is the default setting                             }
{  AX = $FF03      Returns AX=$FF40 if ATTMODE set, AX=$FFD0 if not set    }
{                                                                          }
{ The companion program EMATTSET uses the above interrupts to change how   }
{ EMULATT behaves.                                                         }
{**************************************************************************}

var
    int10save : pointer;        {Saves a pointer to the old INT10 routine}
    regs      : registers;      {registers for INTR function}
    oldah     : byte;           {Stores AH so appropriate actions can be }
                                {taken after calling INT10               }

CONST
    newintr   : byte = $59;      {Starting interrupt to install in          }
    ATTmode   : boolean = FALSE; {True if function $0F returns AT&T mode $40}
                                 {False if function $0F returns DEC mode $D0}
    VERSION   = '1.00c';
    VERSDate  = '02 Feb. 1988';

procedure INT10HANDLER (FLAGS,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP:word);
interrupt;

begin {INT10HANDLER}
  { Process My extensions to the interrupt, function $FFxx }

  { Return signature }
  if AX = $FF00  then
    ax := $FF42 {Why 42? read Hitchiker's Guide to the Galaxy :-)}

  {Make function $0F (what mode are you in) say AT&T if applicable}
  else if AX = $FF01 then begin
    ATTMODE := TRUE;
    AX := $FFFF
  end

  {Make function $0F (what mode are you in) say VAXmate if applicable}
  else if AX = $FF02 then begin
    ATTMODE := false;
    AX := $FFFF;
  end

  else if AX = $FF03 then begin  {return current setting of ATTMODE}
    IF ATTMODE then
      AX := $FF40  {AT&T mode}
    else
      AX := $FFD0  {VAXmate mode}
  end

  { Call normal interrupt $10 routines }
  else begin

    {trap AT&T enter hires mode $40 interrupt and change to DEC's $D0}
    if ax = $0040 then begin {AT&T 640x400x2}
      regs.ax := $00D0 {Vaxmate AT&T compatible mode}
    end
    else {Don't do anything special}
      regs.aX := AX;

    {save the old function number so we can check for modification}
    {of returned parameters later}
    oldah := regs.ah;

    {Put the parameters into the registers}
    regs.bx := BX;
    regs.cx := CX;
    regs.dx := DX;
    regs.es := es;
    regs.bp := bp;

    {Call the interrupt}
    intr (newintr,regs);

    { If the function is $0F (what mode are you in), and we are in the DEC }
    { 640x200x2 mode, and the ATTMODE switch is set, then return $40, the  }
    { equivalent AT&T mode.  This is so programs which ask what mode you   }
    { are in, like GRAPHICS.COM, will operate properly.  The default is to }
    { return the DEC mode, so that DEC's GRAPHICS.COM program will work.   }

    if (ATTMODE) and (oldah = $0F) and (regs.al = $D0) then {Return AT&T}
      regs.al := $40;  {AT&T equivalent mode }

    {Move the register results back to the parameters}
    ax := regs.ax;
    bx := regs.bx;
    cx := regs.cx;
    dx := regs.dx;
  end; {else call old interrupt }
end; {INT10HANDLER}

begin {EMULATT}
  Writeln ('AT&T Graphic emulator for the Vaxmate');
  Writeln ('Version ',version,', ',versdate);
  writeln ('Copyright 1988 University of Saskatchewan');
  { Check to see if already installed }
  regs.ax := $FF00;
  intr($10,regs);
  if regs.ax = $FF42 then begin {Signature found}
    writeln ('EMULATT already installed, Aborting');
    halt(1);
  end
  else begin {install}
    {find a free interrupt}
    newintr := $5F; {first application available interrupt}
    repeat
      newintr := succ(newintr);
      getintvec(newintr,int10save);
    until byte(int10save^) = $CF; {interrupt return}

    getintvec ($10,int10save);
    setintvec (newintr,int10save);
    setintvec ($10,@int10handler);
    keep (0);
  end; {install}
end. {EmulATT}