/*
 JDDEMO.C  Demo program to test jdFLIB.LIB
 Copyright 1993 James C. Dunavant, All Rights Reserved
 Compiler: Borland C/C++ version 3.1
 Model: Large

                     = A Quick and Dirty Hack =
 This program is a very quick hack to test and demonstrate calls
 to the jdFLIB library.  Feel free to "borrow" or adapt code in
 this file for your own use. However, do not used this code as
 an example of the best way to write C code. This code was written
 very quickly and I violated many of my own rules of "good" coding
 practice.

*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include <dir.h>
#include <io.h>
#include <errno.h>
#include <bios.h>
#include "jdflib.h"

/* Static prototypes */
static near void Init(void);
static near void Demo(void);
static near void WritePath(char *path);
static near void WriteMessage(char *msg);
static near void WriteErrorMsg(char *msg);
static near void Highlight(void *item, int line, int mode, int state);
static near void ClearArea(int left, int top, int right, int bottom, int bc);
static near void DrawTitle(void);
static near void Help(void);
static near void ClearKeyboard(void);

/* static globals */
static char CurrDir[MAXPATH];
static char Dformat[] = " %-8s  %-4s    %s    %s   %9ld    %s";
static char Tformat[] = " %s%s";
static char Lformat[] = " %c:  location: %s";
static jdDLIST *DL_first;
static jdTLIST *TL_first;
static jdLLIST *LL_first;
static int Scrn[160];
static int Error[160];

int InPrint = 0;    /* Printing flag */

#define ESC   27
#define ENTER 13
#define CURSOR_UP 72
#define CURSOR_DN 80
#define CURSOR_RT 77
#define CURSOR_LT 75
#define PAGE_UP   73
#define PAGE_DN   81
#define HOME      71
#define END       79
#define DELETE    83
#define INSERT    82

#define ALT_DN    0x08

#define M_NOMODE    0
#define M_DIRECTORY 1
#define M_TREE      2
#define M_DRIVE     3

#define ON  1
#define OFF 2

/**************************************************** main ***********/
void main()
{

Init();
DrawTitle();
Demo();
textbackground(BLACK);
textcolor(LIGHTGRAY);
clrscr();
_setcursortype(_NORMALCURSOR);
cputs("This has been a demo of the jdFLIB library\r\n");
cputs("Copyright 1993 James C. Dunavant, All Rights Reserved\r\n");
exit(0);
}

static char *Title[] = {
"                              ",
"                                        ",
"                                  Library Exercise & Demo",
"                                       ",
"                       .LIB v1.0, Beta A",
"       Copyright 1993 James C. Dunavant, All Rights Reserved",
" ",
"                           Press  to continue",
"                           "};
/***> DrawTitle <*****************************************************/
/* ACTION: Draw fancy title screen                                   */
/*  INPUT: void.                                                     */
/* RETURN: void.                                                     */
/*********************************************************************/
static near void DrawTitle()
{
int c;

textcolor(LIGHTGRAY);
for(c = 0; c < 9; c++)
   {
   gotoxy(1,c+9);
   cprintf("%s",*(Title+c));
   }
while(getch() != ENTER);
ClearArea(1,3,80,24,BLUE);
textcolor(YELLOW);
}

static char *HelpText[] = {
"                             ",
"                                        ",
"                                  Library Exercise & Demo",
"                                       ",
"                       .LIB v1.0, Beta A",
"       Copyright 1993 James C. Dunavant, All Rights Reserved",
" ",
"                                 =  H E L P  =",
"   [Esc] ......... Press the Esc key to exit program; Press 'C' to exit at",
"                   current directory, or 'O' to exit to startup (original)",
"                   directory.",
"   Log drive ..... Press 'L' to log on to drive. Use  to select & press ",
"   Scan drive .... Press 'S' to scan & build directory tree for current drive.",
"   Tree .......... Press 'T' to display directory tree of current drive.",
"   Dir ........... Press 'D' to display directory list of current path.",
"   Write log ..... Press 'W' to write directory tree log of current drive.",
"   Read log ...... Press 'R' to read directory tree log of current drive.",
"   Print list .... Press 'P' to print directory/tree of current path/drive.",
"   Help .......... Press 'H' or '?' to see this help screen.",
"   Delete/Insert . Press to delete or Insert directory/filename into list",
"                          []    [Home] [Page Up] ",
"   Use the cursor keys [][][\032] [End ] [Page Dn]  to move about display.",
" Press Alt+? where ? = 0-9 & A-Z to search directory/tree list by first letter.",
"                      Press Esc to exit this help screen"};
static char WScrn[4000];
/***> Help <**********************************************************/
/* ACTION: Display help screen.                                      */
/*  INPUT: void.                                                     */
/* RETURN: void.                                                     */
/*********************************************************************/
static near void Help(void)
{
int c;

gettext(1,1,80,25,WScrn);
textbackground(LIGHTGRAY);
textcolor(BLUE);
clrscr();
for(c = 0; c < 24; c++)
   {
   gotoxy(1,c+2);
   cprintf("%s",*(HelpText+c));
   }
while(getch() != ESC);
textbackground(BLUE);
textcolor(YELLOW);
puttext(1,1,80,25,WScrn);
}

/***> HardErrorHandler <**********************************************/
/* ACTION: Receive control in event of critical error int 24h.       */
/*         Issue report to user with the usual "Retry" and "Abort"   */
/*         requestor.  Set global jdHardError and return to program  */
/*         at interrupted point.                                     */
/*  INPUT: errcode = value in DI register,                           */
/*         axval   = value in AX register,                           */
/*         bpval   = value in BP register,                           */
/*         sival   = value in SI register.                           */
/* RETURN: -1                                                        */
/*********************************************************************/
int HardErrorHandler(int errcode, int axval, int bpval, int sival)
{
char *report;              /* Report string depending on nature of error */
char dbuf[2] = {'?','\0'}; /* Drive on which error occurred */
char text[80];
unsigned int *device;      /* Pointer to device header of error device */
char lowax;                /* High byte of axval shifted >> 8 */
int ret;

lowax = axval >> 8;

device = MK_FP((unsigned) bpval,(unsigned) sival);
*dbuf = 'A' + (axval & 0xFF);

if(!(lowax & 0x80))      /* Is it a disk error? */
   {
   switch(errcode & 0xFF)   /* Point to error report string */
      {
      case 0:
         report = "DISK IS WRITE PROTECTED";
         break;
      case 1:
         report = "INVALID DRIVE SPECIFIER";
         break;
      case 2:
         report = "DRIVE NOT READY";
         break;
      case 4:
         report = "CRC ERROR IN DATA";
         break;
      case 5:
         report = "BAD DRIVE REQUEST STRUCTURE";
         break;
      case 6:
         report = "SEEK ERROR";
         break;
      case 7:
         report = "DISK FORMAT NOT RECOGNIZED";
         break;
      case 8:
         report = "SECTOR NOT FOUND";
         break;
      case 9:
         report = "PRINTER OUT OF PAPER";
         break;
      case 10:
         report = "WRITE ERROR";
         break;
      case 11:
         report = "READ ERROR";
         break;
      case 12:
         report = "GENERAL FAILURE";
         break;
      default:
         report = "UNKNOWN ERROR";
      }
   }
else   /* Non-disk error */
   {
   if(!((*(device+4) >> 8) & 0x80))
      {
      if(InPrint)   /* Fool DOS */
         report = "PROBLEM WITH PRINTER";
      else
         report = "BAD MEMORY IMAGE OF FAT"; /* Offline printer will..  */
      }                                      /* generate this error ??? */
   else
      {
      switch(*(device+4) & 0xF)
         {
         case 1:
            report = "ERROR IN STANDARD INPUT";
            break;
         case 2:
            report = "ERROR IN STANDARD OUTPUT";
            break;
         case 4:
            report = "ERROR IN NULL DEVICE";
            break;
         case 8:
            report = "ERROR IN CLOCK DEVICE";
            break;
         default:
            report = "UNKNOWN ERROR";
         }
      }
   }

sprintf(text," CRITICAL ERROR: Drive %s : %s / R)etry A)bort",dbuf,report);
gettext(1,25,80,25,Error);
textbackground(RED);
textcolor(WHITE);
gotoxy(1,25);
cputs(text);
clreol();
putchar(7);
textbackground(BLUE);
textcolor(YELLOW);
ret = 0;
while(ret != 'R' && ret != 'A')
   {
   switch(ret = toupper(getch()))
      {
      case 'R':
         jdHardRetry = 1;
         break;
      case 'A':
         jdHardRetry = 0;
      }
   }
puttext(1,25,80,25,Scrn);
hardretn(-1);
return(-1);
}

/***> Init <**********************************************************/
/* ACTION: Initialize demo                                           */
/* RETURN: void                                                      */
/*  INPUT: void                                                      */
/*********************************************************************/
static near void Init()
{

clrscr();
cputs("Working . . .");

/* SHOULD CHECK DOS VERSION HERE */

if((getcwd(CurrDir,MAXPATH)) != CurrDir)
   {
   cputs("Unable to get current working directory!\r\n");
   exit(1);
   }

if((LL_first = jdBuildDriveList()) == NULL)
   {
   cputs("Unable to build drive list!\r\n");
   exit(1);
   }

if((DL_first = jdBuildDirList("*.*",ALL_ATTR)) == NULL)
   {
   cputs("Unable to build directory list!\r\n");
   exit(1);
   }

harderr(HardErrorHandler);     /* Install critical error handler */

_wscroll = 0;   /* Prevent scrolling */
textmode(C80);  /* Assume 80 x 25 color; but should check hardware */
_setcursortype(_NOCURSOR);
textbackground(BLUE);
clrscr();
textbackground(LIGHTGRAY);
textcolor(BLUE);
cputs(" [Esc]  Log drive  Scan drive  Tree  Dir  Write log  Read log  Print list  Help ");
textcolor(WHITE);
gotoxy(3,1);cputs("Esc");
gotoxy(9,1);cputs("L");
gotoxy(20,1);cputs("S");
gotoxy(32,1);cputs("T");
gotoxy(38,1);cputs("D");
gotoxy(43,1);cputs("W");
gotoxy(54,1);cputs("R");
gotoxy(64,1);cputs("P");
gotoxy(76,1);cputs("H");
WritePath(CurrDir);
WriteMessage("Press menu Letter to activate, or use   to select from list");
}

static char *SysErrMsg[] = {
/*  0 */    "System error 0",
/*  1 */    "Invalid function number",
/*  2 */    "No such file/path/printer",
/*  3 */    "Path not found",
/*  4 */    "Too many open files",
/*  5 */    "Permission denied",
/*  6 */    "Bad file number",
/*  7 */    "Memory core corrupt",
/*  8 */    "Not enough memory",
/*  9 */    "Invalid memory block address",
/* 10 */    "Invalid environment",
/* 11 */    "Invalid format",
/* 12 */    "Invalid access code",
/* 13 */    "Invalid data",
/* 14 */    "Unknown error", /* Unix */
/* 15 */    "No such device",
/* 16 */    "Can't remove current directory",
/* 17 */    "Not same device",
/* 18 */    "No more files",
/* 19 */    "Invalid argument",
/* 20 */    "Arg list too big",
/* 21 */    "Exec format error",
/* 22 */    "Cross-device link",
/* 23 */    "Invalid error", /* Unix... */
/* 24 */    "Invalid error",
/* 25 */    "Invalid error",
/* 26 */    "Invalid error",
/* 27 */    "Invalid error",
/* 28 */    "Invalid error",
/* 29 */    "Invalid error",
/* 30 */    "Invalid error",
/* 31 */    "Invalid error",
/* 32 */    "Invalid error",
/* 33 */    "Math argument",
/* 34 */    "Result too large",
/* 35 */    "File already exists",
/* 36 */    "Possible deadlock",
};

/***> WriteErrorMsg <*************************************************/
/* ACTION: Write errno message to screen.                            */
/* RETURN: void                                                      */
/*  INPUT: msg - pointer to user message string.                     */
/*********************************************************************/
static near void WriteErrorMsg(char *msg)
{

gettext(1,25,80,25,Error);
textbackground(RED);
textcolor(WHITE);
gotoxy(1,25);
cputs(" ERR: ");
cputs(msg);
if(errno < 37)
   {
   cputs(" : ");
   cputs(*(SysErrMsg+errno));
   }
cputs(" / Press ");
clreol();
putchar(7);
delay(100);
putchar(7);
while(getch() != 13);
puttext(1,25,80,25,Scrn);
textbackground(BLUE);
textcolor(YELLOW);
}

/********************************************************
   FUNCTION: ClearKeyboard
        ARG: void
*********************************************************/
static near void ClearKeyboard()
{
struct REGPACK pack;

do
   {
   pack.r_ax = 0x0600;   /* Direct console function */
   pack.r_dx = 0x00FF;   /* Request character subfunction */
   intr(0x21,&pack);
   }                              /* Bit 6 is zero flag */
while(!(pack.r_flags & 0x0040));  /* Continue while not set */
}


/***> ClearArea <*****************************************************/
/* ACTION: Clear area to specified color.                            */
/* RETURN: void                                                      */
/*  INPUT: left, top, right, bottom - screen coordinates,            */
/*         bc - background color.                                    */
/*********************************************************************/
static near void ClearArea(int left, int top, int right, int bottom, int bc)
{

window(left,top,right,bottom);
textbackground(bc);
clrscr();
window(1,1,80,25);
}

/***> Highlight <*****************************************************/
/* ACTION: Highlight current item.                                   */
/* RETURN: void                                                      */
/*  INPUT: item - void pointer to item                               */
/*         line - window line                                        */
/*         mode - pointer type                                       */
/*         state - ON or OFF                                         */
/*********************************************************************/
static near void Highlight(void *item, int line, int mode, int state)
{
jdDLIST *dptr;
jdTLIST *tptr;
jdLLIST *lptr;

textbackground((state == ON) ? BLACK : BLUE);
gotoxy(1,line);
switch(mode)
   {
   case M_DIRECTORY:
      dptr = (jdDLIST *) item;
      cprintf(Dformat,dptr->Name,dptr->Ext,dptr->Time,dptr->Date,
                                  dptr->Size,jdBuildAttrStr(dptr));
      break;
   case M_TREE:
      tptr = (jdTLIST *) item;
      cprintf(Tformat,jdConnectTree(tptr),tptr->Name);
      break;
   case M_DRIVE:
      lptr = (jdLLIST *) item;
      cprintf(Lformat,
             (lptr->Drive > -1)?lptr->Drive+'A':'?',
             ((lptr->Remote & IS_REMOTE) && !lptr->Cdrom)?"Remote/Network"
            :((lptr->Remote & IS_SHARED) && !lptr->Cdrom)?"Local & Shared"
            :((lptr->Remote & IS_SUBSTITUTE) && !lptr->Cdrom)?"Substituted"
            :(lptr->Remote && !lptr->Cdrom)?"Local"
            :(lptr->Cdrom)?"CD Rom":"Unknown");
      break;
   }
clreol();
}

/***> WritePath <*****************************************************/
/* ACTION: WritePath string to screen                                */
/* RETURN: void                                                      */
/*  INPUT: void                                                      */
/*********************************************************************/
static near void WritePath(char *path)
{

textbackground(MAGENTA);
textcolor(WHITE);
gotoxy(1,2);
cputs(" ");
cputs(path);
clreol();
textbackground(BLUE);
textcolor(YELLOW);
}

/***> WriteMessage <**************************************************/
/* ACTION: Write message to message line.                            */
/* RETURN: void                                                      */
/*  INPUT: void                                                      */
/*********************************************************************/
static near void WriteMessage(char *msg)
{

textbackground(MAGENTA);
textcolor(WHITE);
gotoxy(1,25);
cputs(" MSG: ");
cputs(msg);
clreol();
textbackground(BLUE);
textcolor(YELLOW);
}

typedef struct {
   char Scan;
   char Key;
   } TRANSLATE;

TRANSLATE AltNum[] = {{120,'1'},{121,'2'},{122,'3'},{123,'4'},{124,'5'},
                      {125,'6'},{126,'7'},{127,'8'},{128,'9'},{129,'0'}};

TRANSLATE ScanAlpha[] = {{16,'Q'},{17,'W'},{18,'E'},{19,'R'},{20,'T'},
                         {21,'Y'},{22,'U'},{23,'I'},{24,'O'},{25,'P'},
                         {30,'A'},{31,'S'},{32,'D'},{33,'F'},{34,'G'},
                         {35,'H'},{36,'J'},{37,'K'},{38,'L'},
                         {44,'Z'},{45,'X'},{46,'C'},{47,'V'},{48,'B'},
                         {49,'N'},{50,'M'}};

static char Cdrive[MAXPATH];
static char Mask[MAXPATH];
static char Test[] = " :\\{{tree}}.log";
/***> Demo <**********************************************************/
/* ACTION: Demonstrate calls to the jdFILES library                  */
/* RETURN: void                                                      */
/*  INPUT: void                                                      */
/*                                                                   */
/* WARNING: Anyone caught writing code like this will be held        */
/*          captive in a windowless room with a single 40-watt       */
/*          lightbulb, given a single meal of white bread and water  */
/*          per day, and forced to program in Cobol on a Timex 1000  */
/*          for a thousand years.  Except me, of course.             */
/*********************************************************************/
static near void Demo()
{
union REGS rgs;
int c, key, scan, mode = M_DIRECTORY, line = 3;
int alt_dn, papp = 0, cdrive = getdisk();
char search, found, buf[13];
jdDLIST *dcurr, *dtop, *dbot, *dnew, *insert;
jdTLIST *tcurr = NULL, *ttop, *tbot, *tnew;
jdLLIST *lcurr = LL_first, *ltop, *lbot;

strcpy(Cdrive,CurrDir);

dcurr = dtop = DL_first;
for(c = 3; c < 25 && dcurr; c++)
   {
   dbot = dcurr;
   gotoxy(1,c);
   cprintf(Dformat,dcurr->Name,dcurr->Ext,dcurr->Time,dcurr->Date,
                                  dcurr->Size,jdBuildAttrStr(dcurr));
   dcurr = dcurr->Next;
   }
dcurr = dtop;
Highlight(dcurr,line,mode,ON);

while(1)
   {
   rgs.h.ah = 0x00;   /* Read keyboard */
   int86(0x16,&rgs,&rgs);
   key = rgs.h.al;    /* ASCII */
   scan = rgs.h.ah;   /* Scan  */

   rgs.h.ah = 0x02;   /* Keyboard status function */
   int86(0x16,&rgs,&rgs);
   alt_dn = rgs.h.al & ALT_DN;

   ClearKeyboard();   /* Prevent buffer overflow for fast keyboards */

   if(alt_dn)         /* Search by first character */
      {
      search = found = 0;
      if(scan > 119 && scan < 130)  /* Numeric */
         {
         for(c = 0; c < 10; c++)
            {
            if(AltNum[c].Scan == scan)
               {
               search = AltNum[c].Key;
               break;
               }
            }
         }
      else
         {
         for(c = 0; c < 26; c++)  /* Alphabetic */
            {
            if(ScanAlpha[c].Scan == scan)
               {
               search = ScanAlpha[c].Key;
               break;
               }
            }
         }
      if(!search) continue;
      switch(mode)
         {
         case M_DIRECTORY:
            dnew = (dcurr->Next) ? dcurr->Next : DL_first;
            while(dnew != dcurr)
               {
               if(*(dnew->Name) == search)  /* Found it */
                  {
                  found++;
                  dtop = dcurr = dnew;
                  ClearArea(1,3,80,24,BLUE);
                  for(c = 3; c < 25 && dcurr; c++)
                     {
                     dbot = dcurr;
                     gotoxy(1,c);
                     cprintf(Dformat,dcurr->Name,dcurr->Ext,dcurr->Time,
                              dcurr->Date,dcurr->Size,jdBuildAttrStr(dcurr));
                     dcurr = dcurr->Next;
                     }
                  dcurr = dtop;
                  line = 3;
                  Highlight(dcurr,line,mode,ON);
                  break;
                  }
               dnew = (dnew->Next) ? dnew->Next : DL_first;
               }
            if(!found)
               {
               putchar(7);
               }
            break;
         case M_TREE:
            tnew = (tcurr->Next) ? tcurr->Next : TL_first;
            while(tnew != tcurr)
               {
               if(*(tnew->Name) == search)  /* Found it */
                  {
                  found++;
                  ttop = tcurr = tnew;
                  ClearArea(1,3,80,24,BLUE);
                  for(c = 3; c < 25 && tcurr; c++)
                     {
                     tbot = tcurr;
                     gotoxy(1,c);
                     cprintf(Tformat,jdConnectTree(tcurr),tcurr->Name);
                     tcurr = tcurr->Next;
                     }
                  tcurr = ttop;
                  line = 3;
                  Highlight(tcurr,line,mode,ON);
                  WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
                  break;
                  }
               tnew = (tnew->Next) ? tnew->Next : TL_first;
               }
            if(!found)
               {
               putchar(7);
               }
            break;
         default:
            putchar(7);
         }
      }

   switch(toupper(key))
      {
      case ESC:
         gettext(1,25,80,25,Scrn);
         _setcursortype(_SOLIDCURSOR);
         putchar(7);
         WriteMessage("Exit to Current or Original directory (C/O)? ");
         gotoxy(wherex()-1,wherey());
         key = getch();
         switch(toupper(key))
            {
            case 'C':
               setdisk(*(Cdrive)-'A');
               *(Cdrive+strlen(Cdrive)-1) = '\0';
               chdir(Cdrive);
               return;
            case ESC:
            case 'O':
               return;
            default:
               _setcursortype(_NOCURSOR);
               puttext(1,25,80,25,Scrn);
            }
         break;
      case ENTER:
         switch(mode)
            {
            case M_DIRECTORY:
               if(dcurr->Attrib & FA_DIREC && *(dcurr->Name+1) == '.')
                  {  /* Selected parent */
                  *(Cdrive+(c = strlen(Cdrive))-1) = '\0';
                  while(*(Cdrive+c) != '\\')
                     *(Cdrive+c--) = '\0';
                  WritePath(Cdrive);
                  goto Dir_jump;  /* What? A "goto?!" How dare I? */
                  }
               else if(dcurr->Attrib & FA_DIREC && *(dcurr->Name+1) != '.')
                  {  /* Selected subdirectory */
                  strcat(Cdrive,dcurr->Name);
                  if(*(dcurr->Ext) == '.') /* Dir name extension */
                     strcat(Cdrive,dcurr->Ext);
                  strcat(Cdrive,"\\");
                  WritePath(Cdrive);
                  goto Dir_jump;  /* Another one. So? */
                  }
               break;
            case M_TREE:
               goto Dir_jump;  /* Give up, will ya */
            case M_DRIVE:
               if(lcurr->Drive > -1)
                  {
                  cdrive = lcurr->Drive;
                  goto Tree_jump;
                  }
               break;
            }
         break;
      case 'L':
         ClearArea(1,3,80,24,BLUE);
         if(mode == M_DIRECTORY && DL_first)
            jdFreeDirList(DL_first);
         DL_first = NULL;
         mode = M_DRIVE;
         lcurr = ltop = LL_first;
         for(c = 3; c < 25 && lcurr; c++)
            {
            lbot = lcurr;
            gotoxy(1,c);
            cprintf(Lformat,
                   (lcurr->Drive > -1)?lcurr->Drive+'A':'?',
                   (lcurr->Remote & IS_REMOTE && !lcurr->Cdrom)?"Remote/Network"
                  :(lcurr->Remote & IS_SHARED && !lcurr->Cdrom)?"Local & Shared"
                  :(lcurr->Remote & IS_SUBSTITUTE && !lcurr->Cdrom)?"Substituted"
                  :(lcurr->Remote && !lcurr->Cdrom)?"Local"
                  :(lcurr->Cdrom)?"CD Rom":"Unknown");
            lcurr = lcurr->Next;
            }
         lcurr = ltop;
         line = 3;
         Highlight(lcurr,line,mode,ON);
         WriteMessage("Press menu Letter to activate, or use"
                      "   to select drive");
         break;
      case 'S':
         ClearArea(1,3,80,24,BLUE);
         if(mode == M_DIRECTORY && DL_first)
            jdFreeDirList(DL_first);
         if(TL_first)
            jdFreeTreeList(TL_first);
         TL_first = NULL;
         jdDrives[cdrive].Tree = NULL;
         DL_first = NULL;
         goto Tree_build;
      case 'T':
         Tree_jump:
         ClearArea(1,3,80,24,BLUE);
         if(mode == M_DIRECTORY && DL_first)
            jdFreeDirList(DL_first);
         DL_first = NULL;
         if(!jdDrives[cdrive].Tree)
            {
            *Test = cdrive+'A';
            if(access(Test,0) == 0)
               {
               WriteMessage("Reading tree log . . .");
               tnew = jdReadTreeLog(NULL,cdrive);
               if(!tnew)
                  {
                  strcpy(Cdrive,"*NO FILES*");
                  WritePath(Cdrive);
                  getcwd(Cdrive,MAXPATH);
                  WriteErrorMsg("Error reading tree log");
                  WriteMessage("Press menu Letter to activate.");
                  mode = M_NOMODE;
                  break;
                  }
               else
                  TL_first = jdDrives[cdrive].Tree = tnew;
               }
            else
               {
               Tree_build:
               WriteMessage("Building directory tree . . .");
               TL_first = jdBuildTreeList(cdrive);
               if(!TL_first)
                  {
                  strcpy(Cdrive,"*NO FILES*");
                  WritePath(Cdrive);
                  getcwd(Cdrive,MAXPATH);
                  WriteErrorMsg("Error building directory tree");
                  WriteMessage("Press menu Letter to activate.");
                  mode = M_NOMODE;
                  break;
                  }
               jdDrives[cdrive].Tree = TL_first;
               }
            }
         else  /* Already in memory */
            TL_first = jdDrives[cdrive].Tree;
         Tree_jump2:
         mode = M_TREE;
         tcurr = ttop = TL_first;
         for(c = 3; c < 25 && tcurr; c++)
            {
            tbot = tcurr;
            gotoxy(1,c);
            cprintf(Tformat,jdConnectTree(tcurr),tcurr->Name);
            tcurr = tcurr->Next;
            }
         tcurr = ttop;
         line = 3;
         Highlight(tcurr,line,mode,ON);
         WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
         WriteMessage("Press menu Letter to activate, or use"
                      "   to select directory");
         break;
      case 'D':
         Dir_jump:
         ClearArea(1,3,80,24,BLUE);
         if(mode == M_DIRECTORY && DL_first)
            jdFreeDirList(DL_first);
         WriteMessage("Building directory list . . .");
         strcpy(Mask,Cdrive);
         strcat(Mask,"*.*");
         if((DL_first = jdBuildDirList(Mask,ALL_ATTR)) == NULL)
            {
            strcpy(Cdrive,"*NO FILES*");
            WritePath(Cdrive);
            getcwd(Cdrive,MAXPATH);
            WriteErrorMsg("Error building directory list");
            WriteMessage("Press menu Letter to activate.");
            mode = M_NOMODE;
            break;
            }
         mode = M_DIRECTORY;
         dcurr = dtop = DL_first;
         for(c = 3; c < 25 && dcurr; c++)
            {
            dbot = dcurr;
            gotoxy(1,c);
            cprintf(Dformat,dcurr->Name,dcurr->Ext,dcurr->Time,
                     dcurr->Date,dcurr->Size,jdBuildAttrStr(dcurr));
            dcurr = dcurr->Next;
            }
         dcurr = dtop;
         line = 3;
         Highlight(dcurr,line,mode,ON);
         WriteMessage("Press menu Letter to activate,"
                      " or use   to select from list");
         break;
      case 'W':
         if(mode == M_TREE && jdDrives[cdrive].Cdrom)
            {
            gettext(1,25,80,25,Scrn);
            errno = 5;
            WriteErrorMsg("Can't write log to CD Rom drive!");
            puttext(1,25,80,25,Scrn);
            break;
            }
         if(mode == M_TREE)
            {
            gettext(1,25,80,25,Scrn);
            WriteMessage("Writing tree log to current drive . . .");
            jdWriteTreeLog(NULL,TL_first,cdrive);
            puttext(1,25,80,25,Scrn);
            }
         else
            putchar(7);
         break;
      case 'R':
         if(mode == M_TREE && jdDrives[cdrive].Cdrom)
            {
            gettext(1,25,80,25,Scrn);
            errno = 5;
            WriteErrorMsg("Can't read log from CD Rom drive!");
            puttext(1,25,80,25,Scrn);
            break;
            }
         ClearArea(1,3,80,24,BLUE);
         if(mode == M_DIRECTORY && DL_first)
            jdFreeDirList(DL_first);
         if(TL_first)
            jdFreeTreeList(TL_first);
         DL_first = NULL;
         TL_first = NULL;
         WriteMessage("Reading tree log . . .");
         tnew = jdReadTreeLog(NULL,cdrive);
         if(!tnew)
            {
            strcpy(Cdrive,"*NO FILES*");
            WritePath(Cdrive);
            getcwd(Cdrive,MAXPATH);
            WriteErrorMsg("Error reading tree log");
            WriteMessage("Press menu Letter to activate.");
            mode = M_NOMODE;
            break;
            }
         else
            {
            TL_first = jdDrives[cdrive].Tree = tnew;
            goto Tree_jump2;
            }
      case 'P':
         gettext(1,25,80,25,Scrn);
         if(mode && mode != M_DRIVE)
            {
            if(!(biosprint(2,0,0) & 0x80))
               {
               putchar(7);
               WriteErrorMsg("Printer NOT ready");
               goto Print_out;
               }
            _setcursortype(_SOLIDCURSOR);
            putchar(7);
            WriteMessage("Print - Append CR to each line (Y/N)? ");
            gotoxy(wherex()-1,wherey());
            key = getch();
            switch(toupper(key))
               {
               case 'Y':
                  papp = 1;
                  break;;
               default:
                  papp = 0;
               }
            puttext(1,25,80,25,Scrn);
            _setcursortype(_NOCURSOR);
            }
         if(mode == M_TREE)
            {
            WriteMessage("Printing . . .");
            InPrint = 1;
            do
               {
               jdHardRetry = 0;
               fprintf(stdprn,"Directory Tree of Drive %c:\n\n",cdrive+'A');
               if(papp) fprintf(stdprn,"\r");
               }
            while(jdHardRetry);
            if(jdHardRetry) goto Print_out;
            tnew = TL_first;
            while(tnew)
               {
               do
                  {
                  jdHardRetry = 0;
                  fprintf(stdprn,Tformat,jdConnectTree(tnew),tnew->Name);
                  fprintf(stdprn,"\n");
                  if(papp) fprintf(stdprn,"\r");
                  }
               while(jdHardRetry);
               if(jdHardRetry) goto Print_out;
               tnew = tnew->Next;
               }
            if(jdHardRetry) goto Print_out;
            do
               {
               jdHardRetry = 0;
               fprintf(stdprn,"\014");
               }
            while(jdHardRetry);
            if(jdHardRetry) goto Print_out;
            }
         else if(mode == M_DIRECTORY)
            {
            WriteMessage("Printing . . .");
            InPrint = 1;
            do
               {
               jdHardRetry = 0;
               fprintf(stdprn,"Directory of %s:\n\n",Cdrive);
               if(papp) fprintf(stdprn,"\r");
               }
            while(jdHardRetry);
            if(jdHardRetry) goto Print_out;
            dnew = DL_first;
            while(dnew)
               {
               do
                  {
                  jdHardRetry = 0;
                  fprintf(stdprn,Dformat,dnew->Name,dnew->Ext,dnew->Time,
                             dnew->Date,dnew->Size,jdBuildAttrStr(dnew));
                  fprintf(stdprn,"\n");
                  if(papp) fprintf(stdprn,"\r");
                  }
               while(jdHardRetry);
               if(jdHardRetry) goto Print_out;
               dnew = dnew->Next;
               }
            if(jdHardRetry) goto Print_out;
            do
               {
               jdHardRetry = 0;
               fprintf(stdprn,"\014");
               }
            while(jdHardRetry);
            if(jdHardRetry) goto Print_out;
            }
         else
            putchar(7);
         puttext(1,25,80,25,Scrn);
         Print_out:
         InPrint = 0;
         break;
      case '?':
      case 'H':
         Help();
      }
   switch(scan)
      {
      case INSERT:
         switch(mode)
            {
            case M_DIRECTORY:
               if(!(insert = malloc(sizeof(jdDLIST))))
                  {
                  errno = 8;
                  WriteErrorMsg("Can't Insert!");
                  WriteMessage("Press menu Letter to activate.");
                  break;
                  }
               WritePath("Enter filename as <8 max chars><space><.><3 max chars> : ");
               _setcursortype(_NORMALCURSOR);
               scanf("%8s%4s",insert->Name,insert->Ext);
               _setcursortype(_NOCURSOR);
               fflush(stdin);
               strcpy(insert->Time,"00:00 am");
               strcpy(insert->Date,"00-00-00");
               insert->Attrib = 0;
               insert->Size = 1000L;
               dnew = jdAddDirNode(DL_first,insert);
               if(dnew)
                  DL_first = dcurr  = dnew;
               else
                  {
                  errno = 5;
                  WriteErrorMsg("Insert Failed");
                  WriteMessage("Press menu Letter to activate.");
                  break;
                  }
               ClearArea(1,3,80,24,BLUE);
               line = 3;
               for(c = 3; c < 25 && dnew; c++)
                  {
                  gotoxy(1,c);
                  cprintf(Dformat,dnew->Name,dnew->Ext,dnew->Time,
                           dnew->Date,dnew->Size,jdBuildAttrStr(dnew));
                  dbot = dnew;
                  dnew = dnew->Next;
                  }
               Highlight(dcurr,line,M_DIRECTORY,ON);
               WritePath(Cdrive);
               break;
            case M_TREE:
               WritePath("Enter directory name as <8 max chars><[.]><[3 max chars]> : ");
               _setcursortype(_NORMALCURSOR);
               scanf("%13s",buf);
               _setcursortype(_NOCURSOR);
               fflush(stdin);
               tnew = jdAddTreeNode(tcurr,buf);
               if(!tnew)
                  {
                  WriteErrorMsg("Failed to add directory!");
                  WriteMessage("Press menu Letter to activate.");
                  break;
                  }
               tcurr = tnew;
               ttop = tnew;
               line = 3;
               ClearArea(1,3,80,24,BLUE);
               for(c = 3; c < 25 && tnew; c++)
                  {
                  gotoxy(1,c);
                  cprintf(Tformat,jdConnectTree(tnew),tnew->Name);
                  tbot = tnew;
                  tnew = tnew->Next;
                  }
               Highlight(tcurr,line,M_TREE,ON);
               WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
               WritePath(Cdrive);
               break;
            }
         break;
      case DELETE:
         switch(mode)
            {
            case M_DIRECTORY:
               if(dcurr->Attrib & _A_SUBDIR)
                  {
                  errno = 5;
                  WriteErrorMsg("Can't delete directory!");
                  WriteMessage("Press menu Letter to activate.");
                  break;
                  }
               if(dcurr == DL_first)
                  {
                  if(dcurr->Next)
                     DL_first = dcurr->Next;
                  else if(dcurr->Prev)
                     DL_first = dcurr->Prev;
                  else
                     DL_first = NULL;
                  }
               if(dtop == dcurr)
                  {
                  if(dcurr->Next)
                     dtop = dcurr->Next;
                  else if(dcurr->Prev)
                     dtop = dcurr->Prev;
                  }
               dcurr = jdDelDirNode(dcurr);
               ClearArea(1,3,80,24,BLUE);
               if(!dcurr)
                  {
                  WriteMessage("No more files!");
                  break;
                  }
               dnew = dtop;
               for(c = 3; c < 25 && dnew; c++)
                  {
                  gotoxy(1,c);
                  cprintf(Dformat,dnew->Name,dnew->Ext,dnew->Time,
                           dnew->Date,dnew->Size,jdBuildAttrStr(dnew));
                  if(dnew == dcurr)
                     line = c;
                  dbot = dnew;
                  dnew = dnew->Next;
                  }
               Highlight(dcurr,line,M_DIRECTORY,ON);
               break;
            case M_TREE:
               if(ttop == tcurr)
                  {
                  if(ttop->Next)
                     ttop = ttop->Next;
                  else if(ttop->Prev)
                     ttop = ttop->Prev;
                  }
               tnew = jdDelTreeNode(tcurr);
               if(!tnew)
                  {
                  errno = 5;
                  WriteErrorMsg("Can't delete this directory!");
                  WriteMessage("Press menu Letter to activate.");
                  break;
                  }
               tcurr = tnew;
               tnew = ttop;
               ClearArea(1,3,80,24,BLUE);
               for(c = 3; c < 25 && tnew; c++)
                  {
                  gotoxy(1,c);
                  cprintf(Tformat,jdConnectTree(tnew),tnew->Name);
                  if(tnew == tcurr)
                     line = c;
                  tbot = tnew;
                  tnew = tnew->Next;
                  }
               Highlight(tcurr,line,M_TREE,ON);
               WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
               break;
            }
         break;
      case CURSOR_DN:
         Cursor_dn:
         switch(mode)
            {
            case M_DIRECTORY:
               if(dcurr->Next)
                  {
                  Highlight(dcurr,line,M_DIRECTORY,OFF);
                  if(line == 24)  /* Must scroll */
                     {
                     movetext(1,4,80,24,1,3);
                     dtop = dtop->Next;
                     dbot = dbot->Next;
                     }
                  else
                     line++;
                  dcurr = dcurr->Next;
                  Highlight(dcurr,line,M_DIRECTORY,ON);
                  }
               break;
            case M_TREE:
               if(tcurr->Next)
                  {
                  Highlight(tcurr,line,M_TREE,OFF);
                  if(line == 24)  /* Must scroll */
                     {
                     movetext(1,4,80,24,1,3);
                     ttop = ttop->Next;
                     tbot = tbot->Next;
                     }
                  else
                     line++;
                  tcurr = tcurr->Next;
                  Highlight(tcurr,line,M_TREE,ON);
                  WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
                  }
               break;
            case M_DRIVE:
               if(lcurr->Next)
                  {
                  Highlight(lcurr,line,M_DRIVE,OFF);
                  if(line == 24)  /* Must scroll */
                     {
                     movetext(1,4,80,24,1,3);
                     ltop = ltop->Next;
                     lbot = lbot->Next;
                     }
                  else
                     line++;
                  lcurr = lcurr->Next;
                  Highlight(lcurr,line,M_DRIVE,ON);
                  }
               break;
            }
         break;
      case CURSOR_UP:
         switch(mode)
            {
            case M_DIRECTORY:
               if(dcurr->Prev)
                  {
                  Highlight(dcurr,line,M_DIRECTORY,OFF);
                  if(line == 3)  /* Must scroll */
                     {
                     movetext(1,3,80,23,1,4);
                     dtop = dtop->Prev;
                     dbot = dbot->Prev;
                     }
                  else
                     line--;
                  dcurr = dcurr->Prev;
                  Highlight(dcurr,line,M_DIRECTORY,ON);
                  }
               break;
            case M_TREE:
               if(tcurr->Prev)
                  {
                  Highlight(tcurr,line,M_TREE,OFF);
                  if(line == 3)  /* Must scroll */
                     {
                     movetext(1,3,80,23,1,4);
                     ttop = ttop->Prev;
                     tbot = tbot->Prev;
                     }
                  else
                     line--;
                  tcurr = tcurr->Prev;
                  Highlight(tcurr,line,M_TREE,ON);
                  WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
                  }
               break;
            case M_DRIVE:
               if(lcurr->Prev)
                  {
                  Highlight(lcurr,line,M_DRIVE,OFF);
                  if(line == 3)  /* Must scroll */
                     {
                     movetext(1,3,80,23,1,4);
                     ltop = ltop->Prev;
                     lbot = lbot->Prev;
                     }
                  else
                     line--;
                  lcurr = lcurr->Prev;
                  Highlight(lcurr,line,M_DRIVE,ON);
                  }
               break;
            }
         break;
      case CURSOR_LT:        /* Goto parent */
         if(mode == M_TREE && tcurr->Parent)
            {
            Highlight(tcurr,line,M_TREE,OFF);
            tnew = tcurr;
            c = line;
            while(tnew)
               {
               if(tnew == tcurr->Parent)
                  {
                  if(c < 3)
                     {
                     ClearArea(1,3,80,24,BLUE);
                     while(c < 3)
                        {
                        ttop = ttop->Prev;
                        tbot = tbot->Prev;
                        c++;
                        }
                     }
                  line = c;
                  tcurr = ttop;
                  for(c = 3; c < 25 && tcurr; c++)
                     {
                     gotoxy(1,c);
                     cprintf(Tformat,jdConnectTree(tcurr),tcurr->Name);
                     clreol();
                     tcurr = tcurr->Next;
                     }
                  tcurr = tnew;
                  Highlight(tcurr,line,M_TREE,ON);
                  WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
                  break;
                  }
               c--;
               tnew = tnew->Prev;
               }
            }
         break;
      case CURSOR_RT:       /* Goto next sub */
         if(mode == M_TREE && tcurr->Next)
            {
            Highlight(tcurr,line,M_TREE,OFF);
            tnew = tcurr;
            c = line;
            while(tnew)
               {
               if(tnew->Level != tcurr->Level)
                  {
                  if(c > 24)
                     {
                     ClearArea(1,3,80,24,BLUE);
                     while(c > 24)
                        {
                        ttop = ttop->Next;
                        tbot = tbot->Next;
                        c--;
                        }
                     }
                  line = c;
                  tcurr = ttop;
                  for(c = 3; c < 25 && tcurr; c++)
                     {
                     gotoxy(1,c);
                     cprintf(Tformat,jdConnectTree(tcurr),tcurr->Name);
                     clreol();
                     tcurr = tcurr->Next;
                     }
                  tcurr = tnew;
                  Highlight(tcurr,line,M_TREE,ON);
                  WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
                  break;
                  }
               c++;
               tnew = tnew->Next;
               }
            Highlight(tcurr,line,M_TREE,ON);
            if(!tnew)
               goto Cursor_dn;
            }
         break;
      case PAGE_UP:
         switch(mode)
            {
            case M_DIRECTORY:
               if(dtop->Prev)
                  {
                  ClearArea(1,3,80,24,BLUE);
                  c = 0;
                  while(c < 22)
                     {
                     if(!dtop->Prev)
                        break;
                     dtop = dtop->Prev;
                     dbot = dbot->Prev;
                     dcurr = dcurr->Prev;
                     c++;
                     }
                  dnew = dtop;
                  for(c = 3; c < 25 && dnew; c++)
                     {
                     gotoxy(1,c);
                     cprintf(Dformat,dnew->Name,dnew->Ext,dnew->Time,
                              dnew->Date,dnew->Size,jdBuildAttrStr(dnew));
                     dnew = dnew->Next;
                     }
                  Highlight(dcurr,line,M_DIRECTORY,ON);
                  }
               break;
            case M_TREE:
               if(ttop->Prev)
                  {
                  ClearArea(1,3,80,24,BLUE);
                  c = 0;
                  while(c < 22)
                     {
                     if(!ttop->Prev)
                        break;
                     ttop = ttop->Prev;
                     tbot = tbot->Prev;
                     tcurr = tcurr->Prev;
                     c++;
                     }
                  tnew = ttop;
                  for(c = 3; c < 25 && tnew; c++)
                     {
                     gotoxy(1,c);
                     cprintf(Tformat,jdConnectTree(tnew),tnew->Name);
                     tnew = tnew->Next;
                     }
                  Highlight(tcurr,line,M_TREE,ON);
                  WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
                  }
               break;
            }
         break;
      case PAGE_DN:
         switch(mode)
            {
            case M_DIRECTORY:
               if(dbot->Next)
                  {
                  ClearArea(1,3,80,24,BLUE);
                  c = 0;
                  while(c < 22)
                     {
                     if(!dbot->Next)
                        break;
                     dtop = dtop->Next;
                     dbot = dbot->Next;
                     dcurr = dcurr->Next;
                     c++;
                     }
                  dnew = dtop;
                  for(c = 3; c < 25 && dnew; c++)
                     {
                     gotoxy(1,c);
                     cprintf(Dformat,dnew->Name,dnew->Ext,dnew->Time,
                              dnew->Date,dnew->Size,jdBuildAttrStr(dnew));
                     dnew = dnew->Next;
                     }
                  Highlight(dcurr,line,M_DIRECTORY,ON);
                  }
               break;
            case M_TREE:
               if(tbot->Next)
                  {
                  ClearArea(1,3,80,24,BLUE);
                  c = 0;
                  while(c < 22)
                     {
                     if(!tbot->Next)
                        break;
                     ttop = ttop->Next;
                     tbot = tbot->Next;
                     tcurr = tcurr->Next;
                     c++;
                     }
                  tnew = ttop;
                  for(c = 3; c < 25 && tnew; c++)
                     {
                     gotoxy(1,c);
                     cprintf(Tformat,jdConnectTree(tnew),tnew->Name);
                     tnew = tnew->Next;
                     }
                  Highlight(tcurr,line,M_TREE,ON);
                  WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
                  }
               break;
            }
         break;
      case HOME:
         switch(mode)
            {
            case M_DIRECTORY:
               if(!dtop->Prev) break;
               ClearArea(1,3,80,24,BLUE);
               dnew = dcurr = dtop = DL_first;
               for(c = 3; c < 25 && dnew; c++)
                  {
                  gotoxy(1,c);
                  dbot = dnew;
                  cprintf(Dformat,dnew->Name,dnew->Ext,dnew->Time,
                           dnew->Date,dnew->Size,jdBuildAttrStr(dnew));
                  dnew = dnew->Next;
                  }
               line = 3;
               Highlight(dcurr,line,M_DIRECTORY,ON);
               break;
            case M_TREE:
               if(!ttop->Prev) break;
               ClearArea(1,3,80,24,BLUE);
               tnew = tcurr = ttop = TL_first;
               for(c = 3; c < 25 && tnew; c++)
                  {
                  gotoxy(1,c);
                  tbot = tnew;
                  cprintf(Tformat,jdConnectTree(tnew),tnew->Name);
                  tnew = tnew->Next;
                  }
               line = 3;
               Highlight(tcurr,line,M_TREE,ON);
               WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
               break;
            }
         break;
      case END:
         switch(mode)
            {
            case M_DIRECTORY:
               if(!dbot->Next) break;
               ClearArea(1,3,80,24,BLUE);
               dnew = dcurr;
               while(dnew) /* Find last */
                  {
                  dbot = dnew;
                  dnew = dnew->Next;
                  }
               dnew = dbot;
               c = 0;
               while(c < 21 && dnew->Prev)  /* back up 22 */
                  {
                  dnew = dnew->Prev;
                  c++;
                  }
               dtop = dnew;
               for(c = 3; c < 25 && dnew; c++)
                  {
                  gotoxy(1,c);
                  dcurr = dbot = dnew;
                  line = c;
                  cprintf(Dformat,dnew->Name,dnew->Ext,dnew->Time,
                           dnew->Date,dnew->Size,jdBuildAttrStr(dnew));
                  dnew = dnew->Next;
                  }
               Highlight(dcurr,line,M_DIRECTORY,ON);
               break;
            case M_TREE:
               if(!tbot->Next) break;
               ClearArea(1,3,80,24,BLUE);
               tnew = tcurr;
               while(tnew) /* Find last */
                  {
                  tbot = tnew;
                  tnew = tnew->Next;
                  }
               tnew = tbot;
               c = 0;
               while(c < 21 && tnew->Prev)  /* back up 22 */
                  {
                  tnew = tnew->Prev;
                  c++;
                  }
               ttop = tnew;
               for(c = 3; c < 25; c++)
                  {
                  gotoxy(1,c);
                  tcurr = tbot = tnew;
                  line = c;
                  cprintf(Tformat,jdConnectTree(tnew),tnew->Name);
                  tnew = tnew->Next;
                  }
               Highlight(tcurr,line,M_TREE,ON);
               WritePath(strcpy(Cdrive,jdBuildPath(tcurr,cdrive)));
               break;
            }
         break;
      }  /* switch(scan */
   }  /* while(1) */
}
