(* (c) xTech 1992.  All Rights Reserved *)
IMPLEMENTATION MODULE Storage;

IMPORT SYSTEM;
IMPORT stdlib;

CONST no_memory = 5;

PROCEDURE ALLOCATE(VAR a: SYSTEM.ADDRESS; size: CARDINAL);
BEGIN
  a:=stdlib.malloc(size);
  IF a=NIL THEN ASSERT(FALSE,no_memory) END;
END ALLOCATE;

PROCEDURE DEALLOCATE(VAR a: SYSTEM.ADDRESS; size: CARDINAL);
BEGIN
  stdlib.free(a);
  a:=NIL;
END DEALLOCATE;

PROCEDURE IsStorageException (): BOOLEAN;
BEGIN
  RETURN FALSE
END IsStorageException;

PROCEDURE StorageException (): StorageExceptions;
BEGIN
  ASSERT(FALSE);
  RETURN nilDeallocation
END StorageException;

END Storage.
