#include <stdio.h>
#include <dos.h>
#include <dir.h>
#include <time.h>
#include <string.h>
#include <bios.h>
#include <sys\stat.h>
#define RIGHT       0x01
#define LEFT       0x02
#define TRUE 1
#define FALSE 0

void
touch(char[]);
void
main(void);
char           *
upit(char[]);
void
writeout(void);
void
help(void);
void
printlog(void);
void
add2log(void);
void
getlog(char *);
char
make_read_only(void);
char
make_writeable(void);

char            filename[255], bday[4], bmon[4], ampm = 'a';
char            set = FALSE, log = FALSE, needhelp = FALSE, cnt, found;
struct ffblk    ffblk;
struct time     curtime;
struct date     curdate;
struct tm       old, *new;
time_t          thetime;
int             sec, min, day, hour, bdate, bhour, bmin, bsec, byear;

void
main(void)
{
    strcpy(filename, searchpath(_argv[0]));
    for (cnt = 1; cnt + 1 <= _argc; cnt++) {
        found = FALSE;
        if (strcmp("SET", upit(_argv[cnt])) == 0)
            set = found = TRUE;
        if (strcmp("LOG", upit(_argv[cnt])) == 0)
            log = found = TRUE;
        if (!found) {
            needhelp = TRUE;
            break;
        }
    }
    if (needhelp) {
        help();
        exit(1);
    }
    if (set)
        touch(filename);
    if (log)
        if (!set)
            printlog();
        else
            add2log();
	if (set)
      puts("...");
    if (!log && !set)
        writeout();

}               /* main */

void
touch(char name[])
{
    FILE           *file;
    char            tmp;

    int             modifiers;

    modifiers = bioskey(2);
    if (!(modifiers & RIGHT || modifiers & LEFT)) {
        /* if (make_writeable()) exit(1); */
        printf("Updating launch time");
        file = fopen(name, "r+");
        fseek(file, SEEK_SET, 0);
        fread(&tmp, 1, 1, file);
        rewind(file);
        fwrite(&tmp, 1, 1, file);
        /* if (make_read_only()) exit(1); */
    } else {
        printf("Aborting update of %s\n", _argv[0]);
        exit(1);
    }
}               /* touch */

char           *
upit(char str[])
{
    int             i;

    for (i = 0; i < strlen(str); i++) {
        str[i] = toupper(str[i]);
    }
    return str;
}


void
writeout(void)
{
    findfirst(filename, &ffblk, FA_DIREC);
    old.tm_sec = 2 * (ffblk.ff_ftime & 31);
    old.tm_min = (ffblk.ff_ftime & 2016) >> 5;
    old.tm_hour = (ffblk.ff_ftime & 63488) >> 11;
    old.tm_mday = (ffblk.ff_fdate & 31);
    old.tm_mon = ((ffblk.ff_fdate & 480) >> 5) - 1;
    old.tm_year = ((ffblk.ff_fdate & 65024) >> 9) + 80;
    mktime(&old);

    thetime = time(NULL);
    new = localtime(&thetime);

    sec = (*new).tm_sec - old.tm_sec;
    min = (*new).tm_min - old.tm_min;
    if (sec < 0) {
        sec += 60;
        min--;
    }
    hour = (*new).tm_hour - old.tm_hour;
    if (min < 0) {
        min += 60;
        hour--;
    }
    day = (*new).tm_yday - old.tm_yday + (365 * ((*new).tm_year - old.tm_year));
    if (hour < 0) {
        hour += 24;
        day--;
    }
    sscanf(asctime(&old), "%3s %3s %d %d:%d:%d %d", bday, bmon, &bdate, &bhour, &bmin, &bsec, &byear);
    if (bhour >= 12) {
        bhour -= 12;
        ampm = 'p';
    }
    if (bhour == 0)
        bhour = 12;
    if (day < 0)
        printf("Error:  System clock has been changed since bootup");
    else if (day != 0)
        printf("System launched at %2.2d:%2.2d:%2.2d%cm on %s, %s %d, %d\nUp for %d day(s), %2.2d:%2.2d:%2.2d", bhour, bmin, bsec, ampm, bday, bmon, bdate, byear, day, hour, min, sec);
    else
        printf("System launched at %2.2d:%2.2d:%2.2d%cm on %s, %s %d, %d\nUp for %2.2d:%2.2d:%2.2d", bhour, bmin, bsec, ampm, bday, bmon, bdate, byear, hour, min, sec);
}

void
help(void)
{
    puts("\nUptime will tell you how long your computer has been running since the");
    puts("last time it was launched.  Executed with no parameters, it returns the ");
    puts("time elapsed since bootup.\n");
    puts("SET\t: Will set the launchtime.  This needs to be in the AUTOEXEC.BAT file.");
    puts("\t: If either shift key is held, the set is aborted");
    puts("LOG\t: Will print the log, or add to the log if called with set");
    puts("\t: log will be in the same directory as uptime");
}

void
printlog()
{
    char            logname[255], line[81], ans;
    FILE           *log;
    int             cnt = 0;

    getlog(logname);
    log = fopen(logname, "r");
    if (log != NULL) {
        while (fgets(line, 81, log) != NULL) {
            printf("%s", line);
            if (++cnt % 24 == 0) {
                printf("Press any key to continue\r");
                getch();
                clreol();
            }
        }
        printf("\nDelete the log?");
        do {
            ans = toupper(getch());
        } while (ans != 'Y' && ans != 'N' && ans != 13);
        if (ans == 13)
            ans = 'N';
        printf("%c", ans);
        if (ans == 'Y')
            unlink(logname);
    } else
        puts("No log to print");
}

void
getlog(char newname[])
{
    char           *letter;

    strcpy(newname, filename);
    letter = strrchr(newname, '.');
    strcpy(letter, ".LOG");

}

void
add2log()
{
    char            logname[255];
    FILE           *log;

    printf(" and adding entry to log");
    getlog(logname);
    log = fopen(logname, "at");
    time(&thetime);
    fprintf(log, "launched at: %s", ctime(&thetime));
}

char
make_read_only(void)
{
    int             stat;

    stat = chmod(filename, S_IREAD);
    if (stat) {
        printf("Couldn't make %s read-only\n", filename);
        return (1);
    } else
        return (0);
}

char
make_writeable(void)
{
    int             stat;

    stat = chmod(filename, S_IWRITE);
    if (stat) {
        printf("Couldn't make %s writeable\n", filename);
        return (1);
    } else
        return (0);
}
