/////////////////////////////////////////////////////////////////////////////
//
//  SELECT.c
//
/////////////////////////////////////////////////////////////////////////////
//
//  Written by Douglas Holt 11 March 1994.
//
//  This is designed to be called from any function in your IPAS.
//
//  int do_select_object_dialog(int *taggedlist, int *tcount);
//  taggedlist is the indexes to pass to pxp_get_item(taggedlist[i], ...)
//  Return Values:
//		tcount: the length of taggedlist
//		returns the status of OK|Cancel : 1|0
// NOTE:
// if EXP_DONT_UNLOAD is called, _select_init needs to be reset to 1 by caller
/////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pxp.h"
#include "dialog.h"
#include "keys.h"

#include "xdialog.h"
#include "xpxp.h"

int do_select_objects_dialog(int *taggedlist, int *tcount);
int load_object_names(int *indexlist, int icount, int *taggedlist, int *tcount);
void see_box(Dialog *d);
void feel_all(Dialog *d, int mouse);
void feel_none(Dialog *d, int mouse);
void feel_tag(Dialog *d, int mouse);
void feel_untag(Dialog *d, int mouse);
void feel__select_box(Dialog *d, int mouse);

int _select_init = 0; // Not static so that caller can extern

///////////////////////////////////////////////////////////////////////////
//                         IPAS R3 Dialog
///////////////////////////////////////////////////////////////////////////
Dialog _selectdlg[]=
{
{ -1, 1, -1, -1, 0, 5, 5, 258, 235, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, -1, 2, 4, 36, 17, 186, 18, "Select Objects by Name:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 1, 3, 1, 8, 48, 22, 20, "", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 2, 4, 2, 32, 48, 98, 180, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 3, 5, 1, 138, 48, 55, 18, "All", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 4, 6, 1, 194, 48, 55, 18, "None", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 5, 7, 0, 8, 69, 22, 138, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 6, 8, 5, 148, 76, 91, 18, (void *)0, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 7, 9, 1, 140, 96, 53, 18, "Tag", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 8, 10, 1, 194, 96, 54, 18, "Untag", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 9, 11, 1, 156, 184, 74, 20, "OK", NULL, 0, 0, 13, 0, FNULL, FNULL, 0 },
{ 0, -1, 10, 12, 1, 8, 208, 22, 20, "", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 11, -1, 1, 156, 208, 74, 20, "Cancel", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
};

#define SCROLLUP                        2
#define SCROLBOX                        3
#define SELALL                          4
#define SELNONE                         5
#define SCROLBAR                        6
#define TAGSTRNG                        7
#define TAG                             8
#define UNTAG                           9
#define OK                              10
#define SCROLLDN                        11
#define CANCEL                          12


// Editables

static char tagstr[11];

Editable _selectedit[]=
{
{ 10, 10, 0, tagstr, 0, 0, 0, NULL, NULL },
};

static SeeSub _select_see[]=
{
	SCROLBOX, see_box,
	-1, FNULL
};

static FeelSub _select_feel[]=
{
	SELALL, feel_all,
	SELNONE, feel_none,
	TAG, feel_tag,
	UNTAG, feel_untag,
   OK, feel_ok,
   CANCEL, feel_cancel,
	-1, FNULL
};

static Name_list *_select_list = NULL;
static Scroller _select_scroll = { 0, 0, 0, 0, 0, NULL, NULL, NULL };

static ScrSub _select_scr[]=
{
	SCROLLUP, SCROLLDN, SCROLBAR, SCROLBOX, feel__select_box, &_select_scroll,
	-1, -1, -1, -1, FNULL, NULL
};

// End of IPAS III Dialog

////////////////////////////////////////////////////////////////////////////
//                       See and Feel functions
////////////////////////////////////////////////////////////////////////////

void see_box(Dialog *d){
	draw_inbox(d, CYAN);
}

void feel__select_box(Dialog *d, int mouse){
Name_list *nlist;
	
	mouse = 1; // to avoid warning

	if((nlist = which_sel(d)) != NULL){
	// update the text (if " Object01" then "*Object01" an visa versa)
		if(nlist->name[0] == ' ')
			nlist->name[0] = '*';
		else
			nlist->name[0] = ' ';

		prt_list(&_selectdlg[SCROLBOX]);
	}
}

void feel_all(Dialog *d, int mouse){
Name_list *temp_list;

	if(mouse)
		if(!(press_button(d)))
			return;

// update the text in _selectlist (make all "*Objectxx")
	temp_list = _select_list;
	while(temp_list){
		temp_list->name[0] = '*';
		temp_list = temp_list->next;
	}
	prt_list(&_selectdlg[SCROLBOX]);
}

void feel_none(Dialog *d, int mouse){
Name_list *temp_list;

	if(mouse)
		if(!(press_button(d)))
			return;

// update the text in _selectlist (make all " Objectxx")
	temp_list = _select_list;
	while(temp_list){
		temp_list->name[0] = ' ';
		temp_list = temp_list->next;
	}
	prt_list(&_selectdlg[SCROLBOX]);
}

void feel_tag(Dialog *d, int mouse){
Name_list *temp_list;
int nlen, len, i;

	if(mouse)
		if(!(press_button(d)))
			return;

// update the text in _selectlist
	temp_list = _select_list;
	if((nlen = strlen(tagstr)) == 0)
		return;
	while(temp_list){
		len = strlen(temp_list->name) - 1;
		if(nlen > len){
			if(*(tagstr+len) == '*'){
				goto check;
			}
			else {
				for(i = len; i < nlen; i++){
					if(*(tagstr+i) != '?' && *(tagstr+i) != '*')
						goto next;
				}
				goto tag;
			}
		}

		check:
			for(i = 0; i < len;){
				if(*(tagstr+i) == '*')
					goto tag;
				else if(i >= nlen)
					goto next;
				else if(*(tagstr+i) == '?')
					goto cont;
				else if(*(tagstr+i) != temp_list->name[i+1])  // skip leading space
					goto next;
				cont:
					i++;
			}

		tag:
			temp_list->name[0] = '*';

		next:
			temp_list = temp_list->next;
	}
	prt_list(&_selectdlg[SCROLBOX]);
}

void feel_untag(Dialog *d, int mouse){
Name_list *temp_list;
int nlen, len, i;

	if(mouse)
		if(!(press_button(d)))
			return;

// update the text in _selectlist
	temp_list = _select_list;
	if((nlen = strlen(tagstr)) == 0)
		return;
	while(temp_list){
		len = strlen(temp_list->name) - 1; // skip leading space
		if(nlen > len){
			if(*(tagstr+len) == '*'){
				goto check;
			}
			else {
				for(i = len; i < nlen; i++){
					if(*(tagstr+i) != '?' && *(tagstr+i) != '*')
						goto next;
				}
				goto untag;
			}
		}

		check:
			for(i = 0; i < len;){
				if(*(tagstr+i) == '*')
					goto untag;
				else if(i >= nlen)
					goto next;
				else if(*(tagstr+i) == '?')
					goto cont;
				else if(*(tagstr+i) != temp_list->name[i+1])
					goto next;
				cont:
					i++;
			}

		untag:
			temp_list->name[0] = ' ';

		next:
			temp_list = temp_list->next;
	}
	prt_list(&_selectdlg[SCROLBOX]);
}



////////////////////////////////////////////////////////////////////////////
//                    do_select_objects_dialog
////////////////////////////////////////////////////////////////////////////
int do_select_objects_dialog(int *taggedlist, int *tcount){
int *indexlist = NULL; // a list of indexes into pxp_get_item that were pxp_meshes
int mcount = 0;
Name_list *temp_list = NULL;
int i, ii;

	if(!_select_init){
		init_dialog(_selectdlg, _selectedit, NULL);
		_select_init = 1;
	}

	ready_dialog(_selectdlg, _selectedit, _select_see, _select_feel, NULL, _select_scr, NULL);

	if(_select_init < 2){
		strcpy(tagstr, "");
		init_editable(&_selectdlg[TAGSTRNG], tagstr);
	}

	center_dialog(_selectdlg);
	save_under_dialog(_selectdlg);
	draw_dialog(_selectdlg);

// put all of the mesh names into _select_list, get indexlist (a list of
// pxp_get_item indexes), and return mcount the number of meshes
	pxp_get_item_count(mcount);
	if(NULL == (indexlist = (int *)malloc(mcount * sizeof(int) + 1))){
		gfx_continu_line("Out of memory.");
		return(0);
	}
	mcount = load_object_names(indexlist, mcount, taggedlist, tcount);

	do_dialog(_selectdlg, TAGSTRNG);

// for nested dialogs (see page 92)?
	cur_edit = NULL;
	edit_phase = EP_IDLE;

// restore the screen under the dialog box
	restore_under_dialog();

// reset done_dialog to 0 so the calling dialog box doesn't quit too
	dialog_done = 0;

	if(dlgResult){
	// go through _select_list finding the tagged names
	// and fill taggedlist with the indexes of the tagged objects
		temp_list = _select_list;
		for(i = ii = 0; i < mcount; i++){
			if(temp_list->name[0] == '*'){
				taggedlist[ii++] = indexlist[i];
			}
			temp_list = temp_list->next;
		}
		*tcount = ii;
	}

	free_name_list(&_select_list);
	if(indexlist)
		free(indexlist);

	return(dlgResult);
}


////////////////////////////////////////////////////////////////////////////
//                       load_object_names
////////////////////////////////////////////////////////////////////////////
int load_object_names(int *indexlist, int icount, int *taggedlist, int *tcount){
ItemData *itemdata = NULL;
Name_list *temp_list;
int i, status, mcount, index;
char temp[12];

	if(NULL == (itemdata = (ItemData *)malloc(sizeof(ItemData) + 1))){
		gfx_continu_line("Out of memory.");
		return(0);
	}
	mcount = 0;
	for(i = 1; i < icount; i++){ // i = 1 : $AMBIENT$ is always item 0
		pxp_get_item(i, itemdata, status);
		if(status && itemdata->type == PXPMESH){ // mesh object
			sprintf(temp, " %s", itemdata->name); // insert ' ' untagged
			add_to_name_list(&_select_list, temp);
			mcount++;
		}
	}

	sort_name_list(_select_list);

// create indexlist from the *sorted* _select_list and tag prev tagged
	temp_list = _select_list;
	i = index = 0;
	while(temp_list){
		pxp_get_object_index(&temp_list->name[1], &index); // &[1] strips ' '
		indexlist[i++] = index;
		if(*tcount && Member_i(index, taggedlist, *tcount) != -1)
			temp_list->name[0] = '*';  // tagged
		temp_list = temp_list->next;
	}

// if EXP_DONT_UNLOAD is called, the _select_init needs to be reset by caller
	if(_select_init <= 1){
		init_scroller(&_select_scroll, _select_list);
		_select_init++;
	}
	else { // leave the scroll bar in its previous location
		_select_scroll.name_list = _select_list;
	}
	draw_item_number(_selectdlg, SCROLBOX);
	draw_item_number(_selectdlg, SCROLBAR);
	prt_list(&_selectdlg[SCROLBOX]);

// return the number of objects in the scroller box
	return(mcount);
}


