/////////////////////////////////////////////////////////////////////////////
//
//  TESTSEL.c
//
/////////////////////////////////////////////////////////////////////////////
//
//  Written by Douglas Holt 12 March 1994
//
//  This program tests the select.c function and dialog.
//
/////////////////////////////////////////////////////////////////////////////

// For the Metaware High C and High C/C++ compilers, turn off an
// unwanted warning message:
#ifdef __HIGHC__
pragma Offwarn(67); // kills "switch statement has no cases" warning
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pxp.h"
#include "select.h"
#include "dialog.h"
#include "keys.h"
#include "xdialog.h"
#include "xpxp.h"

/* Variable definitions */

int *taggedlist = NULL;
int objcount = 0;
static int inited = 0;

/* Dialog description */

DlgEntry cdialog[]=
{
   0, NULL
};

/* Version test value */

#define VERSION 0x5757

typedef struct{
   ulong version;
} State;

/* the "state" struct MUST start with a "ulong" which is the version#, 
   to prevent using data from old versions of this program.
   This verification is performed automatically. */

static State init_state = { VERSION };
static State state = { VERSION };

///////////////////////////////////////////////////////////////////////////
//                         IPAS R3 Dialog
///////////////////////////////////////////////////////////////////////////
Dialog testdlg[]=
{
{ -1, 1, -1, -1, 0, 5, 5, 336, 132, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, -1, 2, 1, 71, 52, 194, 18, " Select Objects by Name ", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 1, 3, 4, 19, 8, 298, 18, "Select Objects by Name Dialog Tester", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
{ 0, -1, 2, 4, 1, 100, 100, 66, 18, " OK ", NULL, 0, 0, 13, 0, FNULL, FNULL, 0 },
{ 0, -1, 3, -1, 1, 170, 100, 66, 18, " Cancel ", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 },
};

#define SELECT                          1
#define TITLE                           2
#define OK                              3
#define CANCEL                          4


void do_test_dialog(void);
void feel_select(Dialog *d, int mouse);

static FeelSub main_feel[]=
{
   SELECT, feel_select,
   OK, feel_ok,
   CANCEL, feel_cancel,
   -1, FNULL
};

// End of IPAS III Dialog

///////////////////////////////////////////////////////////////////////////
//                         Client Functions
///////////////////////////////////////////////////////////////////////////

int ClientUsesInitDialog(void){
	return(0);
}

void ClientSetStateVar(int id, void *ptr){
int nowarn;

	nowarn = id;
   OVL o;
   ulong *ul;
   char *s;
   
   ul=(ulong *)ptr;
   s=(char *)ptr;
   o.ul = *ul;
}

ulong ClientGetStateVar(int id){
int nowarn;

	nowarn = id;
   OVL o;
   return(o.ul);
}

int ClientVarSize(int id){
int nowarn;

	nowarn = id;
     return(1);
}

char  *ClientGetState(int *size){
   *size = sizeof(State);
   return((char *)&state);
}

void ClientResetState(){	
   state = init_state;	
}

void ClientStartup(EXPbuf *buf){

   stud_r3 = (studio_version() >= 300);
   
   if(!stud_r3){
      strcpy(buf->data.string, "ERROR: Requires 3DS version 3.0 or greater");
      buf->opcode=EXP_CONTINUE;
      buf->usercode=EXP_TERMINATE;
   }
   else {
      buf->opcode = EXP_DONT_UNLOAD;
      buf->usercode=0x0200;
   }
}

/* User routines -- use user codes to process your data */

void ClientUserCode(EXPbuf *buf){
   switch(buf->usercode){
   	case 0x0200:
			do_test_dialog();
	      buf->opcode=EXP_TERMINATE;
	      buf->usercode=EXP_TERMINATE;
			return;

	   default:
	      buf->opcode=buf->usercode=EXP_TERMINATE;
	      buf->status=0;
	      break;
   }
}

void ClientTerminate(void){ 
   /* free any data structures, etc. */
}

DlgEntry *ClientDialog(int n){	
   return(&cdialog[n]); 
}

/* Format your floating-point strings */

void ClientFormatString(int id, float value, char *string){
   switch(id){
   }
}

/* This function should return 1 if the PXP can function in any
   module, otherwise, it should return 0.  */

int ClientIsUniversal(void){
   return(0);
}

////////////////////////////////////////////////////////////////////////////
//                        Direct Call Dialog Functions
////////////////////////////////////////////////////////////////////////////
void free_taggedlist(void){
	if(taggedlist)
		free(taggedlist);
	taggedlist = NULL;
	objcount = 0;
}

void init_taggedlist(void){
int i;
	free_taggedlist();
	pxp_get_item_count(i);
	if(NULL == (taggedlist = (int *)malloc(i * sizeof(int) + 1))){
		mallocerr();
		return;
	}
}

void do_test_dialog(){

	if(!inited){
		init_dialog(testdlg, NULL, NULL);
		inited = 1;
	}

	init_taggedlist();

	ready_dialog(testdlg, NULL, NULL, main_feel, NULL, NULL, NULL);
	center_dialog(testdlg);
	save_under_dialog(testdlg);
	draw_dialog(testdlg);
	do_dialog(testdlg, 0);
	restore_under_dialog();

	_select_init = 1; // reset if EXP_DONT_UNLOAD is called
}

void feel_select(Dialog *d, int mouse){
	if(mouse)
		if(!(press_button(d)))
			return;

	dlgResult = do_select_objects_dialog(taggedlist, &objcount);

	ready_dialog(testdlg, NULL, NULL, main_feel, NULL, NULL, NULL);
}

