/////////////////////////////////////////////////////////////////////////////
//
//  XPXP.c
//
/////////////////////////////////////////////////////////////////////////////
//
//  Written by Douglas Holt 14 March 1994.
//
//  This program contains extra function that should have come with IPAS R3.
//
/////////////////////////////////////////////////////////////////////////////

// For the Metaware High C and High C/C++ compilers, turn off an
// unwanted warning message:
#ifdef __HIGHC__
pragma Offwarn(67);  // kills "switch statement has no cases" warning
pragma Offwarn(257); // kills '=' maybe meant '==' warning
#endif

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "pxp.h"
#include "dialog.h"
#include "xdialog.h"

void pxp_get_new_name(char *newname, char *oldname, Name_list *objectnames);
void pxp_get_object_index(char *objname, int *index);
int pxp_get_object_names(Name_list *objectnames, int sorted);
int pxp_object_exist(char *objname, Name_list *objectnames);


////////////////////////////////////////////////////////////////////////////
// a couple of handy utils:
////////////////////////////////////////////////////////////////////////////
void mallocerr(void){
	if(stud_r3)
		gfx_continu_line("Out of memory.");

	dialog_done = 1;
}

// returns the first occurance of atom in array or -1 if not in array
int Member_i(int atom, int *array, int len){
int i;

	for(i = 0; i < len; i++){
		if(atom == array[i])
			return(i);
	}

	return(-1);
}

////////////////////////////////////////////////////////////////////////////
//                        pxp_get_new_name
////////////////////////////////////////////////////////////////////////////
void pxp_get_new_name(char *newname, char *oldname, Name_list *objectnames){
int plus = 0;
int nlen;

// get the base name from oldname
	nlen = strlen(oldname);
	if(nlen == 10)
		oldname[8] = '\0';
	else if(nlen > 2 && isdigit(oldname[nlen-1]) && isdigit(oldname[nlen-2]) && isalpha(oldname[nlen-3]))
		oldname[nlen-2] = '\0';

	do {
		sprintf(newname, "%02d", ++plus);
		nlen = 10 - strlen(newname);
		oldname[nlen] = '\0';
		sprintf(newname, "%s%02d", oldname, plus);
	} while(pxp_object_exist(newname, objectnames));
}

////////////////////////////////////////////////////////////////////////////
//                        pxp_get_object_index
////////////////////////////////////////////////////////////////////////////
void pxp_get_object_index(char *objname, int *index){
ItemData *itemdata = NULL;
int i, status;
int icount;

	pxp_get_item_count(icount);
	if(NULL == (itemdata = (ItemData *)malloc(sizeof(ItemData) + 1))){
		mallocerr();
		return;
	}

	for(i = 1; i < icount; i++){ // i = 1 : $AMBIENT$ is always item 0
		pxp_get_item(i, itemdata, status);
		if(status && itemdata->type == PXPMESH){ // mesh object
			if(!(strcmp(objname, itemdata->name))){
				*index = i;
				return;
			}
		}
	}
	*index = 0;
	if(itemdata)
		free(itemdata);
}


////////////////////////////////////////////////////////////////////////////
//                        pxp_get_object_names
////////////////////////////////////////////////////////////////////////////
int pxp_get_object_names(Name_list *objectnames, int sorted){
ItemData *itemdata = NULL;
int i, status;
int icount, mcount;

	pxp_get_item_count(icount);
	if(NULL == (itemdata = (ItemData *)malloc(sizeof(ItemData) + 1))){
		mallocerr();
		return(0);
	}

	mcount = 0;
	for(i = 1; i < icount; i++){ // i = 1 : $AMBIENT$ is always item 0
		pxp_get_item(i, itemdata, status);
		if(status && itemdata->type == PXPMESH){ // mesh object
			add_to_name_list(&objectnames, itemdata->name);
			mcount++;
		}
	}

	if(sorted)
		sort_name_list(objectnames);

	if(itemdata)
		free(itemdata);

	return(mcount);
}


////////////////////////////////////////////////////////////////////////////
//                        pxp_object_exist
////////////////////////////////////////////////////////////////////////////
// CAUTION: objectnames must be sorted by sort_name_list()
// I could have written this for unsorted but it would be slower
int pxp_object_exist(char *objname, Name_list *objectnames){
Name_list *names;
int cmpval;

	names = objectnames;
	while(names){
		cmpval = strcmp(objname, names->name);
		if(!cmpval)
			return(1);

	// remove this line if you want to support unsorted Name_lists
		if(cmpval > 0) // past its sorted place in objectnames
			return(0);

		names = names->next;
	}
	return(0);
}


