@(debug,off)
@(-) --------------------------------------------------------------------
@(-)                  DCLC_C__.TPL -- template for generation of .c files
@(-)                                  using DCL files
@(-) --------------------------------------------------------------------
@(-)
@(time)
@(-)
@(form,fd,"%d")
@(form,fu,"%u")
@(form,f02u,"%02u")
@(form,f3u,"%3u")
@(form,f03u,"%03u")
@(form,fs,"%s")
@(form,ff,"%4.2f")
@(-)
/***********************************************************************/
/** @(tab,20) @(fs,file_name).c @(tab,71)**/
/** @(tab,20) generated at @(fu,day).@(f02u,month).@(fu,year), @(fu,hour):@(f02u,minute):@(f02u,second) @(tab,71)**/
/***********************************************************************/


/* ------------------------------------------------------------------- */
# include <stdio.h>
# include <string.h>
# include <adslib.h>
# include <adsdlg.h>
# include "@(fs,file_name).h"
/* ------------------------------------------------------------------- */


/* ------------------------------------------------------------------- */
/*                                 define dialogue parameter structure */
typedef struct
    {
    char * dcb_file_name;
    char * dcl_file_name;
    char * dialogue_name;
    }
    _@(fs,Prefix)_dlg_@(fs,Dlg);
/*                 declare and initialize dialogue parameter structure */
static  _@(fs,Prefix)_dlg_@(fs,Dlg)   @(fs,Prefix)_dlg =
    {
    "@(fs,file_name).dcb",
    "@(fs,file_name).dcl",
    "@(fs,Prefix)_@(fs,dlg_name)"
    };
/* ------------------------------------------------------------------- */


/* ------------------------------------------------------------------- */
/*              declare and initialize application parameter structure */
static  _@(fs,Prefix)_@(fs,Dlg)   @(fs,Prefix) =
    {
    0,                @(tab,30)/* int         state;     @(tab,72)*/
@(loop)                                       loop through all keys
@(if,edit_box)                                edit_box:
@(if,is_string)
@(if,has_edit_limit)
    { 0, },           @(tab,30)/* char        @(fs,Key) [@(fu,edit_limit)+1]; @(tab,72)*/
    @(fu,edit_limit), @(tab,30)/* short       edit_limit_@(fs,Key); @(tab,72)*/
@(endif)
@(ifnot,has_edit_limit)
    { 0, },           @(tab,30)/* char        @(fs,Key) [TILE_STR_LIMIT+1]; @(tab,72)*/
    TILE_STR_LIMIT,   @(tab,30)/* short       edit_limit_@(fs,Key); @(tab,72)*/
@(endif)
@(endif)
@(if,is_short)
    0,                @(tab,30)/* short       @(fs,Key); @(tab,72)*/
@(endif)
@(if,is_integer)
    0,                @(tab,30)/* int         @(fs,Key); @(tab,72)*/
@(endif)
@(if,is_long)
    0L,               @(tab,30)/* long        @(fs,Key); @(tab,72)*/
@(endif)
@(if,is_ads_real)
    0.0,              @(tab,30)/* ads_real    @(fs,Key); @(tab,72)*/
@(endif)
@(if,is_2D_point)
    {0.0,0.0},        @(tab,30)/* ads_real    @(fs,Key) [2]; @(tab,72)*/
@(endif)
@(if,is_3D_point)
    {0.0,0.0,0.0},    @(tab,30)/* ads_point   @(fs,Key); @(tab,72)*/
@(endif)
@(endif)
@(if,toggle)
@(ifnot,has_value)
    FALSE,            @(tab,30)/* short       @(fs,Key); @(tab,72)*/
@(endif)
@(if,has_value)
    TRUE,             @(tab,30)/* short       @(fs,Key); @(tab,72)*/
@(endif)
@(endif)
@(if,radio_button)
@(ifnot,has_value)
    FALSE,            @(tab,30)/* short       @(fs,Key); @(tab,72)*/
@(endif)
@(if,has_value)
    TRUE,             @(tab,30)/* short       @(fs,Key); @(tab,72)*/
@(endif)
@(endif)
@(if,slider)
    @(fd,min_value),       @(tab,30)/* short       @(fs,Key)_min_v; @(tab,72)*/
    @(fd,slider_value),    @(tab,30)/* short       @(fs,Key)_value; @(tab,72)*/
    @(fd,max_value),       @(tab,30)/* short       @(fs,Key)_max_v; @(tab,72)*/
    @(fd,big_increment),   @(tab,30)/* short       @(fs,Key)_big_i; @(tab,72)*/
    @(ff,small_increment), @(tab,30)/* ads_real    @(fs,Key)_sma_i; @(tab,72)*/
@(endif)
@(if,popup_list)
    0,                     @(tab,30)/* int         @(fs,Key)_index; @(tab,72)*/
@(endif)
@(if,has_slide)
    "@(fs,slide_name)",    @(tab,30)/* char *      @(fs,Key)_slide; @(tab,72)*/
@(endif)
@(if,is_help)
    "@(fs,help_file)",     @(tab,30)/* char *      @(fs,Key)_help;  @(tab,72)*/
@(endif)
@(if,is_topic)
    "@(fs,help_topic)",    @(tab,30)/* char *      @(fs,Key)_topic; @(tab,72)*/
@(endif)
@(if,is_info)
    "@(fs,info_name)",     @(tab,30)/* char *      @(fs,Key)_info;  @(tab,72)*/
@(endif)
@(endloop)
    };
/* ------------------------------------------------------------------- */


/* ------------------------------------------------------------------- */
/*                                               enumerate key strings */
enum key_str_enum
    {
@(loop)
    key_@(fs,Key),
@(endloop)
    };
/*                              declare and initialize key string list */
static  char * key_str [] =
    {
@(loop)
    "@(fs,Key)", @(tab,40)/* key_str [key_@(fs,Key)] @(tab,72)*/
@(endloop)
    };
/* ------------------------------------------------------------------- */


/* ------------------------------------------------------------------- */
/*                  prototypes of call back functions                  */
/* ------------------------------------------------------------------- */
@(loop)
@(if,is_callback)
static  void  CALLB  @(fs,Key)_cb @(tab,45)(ads_callback_packet * cpkt);
@(endif)
@(endloop)
/* ------------------------------------------------------------------- */


/* ------------------------------------------------------------------- */
        _@(fs,Prefix)_@(fs,Dlg) * hdl_@(fs,Dlg) (void)
/* ------------------------------------------------------------------- */
    {
    return (& @(fs,Prefix));
    }
/* ------------------------------------------------------------------- */


/* ------------------------------------------------------------------- */
        int   dlg_@(fs,Dlg) (void)
/* ------------------------------------------------------------------- */
    {
    int        rc;        /* return code    */
    int        dcl_id;    /* dcl identifier */
    ads_hdlg   hdlg;      /* dialog handle  */

    rc = ads_load_dialog   (@(fs,Prefix)_dlg.dcl_file_name,&dcl_id);
    if  (rc != RTNORM)
        {
        ads_fail ("cannot load DCL file");
        return   (rc);
        }

    ads_new_dialog    (@(fs,Prefix)_dlg.dialogue_name,dcl_id,NULLCB,&hdlg);
    if  (hdlg == NULL )
        {
        ads_fail ("cannot initialize");
        return   (rc);
        }

  # define CF CLIENTFUNC
  # define AT ads_action_tile
@(loop)
@(if,is_callback)
    AT (hdlg,key_str [key_@(fs,Key)] @(tab,45),(CF) @(fs,Key)_cb);
@(endif)
@(endloop)
  # undef  CF
  # undef  AT

    {
    /* --------------------------------------------------------------- */
    /*          >>>> hier eigene Initialisierung codieren <<<<         */
    /* --------------------------------------------------------------- */
    /*               Elemente, die nicht 'callback' sind:              */
    /* --------------------------------------------------------------- */
@(loop)
@(ifnot,is_callback)
    /* @(fs,Prefix)_@(f03u,control_id)  @(fs,control_name) @(tab,72)*/
    /*         key        "@(fs,Key)" @(tab,72)*/
@(if,has_label)
    /*         label      "@(fs,label)" @(tab,72)*/
@(endif)
@(if,has_slide)
    /*         slide_name "@(fs,slide_name)" @(tab,72)*/
@(endif)
@(if,has_label)
    /*         has_label @(tab,72)*/
@(endif)
@(if,has_value)
    /*         has_value @(tab,72)*/
@(endif)
@(if,has_slide)
    /*         has_slide @(tab,72)*/
@(endif)
@(endif)  ifnot is_callback
@(endloop)
    /* --------------------------------------------------------------- */
    }

    ads_start_dialog  (hdlg,&rc);
    ads_unload_dialog (dcl_id);

    {
    /* --------------------------------------------------------------- */
    /*        >>>> hier Wert von return code 'rc' codieren <<<<        */
    /* --------------------------------------------------------------- */
    }

    return (rc);
    }
/* ------------------------------------------------------------------- */


/***********************************************************************/
/**                        call back functions                        **/
/***********************************************************************/
@(loop)
@(if,is_callback)


/* ------------------------------------------------------------------- */
/* @(fs,Prefix)_@(f03u,control_id)  @(fs,control_name) @(tab,72)*/
/*         key             "@(fs,Key)" @(tab,72)*/
@(if,has_label)
/*         label           "@(fs,label)" @(tab,72)*/
@(endif)
@(-) ------------------------------------------
@(if,has_value)
@(ifnot,slider)
/*         value           "@(fs,value)" @(tab,72)*/
@(endif)
@(if,slider)
/*         min_value       @(fd,min_value)       @(tab,72)*/
/*         value           @(fd,slider_value)    @(tab,72)*/
/*         max_value       @(fd,max_value)       @(tab,72)*/
/*         big_increment   @(fd,big_increment)   @(tab,72)*/
/*         small_increment @(ff,small_increment) @(tab,72)*/
@(endif)
@(endif)
@(-) ------------------------------------------
@(if,edit_box)
@(if,has_edit_limit)
/*         edit_limit      @(f3u,edit_limit)      @(tab,72)*/
@(endif)
@(ifnot,has_edit_limit)
/*         edit_limit      TILE_STR_LIMIT (default) @(tab,72)*/
@(endif)
@(endif)
@(if,has_slide)
/*         slide_name      "@(fs,slide_name)"     @(tab,72)*/
@(endif)
@(if,is_help)
/*         help_file       "@(fs,help_file)"      @(tab,72)*/
@(endif)
@(if,is_topic)
/*         help_topic      "@(fs,help_topic)"     @(tab,72)*/
@(endif)
@(if,is_info)
/*         info_name       "@(fs,info_name)"      @(tab,72)*/
@(endif)
@(if,has_label)
/*         has_label      @(tab,72)*/
@(endif)
@(if,has_value)
/*         has_value      @(tab,72)*/
@(endif)
@(if,has_edit_limit)
/*         has_edit_limit @(tab,72)*/
@(endif)
@(if,has_slide)
/*         has_slide      @(tab,72)*/
@(endif)
@(if,is_default)
/*         is_default     @(tab,72)*/
@(endif)
@(if,is_cancel)
/*         is_cancel      @(tab,72)*/
@(endif)
@(if,is_help)
/*         is_help        @(tab,72)*/
@(endif)
@(if,is_topic)
/*         is_topic       @(tab,72)*/
@(endif)
@(if,is_info)
/*         is_info        @(tab,72)*/
@(endif)
@(if,is_callback)
/*         is_callback    @(tab,72)*/
@(endif)
@(if,edit_box)
@(if,is_string)
/*         is_string      @(tab,72)*/
@(endif)
@(if,is_short)
/*         is_short       @(tab,72)*/
@(endif)
@(if,is_integer)
/*         is_integer     @(tab,72)*/
@(endif)
@(if,is_long)
/*         is_long        @(tab,72)*/
@(endif)
@(if,is_ads_real)
/*         is_ads_real    @(tab,72)*/
@(endif)
@(if,is_2D_point)
/*         is_2D_point    @(tab,72)*/
@(endif)
@(if,is_3D_point)
/*         is_3D_point    @(tab,72)*/
@(endif)
@(endif)
/* ------------------------------------------------------------------- */
static  void  CALLB  @(fs,Key)_cb @(tab,45)(ads_callback_packet * cpkt)
/* ------------------------------------------------------------------- */
    {
@(if,is_default)
    ads_done_dialog (cpkt ->dialog,1);
@(endif)
@(if,is_cancel)
    ads_done_dialog (cpkt ->dialog,0);
@(endif)
    return;
    }
/* ------------------------------------------------------------------- */
@(endif)
@(endloop)
@(-)
@(-) --------------------------------------------------------------------
@(-)                           end of template for generation of .c files
@(-) --------------------------------------------------------------------
