#ifndef ITERATOR_H
#define ITERATOR_H

#include "object.h"

class Collection;
class Link;

extern const Class class_Iterator;

////////////////////////////////////////////////////////////
// class Iterator (declaration)
////////////////////////////////////////////////////////////
class Iterator: public Object {
    Collection* cltn;           // Collection being iterated over
public:
                ////////////////////////////
                // public instance variables
                ////////////////////////////
    int         index;          // index of next Object
    Object*     ptr;            // pointer to current Object or NULL
    unsigned    num;            // object number, used by Bags
public:
                // constructors, destructors
                Iterator(const Collection&);

                // operators
    Object*     operator++();                   // advance to next object
                                                // in Collection
    bool        operator==(const Iterator&) const;
    bool        operator!=(const Iterator& a) const
                                                { return !(*this==a); }

    void                    reset();            // reset to beginning
                                                // of Collection
    Collection*             collection() const  { return cltn; }
    virtual Object*         copy() const;       // shallowCopy()
    virtual void            deepenShallowCopy();// copy with cltn->deepCopy()
    virtual unsigned        hash() const;
    virtual const Class*    isA() const;
    virtual bool            isEqual(const Object&) const;
    virtual void            printOn(ostream& strm) const;
    virtual Object*         shallowCopy() const;// copy with cltn->copy()
    virtual const Class*    species() const;
};

////////////////////////////////////////////////////////////
// Iteration macros for collections
//
// DO(cltn,cls,arg) ... DONE
// DO inserts an inline while loop
// DONE closes the blocks specified by DO 
////////////////////////////////////////////////////////////
#define DO(cltn,cls,arg)                        \
        { cls arg;                              \
            Iterator DO_pos(cltn);              \
            while ((arg = (cls)++DO_pos) != 0)  \
            {

#define DONE }}

#endif
