#include "object.h"

extern const Class class_Nil;

class Nil : public Object {
public: 
    Nil() {}
    virtual int         compare(const Object&)  const;  // compare objects
    virtual Object*     copy()                  const;  // copy returns nil
    virtual Object*     deepCopy()              const;  // copy returns nil
    virtual unsigned    hash()                  const;  // calculate object hash
    virtual const       Class* isA()            const;
    virtual bool        isEqual(const Object&)  const;  // equality test
    virtual void        printOn(ostream& strm)  const;
    virtual Object*     shallowCopy()           const;  // copy returns nil
};

#define THIS    Nil
#define BASE    Object
DEFINE_CLASS(Nil,Object);


static const Nil nil_object;                            // the nil object 
extern const Object* const nil = (Object*)&nil_object;  // pointer to the nil object 
                         

bool        Nil::isEqual(const Object& ob) const        {   return (&ob==nil); }
unsigned    Nil::hash() const                           { return 0; }
int         Nil::compare(const Object& ob) const
            {
                assertArgSpecies(ob,class_Nil,"compare");
                return 0;
            }
Object*     Nil::copy() const                           { return (Object*) nil; }
Object*     Nil::shallowCopy() const                    { return (Object*) nil; }
Object*     Nil::deepCopy() const                       { return (Object*) nil; }
void        Nil::printOn(ostream& strm) const           { strm << "NIL"; }

