#include "object.h"
#include "oopsconf.h"
#include <stdlib.h>    // for exit


void Object::printOn(ostream&) const
{
    DTerror("Derived Class Responsibility:", "Object::printOn");
    exit(1);
}

bool Object::isEqual(const Object&) const
{
    DTerror("Derived Class Responsibility:", "Object::isEqual");
    return NO;
}

unsigned Object::hash() const
{
    derivedClassResponsibility("hash");
    return 0;
}

int Object::compare(const Object&) const
{
    DTerror("derivedClassResponsibility", "compare");
    DTerror("Derived Class Responsibility:", "Object::compare");
    return 0;
}

Object* Object::copy() const
{
    return deepCopy();
}

unsigned Object::size() const { return 0; }       // # of objects in Array.container subclass
 
unsigned Object::capacity() const { return 0; }   // subClass.capacity
 
const Class* Object::isA() const
{
    DTerror("isA() function not defined for some class: ","");
    exit(1);
    return 0;
}

Object* Object::shallowCopy() const
{
#if 0
//-gmv debug stuff
// div_sizeof_ptr is machine dependent
// see oopsconf(ig).h
    cout << "HELLO FROM ======Object* Object::shallowCopy()===\\/===\n";
    Class *clss = (Class*)isA();
    unsigned clssSize = clss->size();
    unsigned voidSize = (sizeof(void*));
    unsigned objSize = div_sizeof_ptr(clssSize+(sizeof(void*)-1));
#endif
    unsigned i = div_sizeof_ptr((isA()->size()+(sizeof(void*)-1)));
    //unsigned i = div_sizeof_ptr((((Class*)isA())->size()+(sizeof(void*)-1)));

    void** p = (void**)this;
    void** q = new void*[i];
    Object* o = (Object*)q;
    while (i--) *q++ = *p++;
    return o;
}

#include "identdic.h"
#include "assoc.h"
static IdentDict* deepCopyDict =0;  // object ID -> object copy
                                    // dictionary for deepCopy
 
Object* Object::deepCopy() const
{
#if 0
    cout << "error: Object::deepCopy() not implemented\n";
    exit(1);
    return (Object*)0;
#else
    bool firstObject = NO;
    if (deepCopyDict == 0) {
        deepCopyDict = new IdentDict;
        deepCopyDict->add(*new Assoc(*nil,*nil));
        firstObject = YES;
    }
    Assoc* asc = (Assoc*)&deepCopyDict->assocAt(*this);
    if (asc == nil) {           // object has not been copied 
        Object* copy = Object::shallowCopy();   // make a shallow copy 
        deepCopyDict->add(*new Assoc(*this,*copy)); // add to dictionary 
        copy->deepenShallowCopy();  // convert shallow copy to deep copy 
        if (firstObject) {      // delete the deepCopy dictionary 
            DO(*deepCopyDict,Assoc*,asc) delete asc; DONE
            delete deepCopyDict;
            deepCopyDict = 0;
        }
        return copy;
    }
    else return asc->value();   // object already copied,
                                // just return object reference
#endif
}

void Object::deepenShallowCopy()
{
    derivedClassResponsibility("deepenShallowCopy");
}


const Class* Object::species() const  { return isA(); }


bool Object::isKindOf(const Class& clid) const
{
    const Class* cl = isA();
    do {
        if (cl == &clid) return YES;
        cl = cl->baseClass();
    } while (cl != (Class*) 0);
    return NO;
}

void Object::derivedClassResponsibility(const char* fname) const
{
    DTerror("", "");
    cerr << "Unimplemented function: "
         << this << "->"
         << className() << "::"
         << fname
         << "\n";
}

void Object::shouldNotImplement(const char* fname) const
{
    DTerror("Illegal function: ",fname);
}

void invalidArgClass(const Object& ob,
                     const Class& expect,
                     const char* fname)
{
    DTerror("Invalid argument class.", "");
    cerr << "Expected "
         << fname << "(" << expect.className() << ")"
         << ", was "
         << fname << "(" << ob.className() << ")"
         << "\n";
}

void invalidArgSpecies(const Object& ob,
                       const Class& expect,
                       const char* fname)
{
    DTerror("Invalid argument species: ", "");
    cerr << "Expected "
         << fname << "(" << expect.className() << ")"
         << ", was "
         << fname << "(" << ob.species()->className() << ")"
         << "\n";
}

void Object::invalidArgClass(const Object& ob,
                             const Class& expect,
                             const char* fname) const
{
    DTerror("Invalid argument class: ", "");
    cerr << "Expected "
         << className() << "::"
         << fname << "(" << expect.className() << ")"
         << ", was "
         << className() << "::"
         << fname << "(" << ob.className() << ")"
         << "\n";
}

void Object::invalidArgSpecies(const Object& ob,
                               const Class& expect,
                               const char* fname) const
{
    DTerror("Invalid argument species: ", "");
    cerr << "Expected "
         << className() << "::"
         << fname << "(" << expect.className() << ")"
         << ", was "
         << className() << "::"
         << fname << "(" << ob.species()->className() << ")"
         << "\n";
}

void invalidClass(const Object& ob, const Class& expect)
{
    DTerror("Invalid argument class: ", "");
    cerr << "Expected "
         << expect.className()
         << ", was "
         << ob.className()
         << "\n";
}

void invalidSpecies(const Object& ob, const Class& expect)
{
    DTerror("Invalid object species: ", "");
    cerr << "Expected "
         << expect.className()
         << ", was "
         << ob.species()->className()
         << "\n";
}


//====object.cpp====/\



//====class.cpp====\/

Class::Class(const Class& super, const char* name, unsigned size)
{
    superClass = &super;
    class_name = name;
    inst_size = size;
}

void Class::printOn(ostream& strm) const
{
    strm << class_name;
}

bool Class::isEqual(const Object& ob) const
{
    return this == (Class*)&ob;
}

unsigned Class::size() const
{
    return inst_size;
}

const Class* Class::isA() const
{
    return &class_Class;
}

//====class.cpp====/\

////////////////////////////////////////////////////////////
// define class_Object
////////////////////////////////////////////////////////////
const Class class_Object = Class (*(Class*)0, "Object", sizeof(Object));

////////////////////////////////////////////////////////////
// define class_Class
////////////////////////////////////////////////////////////
const Class class_Class = Class( class_Object, "Class", sizeof(Class));

void DTerror(const char* s1, const char* s2)
{
    //cout << "DiskTutor Object Library error: "
    cerr << "DiskTutor Object Library error: "
         << s1
         << " "
         << s2
         << "\n";
}

